/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.FileBrowserTextField;
import oracle.eclipse.tools.common.ui.widgets.PropertyTable;
import oracle.eclipse.tools.common.util.XmlParseException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.j2eelib.ClasspathEntry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.j2eelib.LibrariesConfigurationPanel;
import oracle.eclipse.tools.weblogic.ui.j2eelib.SharedLibrariesFrameworkUi;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LibraryModuleConfigDialog
extends Dialog {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private final boolean webOnly;
    private FileBrowserTextField location;
    private Label tableLabel;
    private PropertyTable table;
    private Label libconfigLabel;
    private LibrariesConfigurationPanel libconfig;
    private Label msglabel;
    private String msgtext = "";
    private Object msgowner = this;
    private LibraryModule oldLibraryModule = null;
    private LibraryModule libmodule = null;
    private boolean suppressLocationChangedEvents = false;
    private boolean suppressPropertyChangedEvents = false;

    public LibraryModuleConfigDialog(Shell shell, boolean webOnly) {
        this(shell, null, webOnly);
    }

    public LibraryModuleConfigDialog(Shell shell, LibraryModule libmodule, boolean webOnly) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.oldLibraryModule = libmodule;
        this.libmodule = libmodule;
        this.webOnly = webOnly;
    }

    public boolean isLibraryModuleValid() {
        return this.libmodule != null;
    }

    public LibraryModule getLibraryModule() {
        return this.libmodule;
    }

    protected Control createDialogArea(Composite parent) {
        String clname;
        IDialogSettings settings;
        IDialogSettings root = WlsUiPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings = settings = root.getSection(clname = ((Object)((Object)this)).getClass().getName()) != null ? root.getSection(clname) : root.addNewSection(clname);
        if (settings.get(WIDTH) == null) {
            settings.put(WIDTH, 400);
        }
        if (settings.get(HEIGHT) == null) {
            settings.put(HEIGHT, 300);
        }
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData d0 = SwtUtil.gdfill();
        d0.widthHint = settings.getInt(WIDTH);
        d0.heightHint = settings.getInt(HEIGHT);
        composite.setLayoutData((Object)d0);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = composite.getSize();
                settings.put(LibraryModuleConfigDialog.WIDTH, size.x);
                settings.put(LibraryModuleConfigDialog.HEIGHT, size.y);
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Resources.locationLabel);
        label.setLayoutData((Object)SwtUtil.gdhfill());
        this.location = new FileBrowserTextField(composite, 0);
        this.location.setLayoutData((Object)SwtUtil.gdhfill());
        if (this.webOnly) {
            this.location.setFilterExtensions(SharedLibrariesFrameworkUi.BROWSE_FILTER_EXTENSIONS_WEBONLY);
            this.location.setFilterNames(SharedLibrariesFrameworkUi.BROWSE_FILTER_NAMES_WEBONLY);
        } else {
            this.location.setFilterExtensions(SharedLibrariesFrameworkUi.BROWSE_FILTER_EXTENSIONS);
            this.location.setFilterNames(SharedLibrariesFrameworkUi.BROWSE_FILTER_NAMES);
        }
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                LibraryModuleConfigDialog.this.locationChanged();
            }
        });
        this.tableLabel = new Label(composite, 0);
        this.tableLabel.setText(Resources.attributesLabel);
        this.tableLabel.setLayoutData((Object)SwtUtil.gdhfill());
        this.table = new PropertyTable(composite);
        this.table.setLayoutData((Object)SwtUtil.gdhfill());
        this.table.defineProperty(Resources.nameProperty);
        this.table.defineProperty(Resources.specVersionProperty);
        this.table.defineProperty(Resources.implVersionProperty);
        this.table.setMessageDisplay((PropertyTable.IMessageDisplay)new MessageDisplay());
        this.table.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                LibraryModuleConfigDialog.this.propertyChanged();
            }
        });
        this.libconfigLabel = new Label(composite, 0);
        this.libconfigLabel.setText(Resources.classpathContribution);
        this.libconfigLabel.setLayoutData((Object)SwtUtil.gdhfill());
        this.libconfig = new LibrariesConfigurationPanel(composite, 0);
        this.libconfig.setLayoutData(SwtUtil.gdfill());
        this.libconfig.addListener(new Listener(){

            public void handleEvent(Event event) {
                LibraryModuleConfigDialog.this.classpathChanged();
            }
        });
        this.msglabel = new Label(composite, 0);
        this.msglabel.setLayoutData((Object)SwtUtil.gdhfill());
        this.msglabel.setForeground(SwtUtil.color((int)3));
        if (this.libmodule != null) {
            this.suppressLocationChangedEvents = true;
            this.location.setFile(this.libmodule.getLocation());
            this.suppressLocationChangedEvents = false;
        }
        this.update();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.libmodule == null) {
            shell.setText(Resources.dialogTitleForAdd);
        } else {
            shell.setText(Resources.dialogTitleForEdit);
        }
    }

    protected void cancelPressed() {
        this.libmodule = null;
        super.cancelPressed();
    }

    private void update() {
        this.updateClasspathConfigView();
        this.updatePropertiesView();
        this.updateButtonEnablement();
    }

    private void updatePropertiesView() {
        this.suppressPropertyChangedEvents = true;
        if (this.libmodule != null) {
            this.tableLabel.setEnabled(true);
            this.table.setEnabled(true);
            this.setProperty(Resources.nameProperty, this.libmodule.getName(), this.libmodule.isNameModifiable(), Resources.cannotOverrideName);
            this.setProperty(Resources.specVersionProperty, this.libmodule.getSpecificationVersion(), this.libmodule.isSpecificationVersionModifiable(), Resources.cannotOverrideSpecVersion);
            this.setProperty(Resources.implVersionProperty, this.libmodule.getImplementationVersion(), this.libmodule.isImplementationVersionModifiable(), Resources.cannotOverrideImplVersion);
        } else {
            this.tableLabel.setEnabled(false);
            this.table.setEnabled(false);
            this.table.setProperty(Resources.nameProperty, null);
            this.table.setProperty(Resources.specVersionProperty, null);
            this.table.setProperty(Resources.implVersionProperty, null);
            this.table.clearSelection();
        }
        this.suppressPropertyChangedEvents = false;
    }

    private void updateClasspathConfigView() {
        Set cp = Collections.emptySet();
        if (this.libmodule != null) {
            try {
                cp = this.libmodule.getClasspathEntries();
            }
            catch (XmlParseException xmlParseException) {
                this.displayMessage(Resources.selectValidFile);
                this.libmodule = null;
            }
            catch (IOException e) {
                this.displayMessage(Resources.selectValidFile);
                this.libmodule = null;
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
            }
        }
        if (cp.size() > 0) {
            this.libconfigLabel.setEnabled(true);
            this.libconfig.setEnabled(true);
        } else {
            this.libconfigLabel.setEnabled(false);
            this.libconfig.setEnabled(false);
        }
        ArrayList<LibrariesConfigurationPanel.LibraryDescription> libs = new ArrayList<LibrariesConfigurationPanel.LibraryDescription>(cp.size());
        for (ClasspathEntry cpe : cp) {
            Path path = new Path(cpe.getLocation().getAbsolutePath());
            Path relpath = new Path(cpe.getRelativePath());
            File src = cpe.getSourceLocaton();
            URL javadoc = cpe.getJavadocLocation();
            Path srcpath = src == null ? null : new Path(src.getAbsolutePath());
            libs.add(new LibrariesConfigurationPanel.LibraryDescription((IPath)path, (IPath)relpath, (IPath)srcpath, javadoc));
        }
        this.libconfig.setLibraries(libs);
    }

    protected void updateButtonEnablement() {
        boolean enabled;
        LibraryModuleRegistry reg = LibraryModulesSvc.getRegistry();
        if (this.libmodule == null) {
            enabled = false;
        } else if (reg.isConflicting(this.libmodule, this.oldLibraryModule)) {
            enabled = false;
            this.displayMessage(Resources.conflicting);
        } else {
            enabled = true;
        }
        this.setOkButtonEnabled(enabled);
    }

    private void setProperty(String name, Object value, boolean modifiable, String nonModifiableMsg) {
        this.table.setProperty(name, value == null ? null : value.toString());
        this.table.setModifiable(name, modifiable, nonModifiableMsg);
    }

    private void locationChanged() {
        if (this.suppressLocationChangedEvents) {
            return;
        }
        this.libmodule = null;
        File f = this.location.getFile();
        if (f == null) {
            this.displayMessage(Resources.selectFile);
        } else if (!f.isFile()) {
            this.displayMessage(Resources.selectValidFile);
        } else {
            try {
                this.libmodule = new LibraryModule(this.location.getFile(), null, null, null, null, null, LibraryModulesSvc.getTempDir());
                this.clearMessage();
            }
            catch (IOException iOException) {
                this.displayMessage(Resources.selectValidFile);
            }
        }
        this.update();
    }

    private void propertyChanged() {
        if (this.suppressPropertyChangedEvents) {
            return;
        }
        String name = this.libmodule.getName();
        Version specVersion = this.libmodule.getSpecificationVersion();
        Version implVersion = this.libmodule.getImplementationVersion();
        String nameInTable = this.table.getProperty(Resources.nameProperty);
        String specVersionInTable = this.table.getProperty(Resources.specVersionProperty);
        String implVersionInTable = this.table.getProperty(Resources.implVersionProperty);
        if (nameInTable == null) {
            this.libmodule = null;
            this.displayMessage(Resources.specifyNameAttr);
            return;
        }
        if (!name.equals(nameInTable)) {
            name = nameInTable;
        } else if (!LibraryModuleConfigDialog.equals(LibraryModuleConfigDialog.toStringOrNull(specVersion), specVersionInTable)) {
            specVersion = specVersionInTable == null ? null : new Version(specVersionInTable);
        } else if (!LibraryModuleConfigDialog.equals(LibraryModuleConfigDialog.toStringOrNull(implVersion), implVersionInTable)) {
            implVersion = implVersionInTable == null ? null : new Version(implVersionInTable);
        } else {
            return;
        }
        try {
            this.libmodule = new LibraryModule(this.libmodule.getLocation(), name, specVersion, implVersion, this.libmodule.getSourceLocations(true), this.libmodule.getJavadocLocations(true), LibraryModulesSvc.getTempDir());
            this.clearMessage();
        }
        catch (IOException iOException) {
            this.libmodule = null;
            this.displayMessage(Resources.selectValidFile);
        }
        this.update();
    }

    private void classpathChanged() {
        HashMap<String, File> sourceLocations = new HashMap<String, File>();
        HashMap<String, URL> javadocLocations = new HashMap<String, URL>();
        for (LibrariesConfigurationPanel.LibraryDescription lib : this.libconfig.getLibraries()) {
            String relstr = lib.getRelativeLibraryLocation().toPortableString();
            if (lib.getSourceLocation() != null) {
                sourceLocations.put(relstr, lib.getSourceLocation().toFile());
            }
            if (lib.getJavadocLocation() == null) continue;
            javadocLocations.put(relstr, lib.getJavadocLocation());
        }
        try {
            this.libmodule = new LibraryModule(this.libmodule.getLocation(), this.libmodule.getName(), this.libmodule.getSpecificationVersion(), this.libmodule.getImplementationVersion(), sourceLocations, javadocLocations, LibraryModulesSvc.getTempDir());
        }
        catch (IOException iOException) {
            this.libmodule = null;
            this.displayMessage(Resources.selectValidFile);
        }
    }

    private static String toStringOrNull(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    protected void setOkButtonEnabled(final boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        } else {
            final Display display = Display.getCurrent();
            Thread t = new Thread(){

                @Override
                public void run() {
                    Button b = LibraryModuleConfigDialog.this.getButton(0);
                    while (b == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        b = LibraryModuleConfigDialog.this.getButton(0);
                    }
                    final Button finalButton = b;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            finalButton.setEnabled(enabled);
                        }
                    });
                }
            };
            t.start();
        }
    }

    protected void displayMessage(String msg) {
        this.msgtext = msg;
        if (this.msgowner == this) {
            this.msglabel.setText(msg);
        }
    }

    protected void clearMessage() {
        this.msgtext = "";
        if (this.msgowner == this) {
            this.msglabel.setText("");
        }
    }

    private final class MessageDisplay
    implements PropertyTable.IMessageDisplay {
        private MessageDisplay() {
        }

        public void displayMessage(String msg) {
            LibraryModuleConfigDialog.this.msgowner = this;
            LibraryModuleConfigDialog.this.msglabel.setText(msg);
        }

        public void clearMessage() {
            if (!LibraryModuleConfigDialog.this.msglabel.isDisposed()) {
                LibraryModuleConfigDialog.this.msgowner = (Object)LibraryModuleConfigDialog.this;
                LibraryModuleConfigDialog.this.msglabel.setText(LibraryModuleConfigDialog.this.msgtext);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String locationLabel;
        public static String attributesLabel;
        public static String classpathContribution;
        public static String nameProperty;
        public static String specVersionProperty;
        public static String implVersionProperty;
        public static String dialogTitleForAdd;
        public static String dialogTitleForEdit;
        public static String selectFile;
        public static String selectValidFile;
        public static String specifyNameAttr;
        public static String cannotOverrideName;
        public static String cannotOverrideSpecVersion;
        public static String cannotOverrideImplVersion;
        public static String conflicting;

        static {
            Resources.initializeMessages((String)LibraryModuleConfigDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

