/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib;

import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.EnhancedHyperlink;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.ui.j2eelib.BrowseLibraryModulesPanel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class BrowseLibraryModulesDialog
extends Dialog {
    private boolean webOnly;
    private boolean allowMultiSelect;
    private BrowseLibraryModulesPanel libModulesPanel;
    private Set<LibraryModule> libModules;

    public BrowseLibraryModulesDialog(Shell shell, boolean webOnly) {
        this(shell, webOnly, false);
    }

    public BrowseLibraryModulesDialog(Shell shell, boolean webOnly, boolean allowMultiSelect) {
        super(shell);
        this.webOnly = webOnly;
        this.allowMultiSelect = allowMultiSelect;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public LibraryModule getLibraryModule() {
        return this.libModules.iterator().next();
    }

    public Set<LibraryModule> getLibraryModules() {
        return this.libModules;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdhhint((GridData)SwtUtil.gdwhint((GridData)SwtUtil.gdfill(), (int)400), (int)400));
        composite.setLayout((Layout)SwtUtil.glayout((int)1));
        this.libModulesPanel = new BrowseLibraryModulesPanel(composite, 0, false, this.webOnly);
        this.libModulesPanel.setLayoutData(SwtUtil.gdfill());
        this.libModulesPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseLibraryModulesDialog.this.refresh();
            }
        });
        this.libModulesPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (BrowseLibraryModulesDialog.this.isSelectionValid()) {
                    BrowseLibraryModulesDialog.this.okPressed();
                }
            }
        });
        this.refresh();
        EnhancedHyperlink link = new EnhancedHyperlink(composite, 0);
        link.setText(Resources.manageLibrariesLinkLabel);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BrowseLibraryModulesDialog.this.handleManageLinkSelected();
            }
        });
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.dialogTitle);
    }

    protected void okPressed() {
        this.libModules = this.libModulesPanel.getSelection();
        super.okPressed();
    }

    private boolean isSelectionValid() {
        int selectionSize = this.libModulesPanel.getSelection().size();
        return this.allowMultiSelect && selectionSize >= 1 || !this.allowMultiSelect && selectionSize == 1;
    }

    private void refresh() {
        this.setOkButtonEnabled(this.isSelectionValid());
    }

    private void handleManageLinkSelected() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModulesPreferencePage", (String[])new String[]{"oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModulesPreferencePage"}, null);
        dialog.open();
    }

    private void setOkButtonEnabled(final boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        } else {
            final Display display = Display.getCurrent();
            Thread t = new Thread(){

                @Override
                public void run() {
                    Button b = BrowseLibraryModulesDialog.this.getButton(0);
                    while (b == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        b = BrowseLibraryModulesDialog.this.getButton(0);
                    }
                    final Button finalButton = b;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            finalButton.setEnabled(enabled);
                        }
                    });
                }
            };
            t.start();
        }
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String manageLibrariesLinkLabel;

        static {
            Resources.initializeMessages((String)BrowseLibraryModulesDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

