/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.internal.validation;

import java.io.File;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;

public final class InvalidRuntimeLocationMarkerResolutions
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];
    private static final String ATTR_RUNTIME = "runtime";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        Shell shell = InvalidRuntimeLocationMarkerResolutions.findShell();
        if (shell == null) {
            return NO_RESOLUTION;
        }
        return new IMarkerResolution[]{new LocateRuntimeResolution(shell)};
    }

    private static Shell findShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window == null ? null : window.getShell();
    }

    private static final class LocateRuntimeResolution
    implements IMarkerResolution {
        private final Shell shell;

        public LocateRuntimeResolution(Shell shell) {
            this.shell = shell;
        }

        public String getLabel() {
            return Resources.locateRuntimeResolutionLabel;
        }

        public void run(IMarker marker) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
            File wlhome = null;
            IRuntimeComponentVersion locatedVersion = null;
            while (wlhome == null) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell);
                dialog.setMessage(Resources.locateRuntimeDialogMessage);
                String location = dialog.open();
                if (location == null) {
                    return;
                }
                wlhome = new File(location);
                locatedVersion = WlsRuntimeComponentType.detectVersion((File)wlhome);
                if (locatedVersion != null) continue;
                MessageDialog.openError((Shell)this.shell, (String)Resources.invalidLocationDialogTitle, (String)Resources.invalidLocationMessage);
                wlhome = null;
            }
            try {
                String runtimeName = (String)marker.getAttribute(InvalidRuntimeLocationMarkerResolutions.ATTR_RUNTIME);
                runtime = RuntimeManager.getRuntime((String)runtimeName);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (CoreException)e);
                return;
            }
            IRuntimeComponent wlscomp = WlsRuntimeUtil.getWlsRuntimeComponent((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            IRuntimeComponentVersion expectedVersion = wlscomp.getRuntimeComponentVersion();
            if (locatedVersion == expectedVersion) {
                IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
                IRuntimeWorkingCopy wc = r.createWorkingCopy();
                wc.setLocation((IPath)new Path(wlhome.getPath()));
                try {
                    wc.save(true, null);
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (CoreException)e);
                    DialogService.showErrorDialog((Throwable)e);
                }
                return;
            }
            String msg = Resources.bind(Resources.differentVersionLocatedMessage, ((IProject)marker.getResource()).getName(), expectedVersion.getVersionString(), locatedVersion.getVersionString());
            if (DialogService.showYesNoDialog((String)Resources.differentVersionLocatedDialogTitle, (String)msg)) {
                DialogService.showErrorDialog((String)"Not implemented yet!");
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String locateRuntimeResolutionLabel;
        public static String locateRuntimeDialogMessage;
        public static String invalidLocationMessage;
        public static String invalidLocationDialogTitle;
        public static String differentVersionLocatedMessage;
        public static String differentVersionLocatedDialogTitle;

        static {
            Resources.initializeMessages((String)InvalidRuntimeLocationMarkerResolutions.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static final String bind(String msg, String arg1, String arg2, String arg3) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }
}

