/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.wst.server.core.IRuntime;

public final class WebLogicRuntimeCreationListener
implements WlsRuntimeSpy.IListener {
    private static String MRU_RUNTIME_STORE = "MRU_RUNTIME_STORE";

    public void handleEvent(IRuntime runtime, WlsRuntimeSpy.EventType type) {
        if (type != WlsRuntimeSpy.EventType.ADDED) {
            return;
        }
        IDialogSettings settings = J2EEUIPlugin.getDefault().getDialogSettings();
        String[] mruRuntimeArray = settings.getArray(MRU_RUNTIME_STORE);
        ArrayList<String> mruRuntimes = new ArrayList<String>();
        if (mruRuntimeArray != null) {
            mruRuntimes.addAll(Arrays.asList(mruRuntimeArray));
        }
        String rname = RuntimeBridgeUtil.bridge((IRuntime)runtime).getName();
        mruRuntimes.remove(rname);
        mruRuntimes.add(0, rname);
        while (mruRuntimes.size() > 5) {
            mruRuntimes.remove(5);
        }
        mruRuntimeArray = mruRuntimes.toArray(new String[mruRuntimes.size()]);
        settings.put(MRU_RUNTIME_STORE, mruRuntimeArray);
    }
}

