/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.export.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.common.wtp.java.core.export.IArchiveProcessor;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class WLSArchiveProcessor
implements IArchiveProcessor {
    private static final ResourceLoader _resource = new ResourceLoader(WLSArchiveProcessor.class);
    private IDataModel _model;
    private boolean _initialized;
    private boolean _exploded;
    private Object LOCK = new Object();
    private Stack<ArchiveInfo> _archiveInfo = new Stack();
    private Map<String, String> _tempLocation = new HashMap<String, String>();
    private int _tempNum;
    private String _baseTempDir;
    private String _archiveDestPath;

    public WLSArchiveProcessor(IDataModel model) {
        this._model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this._initialized) {
                this._initialized = true;
                IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                this._baseTempDir = workspacePath.append(".metadata/.plugins/com.bea.wlw.export.archive/temp").toString();
            }
        }
    }

    public void close() {
        if (this._exploded) {
            this.assembleArchive();
        }
    }

    public String getTempLocationFor(IProject project) {
        if (project != null) {
            this.explodeArchive();
            return this._tempLocation.get(project.getName());
        }
        return null;
    }

    public IStatus copy(IProject project, String src, String destination) {
        return this.copy(project, src, null, destination);
    }

    public IStatus copy(IProject srcProject, String src, IProject destProject, String destination) {
        if (srcProject == null) {
            throw new IllegalArgumentException("source project cannot be null");
        }
        if (destProject == null) {
            destProject = srcProject;
        }
        IStatus status = Status.OK_STATUS;
        try {
            this.explodeArchive();
            IPath location = srcProject.getLocation();
            if (src != null && src.length() > 0) {
                location = location.append(src);
            }
            File source = new File(location.toString());
            String tempDir = this._tempLocation.get(destProject.getName());
            if (tempDir != null) {
                tempDir = tempDir.substring(0, tempDir.length() - 1);
                if (destination != null && destination.length() > 0) {
                    if ((destination = destination.replace('\\', '/')).endsWith("/")) {
                        destination = destination.substring(0, destination.length() - 1);
                    }
                    if (!destination.startsWith("/")) {
                        tempDir = tempDir.concat("/");
                    }
                    tempDir = tempDir.concat(destination);
                }
                this.doCopy(source, tempDir);
            }
        }
        catch (Exception e) {
            status = new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    public IStatus copy(IProject project, String src) {
        return this.copy(project, src, null, null);
    }

    public IStatus copy(String src, String destination) {
        IStatus status;
        block6: {
            if (src == null || destination == null) {
                throw new IllegalArgumentException("src and destination cannot be null");
            }
            status = Status.OK_STATUS;
            try {
                boolean validDestination = false;
                this.explodeArchive();
                for (String dest : this._tempLocation.values()) {
                    if (!destination.startsWith(dest)) continue;
                    validDestination = true;
                    break;
                }
                if (validDestination) {
                    if (destination.endsWith("/") || destination.endsWith("\\")) {
                        destination = destination.substring(0, destination.length() - 1);
                    }
                    File source = new File(src);
                    this.doCopy(source, destination);
                    break block6;
                }
                return new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, _resource.resource("destinationNotValid", new Object[]{destination}), null);
            }
            catch (Exception e) {
                status = new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return status;
    }

    private void doCopy(File src, String dest) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            File[] fileArray = src.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.doCopy(child, String.valueOf(dest) + "/" + child.getName());
                ++n2;
            }
        } else {
            EclipseFileUtil.copyFile((File)src, (File)new File(dest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explodeArchive() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this._exploded) {
                this._exploded = true;
                String destPath = this._model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
                File src = new File(destPath);
                try {
                    if (src.exists()) {
                        this._archiveDestPath = src.getCanonicalPath();
                        this.processFile(src);
                        this.moveUtilityJars();
                    } else {
                        Status status = new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, _resource.resource("archiveNotExist", new Object[]{destPath}), null);
                        WlsUiPlugin.getInstance().getLog().log((IStatus)status);
                    }
                }
                catch (Exception e) {
                    WlsUiPlugin.log(e);
                }
            }
        }
    }

    private void assembleArchive() {
        while (!this._archiveInfo.empty()) {
            ArchiveInfo info = this._archiveInfo.pop();
            try {
                ZipUtil.zip((File)new File(info.getTempDir()), (File)new File(info.getFileName()));
                this.delete(new File(info.getTempDir()));
            }
            catch (IOException ioe) {
                WlsUiPlugin.log(ioe);
            }
        }
    }

    private void processFile(File file) throws IOException, RuntimeException, Exception {
        if (file.isDirectory()) {
            String[] children = file.list();
            int i = 0;
            while (i < children.length) {
                this.processFile(new File(file, children[i]));
                ++i;
            }
        } else {
            String projectName;
            String filePath = file.getCanonicalPath();
            if ((filePath.endsWith(".war") || filePath.endsWith(".ear") || filePath.endsWith(".jar")) && (projectName = this.getAssociatedProject(filePath)) != null) {
                String tempDir = this.getTempDir();
                if (!this._tempLocation.containsKey(projectName)) {
                    this._tempLocation.put(projectName, tempDir);
                }
                ZipUtil.unzip((File)new File(filePath), (File)new File(tempDir));
                this._archiveInfo.push(new ArchiveInfo(tempDir, filePath));
                this.processFile(new File(tempDir));
            }
        }
    }

    private String getTempDir() {
        String dirName = String.valueOf(this._baseTempDir) + this._tempNum++ + "/";
        File dir = new File(dirName);
        while (dir.exists()) {
            dirName = String.valueOf(this._baseTempDir) + this._tempNum++ + "/";
            dir = new File(dirName);
        }
        dir.mkdir();
        return dirName;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.delete(child);
                child.delete();
                ++n2;
            }
        }
        file.delete();
    }

    private String getAssociatedProject(String archivePath) {
        if (archivePath.equals(this._archiveDestPath)) {
            return (String)this._model.getProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        }
        int idx = archivePath.lastIndexOf(File.separatorChar);
        if (idx != -1) {
            archivePath = archivePath.substring(idx + 1);
        }
        IVirtualComponent earComponent = (IVirtualComponent)this._model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        IVirtualReference[] iVirtualReferenceArray = earComponent.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String archive;
            IVirtualComponent refTarget;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (ref != null && (refTarget = ref.getReferencedComponent()) != null && !refTarget.isBinary() && (archive = ref.getArchiveName()) != null && archive.equals(archivePath)) {
                return refTarget.getProject().getName();
            }
            ++n2;
        }
        return null;
    }

    private void moveUtilityJars() {
        try {
            IVirtualComponent earComponent;
            IProject earProject;
            if (this._model.isNestedModel("ExportDataModelProvider") && WlsEarFacet.isInstalled((IProject)(earProject = (earComponent = (IVirtualComponent)this._model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT")).getProject()))) {
                BridgedRuntime rt = (BridgedRuntime)this._model.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME");
                if (rt != null && rt.supports(WlsEarFacet.VERSION_10_3)) {
                    return;
                }
                File earTempDir = new File(this.getTempLocationFor(earProject));
                File appInfLib = new File(earTempDir, "APP-INF/lib/");
                if (!appInfLib.exists()) {
                    appInfLib.mkdirs();
                }
                earTempDir.listFiles();
                IVirtualReference[] iVirtualReferenceArray = earComponent.getReferences();
                int n = iVirtualReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IVirtualComponent refTarget = ref.getReferencedComponent();
                    if (refTarget != null) {
                        String deployedName = refTarget.getDeployedName();
                        if (refTarget.isBinary() && refTarget.getDeployedName().toLowerCase().endsWith(".jar")) {
                            String jarName;
                            File oldArchive;
                            int lastSlash = deployedName.lastIndexOf(47);
                            if (lastSlash != -1 && (oldArchive = new File(earTempDir, jarName = deployedName.substring(lastSlash + 1))).exists() && !WtpProjectUtil.isEjbModule((IProject)earProject, (String)jarName)) {
                                File newArchive = new File(appInfLib, jarName);
                                oldArchive.renameTo(newArchive);
                            }
                        } else if (WtpProjectUtil.isUtilityProject((IProject)refTarget.getProject())) {
                            String archiveName = ref.getArchiveName();
                            IProject refTargetProject = refTarget.getProject();
                            String location = this.getTempLocationFor(refTargetProject);
                            if (location != null) {
                                File oldArchive2;
                                String dest = appInfLib + "/" + archiveName;
                                for (ArchiveInfo info : this._archiveInfo) {
                                    if (!info.getTempDir().equals(location)) continue;
                                    info._fileName = dest;
                                    break;
                                }
                                File oldArchive = new File(this.getTempLocationFor(earProject), archiveName);
                                if (oldArchive.exists()) {
                                    oldArchive.delete();
                                }
                                if ((oldArchive2 = new File(this.getTempLocationFor(earProject), "lib/" + archiveName)).exists()) {
                                    oldArchive2.delete();
                                }
                                this.handleBinaryDependencies(earTempDir, refTarget.getProject());
                            }
                        } else if (WtpProjectUtil.isEJBProject((IProject)refTarget.getProject())) {
                            this.handleBinaryDependencies(earTempDir, refTarget.getProject());
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ce) {
            WlsUiPlugin.log(ce);
        }
    }

    private void handleBinaryDependencies(File earTempDir, IProject project) {
        File appInfLib = new File(earTempDir, "APP-INF/lib/");
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference vref = iVirtualReferenceArray[n2];
            IVirtualComponent refComp = vref.getReferencedComponent();
            if (refComp instanceof VirtualArchiveComponent) {
                VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                File file = archComp.getUnderlyingDiskFile();
                File oldArchive = new File(earTempDir, file.getName());
                File newArchive = new File(appInfLib, file.getName());
                if (oldArchive.exists()) {
                    oldArchive.renameTo(newArchive);
                } else {
                    try {
                        FileUtil.copy((File)file, (File)newArchive);
                        File oldArchive2 = new File(earTempDir, "lib/" + file.getName());
                        if (oldArchive2.exists()) {
                            oldArchive2.delete();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    private static class ArchiveInfo {
        private String _tempDir;
        private String _fileName;

        public ArchiveInfo(String tempDir, String fileName) {
            this._tempDir = tempDir;
            this._fileName = fileName;
        }

        public String getTempDir() {
            return this._tempDir;
        }

        public String getFileName() {
            return this._fileName;
        }
    }
}

