/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ejb.properties;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectProperties;
import oracle.eclipse.tools.weblogic.ui.ejb.EJBProjectUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class EJBProjectPropertyPage
extends PropertyPage {
    private IProject _project;
    private Map<String, String> oldProps;
    private final Map<String, EJBGenProperty> _propertyMap = new LinkedHashMap<String, EJBGenProperty>();
    private static final String NAME = "name";
    private static final String HELP_CONTEXT_ID = ".weblogic_ejb_properties_context";

    protected synchronized void validateAllProperties() {
        Set<String> keySet = this._propertyMap.keySet();
        for (String propertyName : keySet) {
            EJBGenProperty property = this._propertyMap.get(propertyName);
            IStatus status = property.validate();
            if (status.getSeverity() == 4) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.weblogic.ui", (String)("EJB property invalid " + status.getMessage()));
                this.setErrorMessage(status.getMessage());
                this.setValid(false);
                return;
            }
            if (status.getSeverity() != 2) continue;
            this.setMessage(status.getMessage(), 2);
        }
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        this.setValid(true);
    }

    protected boolean init() {
        assert (this._project != null);
        this._propertyMap.put("ejbc.flags", new EJBGenProperty("ejbc.flags", "", true));
        EJBGenProperty createTablesProperty = new EJBGenProperty("jar.settings.create.tables", "UNSPECIFIED", true);
        createTablesProperty.setValidValues(new String[]{"UNSPECIFIED", "CREATE_ONLY", "DISABLED", "DROP_AND_CREATE", "DROP_AND_CREATE_ALWAYS", "ALTER_OR_CREATE"});
        this._propertyMap.put("jarSettings.createTables", createTablesProperty);
        this._propertyMap.put("jarSettings.ejbClientJar", new EJBGenProperty("jar.settings.ejb.client.jar", "", true));
        EJBGenProperty enableBeanClassRedeployProperty = new EJBGenProperty("jar.settings.enable.bean.class.redeploy", "UNSPECIFIED", true);
        enableBeanClassRedeployProperty.setValidValues(new String[]{"UNSPECIFIED", "TRUE", "FALSE"});
        this._propertyMap.put("jarSettings.beanClassRedeploy", enableBeanClassRedeployProperty);
        this._propertyMap.put("jarSettings.disableWarning", new EJBGenProperty("jar.settings.disable.warning", "", true));
        this.oldProps = EJBProjectProperties.readProperties((IProject)this._project);
        for (String key : this.oldProps.keySet()) {
            String currentValue;
            EJBGenProperty property = this._propertyMap.get(key);
            if (property == null || StringUtil.isEmpty((String)(currentValue = this.oldProps.get(key)))) continue;
            property.setUseDefault(false);
            property.setValue(currentValue);
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        assert (element instanceof IProject);
        if (element instanceof IProject) {
            this._project = (IProject)element;
        }
        Composite composite = new Composite(parent, 0);
        if (this.init()) {
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            layout.verticalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Set<String> keySet = this._propertyMap.keySet();
            for (String propertyName : keySet) {
                this._propertyMap.get(propertyName).addToUI(composite, propertyName);
            }
            Text text = new Text(composite, 16456);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            data.verticalSpan = 1;
            text.setLayoutData((Object)data);
            text.setText(EJBProjectUIPlugin.getResourceString("ejb-settings-description"));
        }
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setText(EJBProjectUIPlugin.getResourceString("restore-defaults"));
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp((Control)parent, "oracle.eclipse.tools.weblogic.ui.weblogic_ejb_properties_context");
    }

    protected void performDefaults() {
        super.performDefaults();
        Set<String> keySet = this._propertyMap.keySet();
        for (String propertyName : keySet) {
            EJBGenProperty property = this._propertyMap.get(propertyName);
            property.setToDefault();
        }
    }

    private Map<String, String> getCurrentProps() {
        HashMap<String, String> currentProps = new HashMap<String, String>();
        Set<String> keySet = this._propertyMap.keySet();
        for (String propertyName : keySet) {
            EJBGenProperty property = this._propertyMap.get(propertyName);
            if (!property.isDefaultSelected()) {
                currentProps.put(propertyName, property.getControlValue().trim());
                continue;
            }
            currentProps.put(propertyName, null);
        }
        return currentProps;
    }

    public boolean performOk() {
        if (this._project == null) {
            return false;
        }
        Map<String, String> currentProps = this.getCurrentProps();
        if (this.oldProps.equals(currentProps)) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.weblogic.ui", (String)"not saving WebLogic EJB properties");
            return true;
        }
        WritePropertiesJob job = new WritePropertiesJob(this._project, currentProps);
        job.setUser(true);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
        return true;
    }

    protected class CheckboxListener
    implements SelectionListener {
        private Control _propertyControl = null;

        protected CheckboxListener(Control control) {
            this._propertyControl = control;
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        protected void handleEvent(SelectionEvent e) {
            Button checkbox = (Button)e.widget;
            this._propertyControl.setEnabled(!checkbox.getSelection());
            if (!checkbox.getSelection()) {
                this._propertyControl.setFocus();
            }
        }
    }

    protected class EJBGenIdentifierProperty
    extends EJBGenProperty {
        private boolean prefix;

        protected EJBGenIdentifierProperty(String propLabelKey, String propValue, boolean propUseDefault, boolean prefix) {
            super(propLabelKey, propValue, propUseDefault, false);
            this.prefix = prefix;
        }

        protected EJBGenIdentifierProperty(String propLabelKey, String propValue, boolean propUseDefault, boolean allowEmpty, boolean prefix) {
            super(propLabelKey, propValue, propUseDefault, allowEmpty);
            this.prefix = prefix;
        }

        @Override
        protected IStatus validate() {
            if (this.getControl() == null || this.isDefaultSelected()) {
                return Status.OK_STATUS;
            }
            IStatus status = super.validate();
            if (status.getSeverity() == 4) {
                return status;
            }
            String value = this.getControlValue().trim();
            boolean validIdentifer = true;
            int i = 0;
            while (i < value.length()) {
                if (i == 0 && this.prefix && !Character.isJavaIdentifierStart(value.charAt(0)) || !Character.isJavaIdentifierPart(value.charAt(i))) {
                    validIdentifer = false;
                    break;
                }
                ++i;
            }
            if (!validIdentifer) {
                String propName = "invalid-prefix";
                if (!this.prefix) {
                    propName = "invalid-postfix";
                }
                return new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, EJBProjectUIPlugin.getString(propName, value), null);
            }
            return Status.OK_STATUS;
        }
    }

    protected class EJBGenProperty
    implements SelectionListener,
    ModifyListener {
        private String _labelKey = null;
        private String _value = null;
        private boolean _useDefault;
        private boolean _allowEmpty;
        private Control _control;
        private Button _checkbox;
        private String[] _validValues = null;

        protected EJBGenProperty(String propLabelKey, String propValue, boolean propUseDefault) {
            this(propLabelKey, propValue, propUseDefault, false);
        }

        protected EJBGenProperty(String propLabelKey, String propValue, boolean propUseDefault, boolean allowEmpty) {
            this._labelKey = propLabelKey;
            this._value = propValue;
            this._useDefault = propUseDefault;
            this._allowEmpty = allowEmpty;
        }

        protected Button getCheckbox() {
            return this._checkbox;
        }

        protected Control getControl() {
            return this._control;
        }

        protected String getLabelKey() {
            return this._labelKey;
        }

        protected void setLabelKey(String propLabelKey) {
            this._labelKey = propLabelKey;
        }

        protected boolean isUseDefault() {
            return this._useDefault;
        }

        protected void setUseDefault(boolean propUseDefault) {
            this._useDefault = propUseDefault;
        }

        protected String getValue() {
            return this._value;
        }

        protected void setValue(String propValue) {
            this._value = propValue;
        }

        protected void setValidValues(String[] validValues) {
            this._validValues = validValues;
        }

        protected String[] getValidValues() {
            return this._validValues;
        }

        protected boolean isValid(String value) {
            if (this._validValues == null) {
                return true;
            }
            if (value == null) {
                return false;
            }
            String[] stringArray = this._validValues;
            int n = this._validValues.length;
            int n2 = 0;
            while (n2 < n) {
                String valid = stringArray[n2];
                if (valid.equals(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected String getControlValue() {
            if (this._control == null) {
                return null;
            }
            if (this._control instanceof Text) {
                return ((Text)this._control).getText();
            }
            Combo combo = (Combo)this._control;
            return combo.getItem(combo.getSelectionIndex());
        }

        protected boolean isDefaultSelected() {
            if (this._checkbox == null) {
                return true;
            }
            return this._checkbox.getSelection();
        }

        protected void setToDefault() {
            if (this._checkbox != null) {
                this._checkbox.setSelection(true);
            }
            if (this._control != null) {
                this._control.setEnabled(false);
                if (this._control instanceof Text) {
                    ((Text)this._control).setText("");
                } else {
                    ((Combo)this._control).select(0);
                }
            }
        }

        protected boolean allowsEmpty() {
            return this._allowEmpty;
        }

        protected IStatus validate() {
            if (this._control == null || this.isDefaultSelected()) {
                return Status.OK_STATUS;
            }
            String setting = this.getControlValue();
            if (!(this.allowsEmpty() || setting != null && setting.length() != 0)) {
                return new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, EJBProjectUIPlugin.getString("empty-property", EJBProjectUIPlugin.getResourceString(this._labelKey)), null);
            }
            return Status.OK_STATUS;
        }

        public void modifyText(ModifyEvent e) {
            EJBProjectPropertyPage.this.validateAllProperties();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            EJBProjectPropertyPage.this.validateAllProperties();
        }

        public void widgetSelected(SelectionEvent e) {
            EJBProjectPropertyPage.this.validateAllProperties();
        }

        protected void addToUI(Composite composite, String propertyName) {
            Label label = new Label(composite, 64);
            label.setText(EJBProjectUIPlugin.getResourceString(this.getLabelKey()));
            GridData data = new GridData(128);
            label.setLayoutData((Object)data);
            if (this._validValues == null) {
                Text text = new Text(composite, 2048);
                text.setText(this.getValue());
                data = new GridData(768);
                text.setLayoutData((Object)data);
                this._control = text;
                text.addModifyListener((ModifyListener)this);
            } else {
                Combo combo = new Combo(composite, 12);
                combo.setItems(this._validValues);
                String selectedValue = this.getValue();
                int selectedIndex = 0;
                int i = 0;
                while (i < this._validValues.length) {
                    if (this._validValues[i].equals(selectedValue)) {
                        selectedIndex = i;
                        break;
                    }
                    ++i;
                }
                combo.select(selectedIndex);
                data = new GridData(768);
                combo.setLayoutData((Object)data);
                this._control = combo;
                combo.addSelectionListener((SelectionListener)this);
            }
            this._checkbox = new Button(composite, 32);
            this._checkbox.setText(EJBProjectUIPlugin.getResourceString("use.default"));
            this._checkbox.setSelection(this.isUseDefault());
            data = new GridData(128);
            this._checkbox.setLayoutData((Object)data);
            this._checkbox.addSelectionListener((SelectionListener)this);
            this._checkbox.addSelectionListener((SelectionListener)new CheckboxListener(this._control));
            if (this.isUseDefault()) {
                this._control.setEnabled(false);
            }
            label.setData(EJBProjectPropertyPage.NAME, (Object)("oracle.eclipse.tools.weblogic.ui_label_" + propertyName));
            this._control.setData(EJBProjectPropertyPage.NAME, (Object)("oracle.eclipse.tools.weblogic.ui_text_" + propertyName));
            this._checkbox.setData(EJBProjectPropertyPage.NAME, (Object)("oracle.eclipse.tools.weblogic.ui_checkbox_" + propertyName));
        }
    }

    private static final class WritePropertiesJob
    extends WorkspaceJob {
        private final IProject _project;
        private final Map<String, String> _currentProps;

        WritePropertiesJob(IProject project, Map<String, String> currentProps) {
            super(EJBProjectUIPlugin.getString("save-ejb-project-props-job", new Object[0]));
            this._project = project;
            this._currentProps = currentProps;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                monitor.beginTask(EJBProjectUIPlugin.getString("save-ejb-project-props-job", new Object[0]), 2);
                try {
                    EJBProjectProperties.writeProperties((IProject)this._project, this._currentProps);
                    monitor.worked(1);
                    this._project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.worked(1);
                }
                catch (CoreException ce) {
                    String msg = EJBProjectUIPlugin.getString("error-saving-properties", new Object[0]);
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)ce, (String)msg);
                    Status status = new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, msg, (Throwable)ce);
                    monitor.done();
                    return status;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

