/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ejb.common.wizards;

import java.text.MessageFormat;
import java.util.HashMap;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateGenerationFailedException;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateService;
import oracle.eclipse.tools.common.ui.wizards.ContainerContentProviderForJava;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.ejb.template.EJBProjectTemplateBean;
import oracle.eclipse.tools.weblogic.facets.WlsEjbGenFacet;
import oracle.eclipse.tools.weblogic.ui.ejb.EJBProjectUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class NewEJBFileWizardPage
extends NewFileWizardPage {
    public static final String JAVA_FILE_EXTENSION = ".java";
    private final String[] _superTypes = this.getSuperTypes();
    private final String _helpContextID;

    protected NewEJBFileWizardPage(String pageName, IStructuredSelection selection, String pageTitle, String pageDescription, String helpContextID) {
        super(pageName, selection);
        this.setFileName(this.getDefaultFileName());
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        this._helpContextID = helpContextID;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this._helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp(this.getControl(), this._helpContextID);
        }
        this.validatePage();
    }

    protected String getDefaultFileExtension() {
        return "java";
    }

    protected boolean validateFile(IFile file) {
        String fileName = this.getFileName();
        int lastPeriod = fileName.lastIndexOf(46);
        String typeName = fileName;
        if (lastPeriod != -1) {
            String fileExtension = fileName.substring(lastPeriod);
            if (!fileExtension.equals(JAVA_FILE_EXTENSION)) {
                this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.fileNameExtension"));
                return false;
            }
            typeName = fileName.substring(0, lastPeriod);
        }
        if (fileName.indexOf(46) != lastPeriod) {
            this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.qualifiedName"));
            return false;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
        if (val.getSeverity() == 4) {
            this.setErrorMessage(MessageFormat.format(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.invalidTypeName"), val.getMessage()));
            return false;
        }
        val.getSeverity();
        String shadowedSuperType = this.shadowsSuperType(typeName);
        if (shadowedSuperType != null) {
            this.setErrorMessage(MessageFormat.format(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.shadows.supertype"), shadowedSuperType));
            return false;
        }
        String shadowedAnno = this.shadowsAnnotation(typeName);
        if (shadowedAnno != null) {
            this.setErrorMessage(MessageFormat.format(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.shadows.annotation"), shadowedAnno));
            return false;
        }
        IProject selectedProject = file.getProject();
        if (!WlsEjbGenFacet.isInstalled((IProject)selectedProject)) {
            this.setErrorMessage(EJBProjectUIPlugin.getString("NewEJBFileWizardPage.error.notEJBProject", WlsEjbGenFacet.FACET.getLabel()));
            return false;
        }
        String packageName = NewEJBFileWizardPage.getPackageName(file.getParent());
        if (packageName == null) {
            this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.notPackage"));
            return false;
        }
        if (file.getParent().isDerived()) {
            this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.derived"));
            return false;
        }
        IPackageFragment pack = (IPackageFragment)JavaCore.create((IResource)file.getParent());
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(file.getName());
            IResource resource = cu.getResource();
            if (resource.exists()) {
                this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.typeNameExists"));
                return false;
            }
            IPath location = resource.getLocation();
            if (location != null && location.toFile().exists()) {
                this.setErrorMessage(EJBProjectUIPlugin.getResourceString("NewEJBFileWizardPage.error.typeNameExistsDifferentCase"));
                return false;
            }
        }
        return true;
    }

    protected String shadowsAnnotation(String typeName) {
        String[] classAnnotations = this.getPotentialClassAnnotations();
        if (classAnnotations == null) {
            return null;
        }
        String[] stringArray = classAnnotations;
        int n = classAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String anno = stringArray[n2];
            int lastIndex = anno.lastIndexOf(".");
            String comp = anno;
            if (lastIndex >= 0) {
                comp = anno.substring(lastIndex + 1);
            }
            if (comp.equals(typeName)) {
                return anno;
            }
            ++n2;
        }
        return null;
    }

    protected abstract String[] getPotentialClassAnnotations();

    protected abstract String[] getSuperTypes();

    protected String shadowsSuperType(String typeName) {
        String[] stringArray = this._superTypes;
        int n = this._superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String superType = stringArray[n2];
            if (superType.equals(typeName)) {
                return superType;
            }
            ++n2;
        }
        return null;
    }

    public IFile getFile() {
        String fileName = this.getFileName();
        if (!fileName.toLowerCase().endsWith(JAVA_FILE_EXTENSION)) {
            fileName = String.valueOf(fileName) + JAVA_FILE_EXTENSION;
        }
        IPath filePath = this.getContainerFullPath().append(fileName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        return file;
    }

    protected abstract String getTemplateId();

    protected ITreeContentProvider createContainerContentProvider() {
        return new ContainerContentProviderForJava(){

            protected boolean isValidProject(IProject project) {
                return NewEJBFileWizardPage.this.isOpenEJBProject(project);
            }
        };
    }

    protected boolean validatePage() {
        if (!this.wlwEJBProjectExists()) {
            this.setErrorMessage(EJBProjectUIPlugin.getString("NewEJBFileWizardPage.error.noEJBProject", WlsEjbGenFacet.FACET.getLabel()));
            return false;
        }
        return super.validatePage();
    }

    private boolean wlwEJBProjectExists() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isOpenEJBProject(project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isOpenEJBProject(IProject project) {
        assert (project != null);
        return project.isOpen() && WlsEjbGenFacet.isInstalled((IProject)project);
    }

    protected static String getPackageName(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragment) {
            return ((IPackageFragment)elem).getElementName();
        }
        return null;
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    public IFile createNewFile() {
        FileTemplateDescriptor template;
        EJBProjectTemplateBean bean;
        IFile file;
        block5: {
            file = this.getFile();
            if (file == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.weblogic.ui", (String)EJBProjectUIPlugin.getResourceString("file.creation.error"));
            }
            bean = this.createEJBProjectTemplateBean();
            this.initializeEJBProjectTemplateBean(bean, file);
            String templateId = this.getTemplateId();
            template = FileTemplateService.getFileTemplateDescriptorByID((String)templateId);
            if (template != null) break block5;
            LoggingService.logError((String)"oracle.eclipse.tools.weblogic.ui", (String)EJBProjectUIPlugin.getString("template.error", templateId));
            return null;
        }
        try {
            HashMap<String, EJBProjectTemplateBean> context = new HashMap<String, EJBProjectTemplateBean>(1);
            context.put("ejb", bean);
            IProject project = file.getProject();
            template.generate(project, context, true);
            return file;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (FileTemplateGenerationFailedException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
        }
        return null;
    }

    protected EJBProjectTemplateBean createEJBProjectTemplateBean() {
        return new EJBProjectTemplateBean();
    }

    protected void initializeEJBProjectTemplateBean(EJBProjectTemplateBean bean, IFile file) {
        bean.setPackageName(NewEJBFileWizardPage.getPackageName(file.getParent()));
        bean.setClassName(file.getFullPath().removeFileExtension().lastSegment());
        bean.setOutputFileName(file.getName());
        bean.setProjectRelativeOutputPath(file.getParent().getFullPath().removeFirstSegments(1).makeRelative());
    }
}

