/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.ejb.EJBCoreUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class NewDeploymentPlanOptionsPage
extends WizardPage {
    private static final String WLS_RT_TYPE_PREFIX = "com.bea.weblogic";
    private Button workspaceProjRadioBtn = null;
    private Combo projectNames = null;
    private Button externalArchiveRadioBtn = null;
    private Text externalArchivePath = null;
    private Button browseBtn = null;
    private Combo targetRuntimeCombo;
    private Button runPlanGenChkBox = null;
    private TreeMap<String, IProject> allJavaeeProjects = null;
    private HashMap<String, Object> wizardDataModel = null;
    private IStructuredSelection selection;
    private Button[] optionBtns = new Button[PLAN_GEN_OPTIONS.length];
    private Button globalVariableBtn;
    private TreeMap<String, IRuntime> runtimeMap = new TreeMap();
    public static final String FACET_RUNTIME = "IFacetProjectCreationDataModelProperties.FACET_RUNTIME";
    private static final String[] PLAN_GEN_OPTIONS = new String[]{"-all", "-dependencies", "-declarations", "-dynamics", "-configurables"};
    private static final String DEFAULT_PLAN_GEN_OPTIONS = "-dependencies";
    private static final String[] PLAN_GEN_OPTION_LABELS = new String[]{Resources.exportAllLabel, Resources.exportDependenciesLabel, Resources.exportResourceLabel, Resources.exportChangeOnTheFlyLabel, Resources.exportExDependenciesLabel};
    private SelectionListener targetAppListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isSelectedExternal = NewDeploymentPlanOptionsPage.this.externalArchiveRadioBtn.getSelection();
            NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_EXTERNAL_ARCHIVE_NAME", isSelectedExternal ? NewDeploymentPlanOptionsPage.this.externalArchivePath.getText() : "");
            NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_PROJECT_NAME", isSelectedExternal ? "" : NewDeploymentPlanOptionsPage.this.projectNames.getText());
            NewDeploymentPlanOptionsPage.this.externalArchivePath.setEnabled(isSelectedExternal);
            NewDeploymentPlanOptionsPage.this.browseBtn.setEnabled(isSelectedExternal);
            NewDeploymentPlanOptionsPage.this.projectNames.setEnabled(!isSelectedExternal);
            NewDeploymentPlanOptionsPage.this.updatePageStatus();
        }
    };

    protected NewDeploymentPlanOptionsPage(String pageName, IStructuredSelection selection, HashMap<String, Object> wizarDataModel) {
        super(pageName);
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.wizardDataModel = wizarDataModel;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout(1, false));
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        Group targetAppGrp = new Group(topLevel, 0);
        targetAppGrp.setLayout((Layout)new GridLayout(2, false));
        targetAppGrp.setText(Resources.targetApp);
        targetAppGrp.setLayoutData((Object)NewDeploymentPlanOptionsPage.gdhfill());
        this.createWorkspaceProjectCombo((Composite)targetAppGrp);
        this.createExternalArchivePathControl((Composite)targetAppGrp);
        this.createTargetRuntimeComposite(topLevel);
        Group optionsGrp = new Group(topLevel, 0);
        optionsGrp.setLayout((Layout)new GridLayout(1, false));
        optionsGrp.setLayoutData((Object)new GridData(1808));
        optionsGrp.setText(Resources.options);
        this.createRunPlanGenControls((Composite)optionsGrp);
        if (this.allJavaeeProjects.size() == 0) {
            this.projectNames.setEnabled(false);
            this.workspaceProjRadioBtn.setSelection(false);
            this.workspaceProjRadioBtn.setEnabled(false);
            this.externalArchiveRadioBtn.setSelection(true);
            this.externalArchivePath.setEnabled(true);
            this.browseBtn.setEnabled(true);
        } else {
            this.updateRuntimeCombo(this.projectNames.getText());
        }
        this.updatePageStatus();
        this.setControl((Control)topLevel);
    }

    private void updatePageStatus() {
        this.setErrorMessage(null);
        if (this.externalArchiveRadioBtn.getSelection() && this.wizardDataModel.get("PROP_EXTERNAL_ARCHIVE_NAME").toString().length() == 0) {
            this.setErrorMessage(Resources.warnSelectExteralArchive);
            this.setPageComplete(false);
            return;
        }
        if (this.workspaceProjRadioBtn.getSelection() && this.wizardDataModel.get("PROP_PROJECT_NAME").toString().length() == 0) {
            this.setErrorMessage(Resources.warnSelectJavaeeProject);
            this.setPageComplete(false);
            return;
        }
        if (this.wizardDataModel.get("PROP_TARGET_RUNTIME") == null) {
            this.setErrorMessage(Resources.warnSelectWlsTargetRuntime);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private void createRunPlanGenControls(Composite topLevel) {
        this.runPlanGenChkBox = new Button(topLevel, 32);
        this.runPlanGenChkBox.setText(Resources.runPlanGenLabel);
        this.runPlanGenChkBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = NewDeploymentPlanOptionsPage.this.runPlanGenChkBox.getSelection();
                NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_RUN_PLANGEN", isSelected ? Boolean.TRUE : Boolean.FALSE);
                Button[] buttonArray = NewDeploymentPlanOptionsPage.this.optionBtns;
                int n = buttonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Button btn = buttonArray[n2];
                    btn.setEnabled(isSelected);
                    ++n2;
                }
                NewDeploymentPlanOptionsPage.this.globalVariableBtn.setEnabled(isSelected);
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.runPlanGenChkBox.setLayoutData((Object)gd);
        SelectionListener optionSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button radioBtn = (Button)e.getSource();
                if (radioBtn.getSelection()) {
                    NewDeploymentPlanOptionsPage.this.updatePlanGenOptions(true);
                }
            }
        };
        int i = 0;
        while (i < PLAN_GEN_OPTIONS.length) {
            Button optionRadio = new Button(topLevel, 16);
            optionRadio.setEnabled(false);
            optionRadio.setText(PLAN_GEN_OPTION_LABELS[i]);
            optionRadio.setData((Object)PLAN_GEN_OPTIONS[i]);
            if (PLAN_GEN_OPTIONS[i].equals(DEFAULT_PLAN_GEN_OPTIONS)) {
                optionRadio.setSelection(true);
            }
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.horizontalIndent = 15;
            optionRadio.setLayoutData((Object)gd);
            optionRadio.addSelectionListener(optionSelectionListener);
            this.optionBtns[i] = optionRadio;
            ++i;
        }
        this.globalVariableBtn = new Button(topLevel, 32);
        this.globalVariableBtn.setEnabled(false);
        this.globalVariableBtn.setSelection(true);
        this.globalVariableBtn.setText(Resources.globalVariable);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 15;
        this.globalVariableBtn.setLayoutData((Object)gd);
        this.globalVariableBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewDeploymentPlanOptionsPage.this.updatePlanGenOptions(true);
            }
        });
    }

    private void createExternalArchivePathControl(Composite group) {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.externalArchiveRadioBtn = new Button(group, 16);
        this.externalArchiveRadioBtn.setLayoutData((Object)gd);
        this.externalArchiveRadioBtn.setText(Resources.externalArchiveName);
        this.externalArchiveRadioBtn.addSelectionListener(this.targetAppListener);
        this.externalArchivePath = new Text(group, 2056);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.externalArchivePath.setLayoutData((Object)gd);
        this.externalArchivePath.setEnabled(false);
        this.browseBtn = new Button(group, 0);
        this.browseBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this.browseBtn.setToolTipText(Resources.browseTooltip);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.browseBtn.setLayoutData((Object)gd);
        this.browseBtn.setEnabled(false);
        this.browseBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Menu popupMenu = new Menu((Decorations)Display.getDefault().getActiveShell(), 8);
                Rectangle rect = NewDeploymentPlanOptionsPage.this.browseBtn.getBounds();
                Point pt = new Point(rect.x + rect.width, rect.y + rect.height);
                pt = NewDeploymentPlanOptionsPage.this.browseBtn.getParent().toDisplay(pt);
                popupMenu.setLocation(pt);
                popupMenu.setVisible(true);
                MenuItem item1 = new MenuItem(popupMenu, 0);
                item1.setText(Resources.workspaceMenuItemLabel);
                item1.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                        dialog.setAllowMultiple(false);
                        dialog.setTitle(Resources.javaEEArchiveSelection);
                        dialog.setMessage(Resources.availableArchive);
                        dialog.addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parent, Object element) {
                                IFile file;
                                if (element instanceof IContainer) {
                                    return true;
                                }
                                return element instanceof IFile && ((file = (IFile)element).getName().endsWith(".jar") || file.getName().endsWith(".ear") || file.getName().endsWith(".war"));
                            }
                        });
                        dialog.setValidator(new ISelectionStatusValidator(){

                            public IStatus validate(Object[] selection) {
                                if (selection.length > 0 && selection[0] instanceof IFile) {
                                    return Status.OK_STATUS;
                                }
                                return new Status(4, "oracle.eclipse.tools.weblogic.ui", "");
                            }
                        });
                        dialog.setInput((Object)input);
                        if (dialog.open() == 0) {
                            IFile file = (IFile)dialog.getFirstResult();
                            String path = file.getLocation().toPortableString();
                            NewDeploymentPlanOptionsPage.this.externalArchivePath.setText(path);
                            NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_EXTERNAL_ARCHIVE_NAME", path);
                        }
                        NewDeploymentPlanOptionsPage.this.updatePageStatus();
                    }
                });
                MenuItem item2 = new MenuItem(popupMenu, 0);
                item2.setText(Resources.fileSystemMenuItemLabel);
                item2.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell());
                        dialog.setFilterExtensions(new String[]{"*.jar;*.war;*.ear"});
                        String value = dialog.open();
                        if (value != null) {
                            String ret = String.valueOf(dialog.getFilterPath()) + "/" + dialog.getFileName();
                            String path = ret.replace('\\', '/');
                            NewDeploymentPlanOptionsPage.this.externalArchivePath.setText(path);
                            NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_EXTERNAL_ARCHIVE_NAME", path);
                        }
                        NewDeploymentPlanOptionsPage.this.updatePageStatus();
                    }
                });
            }
        });
    }

    private void createWorkspaceProjectCombo(Composite group) {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.workspaceProjRadioBtn = new Button(group, 16);
        this.workspaceProjRadioBtn.setLayoutData((Object)gd);
        this.workspaceProjRadioBtn.setSelection(true);
        this.workspaceProjRadioBtn.setText(Resources.projectName);
        this.workspaceProjRadioBtn.addSelectionListener(this.targetAppListener);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.projectNames = new Combo(group, 12);
        this.projectNames.setLayoutData((Object)gd);
        this.allJavaeeProjects = new TreeMap();
        this.addApplicationsOfType(this.allJavaeeProjects, "jst.ear");
        this.addApplicationsOfType(this.allJavaeeProjects, "jst.web");
        this.addApplicationsOfType(this.allJavaeeProjects, "jst.ejb");
        for (String p : this.allJavaeeProjects.keySet()) {
            this.projectNames.add(p);
        }
        this.projectNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String projName = NewDeploymentPlanOptionsPage.this.projectNames.getText();
                NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_PROJECT_NAME", projName);
                NewDeploymentPlanOptionsPage.this.updateRuntimeCombo(projName);
            }
        });
        IResource selectedResource = null;
        Iterator it = this.selection.iterator();
        if (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof IResource) {
                selectedResource = (IResource)obj;
            } else if (obj instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                IProject proj = selectedResource.getProject();
                int i = 0;
                while (i < this.projectNames.getItemCount()) {
                    String appName = this.projectNames.getItem(i);
                    if (appName.equals(proj.getName())) {
                        this.projectNames.select(i);
                        this.wizardDataModel.put("PROP_PROJECT_NAME", appName);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private IFacetedProject getFacetedProject(String appName) {
        IProject p = this.allJavaeeProjects.get(appName);
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)p);
            return fp;
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private void addApplicationsOfType(TreeMap<String, IProject> allJavaeeProjects, String type) {
        IProject[] projects = null;
        IProject[] iProjectArray = projects = JavaEEProjectUtilities.getAllProjectsInWorkspaceOfType((String)type);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            IRuntimeComponentVersion rv = WlsRuntimeUtil.getWlsRuntimeVersion((IProject)p);
            if (rv != null) {
                allJavaeeProjects.put(p.getName(), p);
            }
            ++n2;
        }
    }

    protected static GridData gdhfill() {
        return new GridData(768);
    }

    protected void createTargetRuntimeComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Resources.targetRuntime);
        group.setLayoutData((Object)NewDeploymentPlanOptionsPage.gdhfill());
        group.setLayout((Layout)new GridLayout(2, false));
        this.targetRuntimeCombo = new Combo((Composite)group, 2056);
        this.targetRuntimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String rtName = NewDeploymentPlanOptionsPage.this.targetRuntimeCombo.getText();
                if (rtName.length() == 0) {
                    NewDeploymentPlanOptionsPage.this.updatePlanGenOptions(false);
                    NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_TARGET_RUNTIME", null);
                    NewDeploymentPlanOptionsPage.this.updatePageStatus();
                    return;
                }
                IRuntime rt = (IRuntime)NewDeploymentPlanOptionsPage.this.runtimeMap.get(rtName);
                NewDeploymentPlanOptionsPage.this.updatePlanGenOptions(true);
                NewDeploymentPlanOptionsPage.this.wizardDataModel.put("PROP_TARGET_RUNTIME", rt);
                NewDeploymentPlanOptionsPage.this.updatePageStatus();
            }
        });
        this.targetRuntimeCombo.setLayoutData((Object)NewDeploymentPlanOptionsPage.gdhfill());
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
        newServerTargetButton.setToolTipText(Resources.newTargetRuntime);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDeploymentPlanOptionsPage.this.launchNewRuntimeWizard("");
            }
        });
        this.populateRuntimeCombo();
    }

    private void updateRuntimeCombo(String projName) {
        if (projName != null && projName.length() > 0) {
            IFacetedProject fproject = this.getFacetedProject(projName);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = fproject.getPrimaryRuntime();
            this.updatePlanGenOptions(false);
            if (rt != null) {
                IRuntime serverRt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
                int i = 0;
                while (i < this.targetRuntimeCombo.getItemCount()) {
                    if (this.targetRuntimeCombo.getItem(i).equals(serverRt.getName())) {
                        this.targetRuntimeCombo.select(i);
                        this.wizardDataModel.put("PROP_TARGET_RUNTIME", serverRt);
                        if (fproject.hasProjectFacet(FacetUtil.FACET_JST_EAR)) {
                            IVirtualReference[] refComponents;
                            IVirtualComponent component = ComponentCore.createComponent((IProject)fproject.getProject());
                            if (component != null && (refComponents = component.getReferences()).length > 0) {
                                this.updatePlanGenOptions(true);
                            }
                        } else if (fproject.hasProjectFacet(FacetUtil.FACET_JST_EJB)) {
                            IJavaProject jproj = JavaCore.create((IProject)fproject.getProject());
                            try {
                                IPath[] path;
                                IPath[] iPathArray = path = EJBCoreUtil.getEJBSrcPath((IJavaProject)jproj);
                                int n = path.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFolder f = jproj.getProject().getFolder("ejbModule");
                                    if (f.exists() && f.members().length > 1) {
                                        this.updatePlanGenOptions(true);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.updatePlanGenOptions(true);
                        }
                        this.updatePageStatus();
                        return;
                    }
                    ++i;
                }
            }
            this.targetRuntimeCombo.select(0);
        }
        this.updatePageStatus();
    }

    private void updatePlanGenOptions(boolean enabled) {
        this.wizardDataModel.put("PROP_RUN_PLANGEN", enabled ? Boolean.TRUE : Boolean.FALSE);
        this.runPlanGenChkBox.setEnabled(enabled);
        this.runPlanGenChkBox.setSelection(enabled);
        this.globalVariableBtn.setEnabled(enabled);
        StringBuffer option = new StringBuffer();
        option.append(this.globalVariableBtn.getSelection() ? "-variables global" : "-variables unique");
        Button[] buttonArray = this.optionBtns;
        int n = this.optionBtns.length;
        int n2 = 0;
        while (n2 < n) {
            Button btn = buttonArray[n2];
            btn.setEnabled(enabled);
            if (enabled && btn.getSelection()) {
                option.append(" ");
                option.append(btn.getData());
            }
            ++n2;
        }
        this.wizardDataModel.put("PROP_PLANGEN_OPTIONS", option.toString());
    }

    public boolean launchNewRuntimeWizard(String serverTypeID) {
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)Display.getDefault().getActiveShell(), (String)serverTypeID, null);
        if (isOK) {
            this.populateRuntimeCombo();
            return true;
        }
        return false;
    }

    protected void populateRuntimeCombo() {
        this.targetRuntimeCombo.removeAll();
        this.runtimeMap.clear();
        this.targetRuntimeCombo.add("");
        IRuntime[] runtimes = ServerCore.getRuntimes();
        IRuntime defaultRt = null;
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            if (rt.getRuntimeType().getId().startsWith(WLS_RT_TYPE_PREFIX) && !rt.getRuntimeType().getId().matches("com\\.bea\\.weblogic\\d\\d\\.legacy")) {
                if (defaultRt == null) {
                    defaultRt = rt;
                }
                this.targetRuntimeCombo.add(rt.getName());
                this.runtimeMap.put(rt.getName(), rt);
            }
            ++n2;
        }
    }

    private static final class Resources
    extends NLS {
        public static String exportExDependenciesLabel;
        public static String exportChangeOnTheFlyLabel;
        public static String exportResourceLabel;
        public static String exportDependenciesLabel;
        public static String exportAllLabel;
        public static String pageDescription;
        public static String pageTitle;
        public static String targetApp;
        public static String projectName;
        public static String externalArchiveName;
        public static String workspaceMenuItemLabel;
        public static String fileSystemMenuItemLabel;
        public static String targetRuntime;
        public static String runPlanGenLabel;
        public static String options;
        public static String globalVariable;
        public static String browseTooltip;
        public static String javaEEArchiveSelection;
        public static String newTargetRuntime;
        public static String availableArchive;
        public static String warnSelectExteralArchive;
        public static String warnSelectJavaeeProject;
        public static String warnSelectWlsTargetRuntime;

        static {
            Resources.initializeMessages((String)NewDeploymentPlanOptionsPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

