/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IPlanGenRunner;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import oracle.eclipse.tools.weblogic.descriptors.deploy.WebLogicDeploymentPlanFactory;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.ui.export.internal.WLSExportOperation;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentExportOperation;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBComponentExportOperation;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.server.core.IRuntime;

public class NewDeploymentPlanFileWizardPage
extends NewFileWizardPage {
    IStructuredSelection selection = null;
    HashMap<String, Object> wizardDataModel;
    boolean allowOverwrite = false;

    protected NewDeploymentPlanFileWizardPage(String pageName, IStructuredSelection selection, HashMap<String, Object> wizarDataModel) {
        super(Resources.pageHeader, selection);
        this.selection = selection;
        this.wizardDataModel = wizarDataModel;
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
    }

    protected String getDefaultFileName() {
        return "plan.xml";
    }

    protected String getDefaultFileExtension() {
        return "";
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.validatePage();
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        final Button overwriteBtn = new Button(parent, 32);
        GridData gd = new GridData();
        overwriteBtn.setLayoutData((Object)gd);
        overwriteBtn.setText(Resources.overwriteExistingFile);
        overwriteBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewDeploymentPlanFileWizardPage.this.allowOverwrite = overwriteBtn.getSelection();
                NewDeploymentPlanFileWizardPage.this._resourceGroup.setAllowExistingResources(NewDeploymentPlanFileWizardPage.this.allowOverwrite);
                NewDeploymentPlanFileWizardPage.this.setFileName(NewDeploymentPlanFileWizardPage.this.getFileName());
                NewDeploymentPlanFileWizardPage.this.validatePage();
            }
        });
    }

    public boolean shouldAllowExistingResoures() {
        return this.allowOverwrite;
    }

    protected boolean validateFile(IFile file) {
        String name = file.getName();
        if (!name.endsWith(".xml")) {
            this.setErrorMessage(Resources.invalidaFileExtenstion);
            return false;
        }
        if (name.length() <= ".xml".length()) {
            this.setErrorMessage(Resources.invalidaFileName);
            return false;
        }
        if (this.allowOverwrite) {
            try {
                IPath containerPath = this._resourceGroup.getContainerFullPath();
                if (containerPath != null) {
                    IEditorReference[] refs;
                    IPath newFilePath = containerPath.append(this.getFileName());
                    IFile newFileHandle = this.createFileHandle(newFilePath);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile inputFile;
                        IEditorReference ref = iEditorReferenceArray[n2];
                        IEditorInput input = ref.getEditorInput();
                        if (input instanceof FileEditorInput && (inputFile = ((FileEditorInput)input).getFile()).getLocation().equals((Object)newFileHandle.getLocation())) {
                            page.closeEditors(new IEditorReference[]{ref}, true);
                        }
                        ++n2;
                    }
                }
            }
            catch (PartInitException e1) {
                LoggingService.logException((Plugin)WlsUiPlugin.getInstance(), (CoreException)((Object)e1));
            }
        }
        return true;
    }

    public IFile createNewFile() {
        try {
            IPath containerPath = this._resourceGroup.getContainerFullPath();
            IPath newFilePath = containerPath.append(this.getFileName());
            IFile newFileHandle = this.createFileHandle(newFilePath);
            if (this.wizardDataModel.get("PROP_RUN_PLANGEN").equals(Boolean.TRUE)) {
                this.runWeblogicPlanGen(newFileHandle);
            } else {
                String targetProj;
                newFileHandle.delete(true, (IProgressMonitor)new NullProgressMonitor());
                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                IWeblogicDeploymentPlan plan = WebLogicDeploymentPlanFactory.getDeploymentPlan((IFile)newFileHandle);
                IRuntime runtime = (IRuntime)this.wizardDataModel.get("PROP_TARGET_RUNTIME");
                if (runtime != null) {
                    String version = WebLogicServerVersion.convert((String)runtime.getRuntimeType().getVersion()).getVersionString();
                    plan.setServerVersion(version);
                }
                if ((targetProj = this.wizardDataModel.get("PROP_PROJECT_NAME").toString()) != null && targetProj.length() > 0) {
                    String deployName = this.getDeployName(ResourcesPlugin.getWorkspace().getRoot().getProject(targetProj));
                    plan.setApplicationName(deployName);
                } else {
                    String archiveName = this.wizardDataModel.get("PROP_EXTERNAL_ARCHIVE_NAME").toString();
                    plan.setApplicationName(archiveName.substring(archiveName.lastIndexOf(47) + 1));
                }
                plan.resource().save();
                plan.dispose();
            }
            newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            if (newFileHandle.exists()) {
                return newFileHandle;
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)WlsUiPlugin.getInstance(), (Throwable)e);
        }
        return null;
    }

    private String getDeployName(IProject proj) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
        String ext = FacetUtil.getResourceExtension((IProject)comp.getProject());
        return String.valueOf(comp.getDeployedName()) + ext;
    }

    protected void runWeblogicPlanGen(final IFile newFileHandle) {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block22: {
                        try {
                            monitor.beginTask(Resources.planGenTaskName, 200);
                            monitor.setTaskName(Resources.planGenTaskName1);
                            monitor.worked(10);
                            final IRuntime runtime = (IRuntime)NewDeploymentPlanFileWizardPage.this.wizardDataModel.get("PROP_TARGET_RUNTIME");
                            IWlsDeployRuntime wlsDeployRt = WlsDeployRuntimeFactory.create((IRuntime)runtime);
                            if (wlsDeployRt == null) {
                                return;
                            }
                            try {
                                final IPlanGenRunner planGenRunner = wlsDeployRt.getPlanGenRunner();
                                File archiveFile = null;
                                String externalArchive = (String)NewDeploymentPlanFileWizardPage.this.wizardDataModel.get("PROP_EXTERNAL_ARCHIVE_NAME");
                                if (externalArchive != null && externalArchive.length() > 0) {
                                    archiveFile = new File(externalArchive);
                                } else {
                                    String projName = (String)NewDeploymentPlanFileWizardPage.this.wizardDataModel.get("PROP_PROJECT_NAME");
                                    IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                                    if (proj != null) {
                                        archiveFile = NewDeploymentPlanFileWizardPage.this.exportArchive(proj, monitor);
                                    }
                                }
                                monitor.worked(10);
                                if (archiveFile == null || !archiveFile.exists()) break block22;
                                monitor.setTaskName(Resources.planGenTaskName2);
                                final File tempPlanFile = new File(archiveFile.getParentFile(), newFileHandle.getName());
                                final String categoryOption = NewDeploymentPlanFileWizardPage.this.wizardDataModel.get("PROP_PLANGEN_OPTIONS").toString();
                                final File finalArchiveFile = archiveFile;
                                final boolean[] isDone = new boolean[1];
                                monitor.worked(10);
                                isDone[0] = false;
                                Job planGenJob = new Job("Executing weblogic.planGenerator"){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        try {
                                            planGenRunner.executePlanGen(runtime, finalArchiveFile.getAbsolutePath(), tempPlanFile.getAbsolutePath(), categoryOption, monitor);
                                        }
                                        catch (CoreException e) {
                                            NewDeploymentPlanFileWizardPage.this.showError(e);
                                        }
                                        isDone[0] = true;
                                        return Status.OK_STATUS;
                                    }
                                };
                                planGenJob.schedule();
                                monitor.worked(10);
                                while (!isDone[0]) {
                                    Thread.sleep(200L);
                                    monitor.worked(1);
                                }
                                if (!tempPlanFile.exists()) break block22;
                                try (FileInputStream fis = null;){
                                    fis = new FileInputStream(tempPlanFile);
                                    if (!newFileHandle.exists()) {
                                        newFileHandle.create((InputStream)fis, true, monitor);
                                    } else {
                                        newFileHandle.setContents((InputStream)fis, 1, monitor);
                                    }
                                }
                                IWeblogicDeploymentPlan plan = WebLogicDeploymentPlanFactory.getDeploymentPlan((IFile)newFileHandle);
                                plan.setConfigRoot("");
                                String version = WebLogicServerVersion.convert((String)runtime.getRuntimeType().getVersion()).getVersionString();
                                plan.setServerVersion(version);
                                plan.resource().save();
                                plan.dispose();
                                if (!tempPlanFile.delete()) {
                                    throw new IOException();
                                }
                                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                NewDeploymentPlanFileWizardPage.this.showError(e);
                            }
                            catch (IOException e) {
                                LoggingService.logException((Plugin)WlsUiPlugin.getInstance(), (Throwable)e);
                            }
                            catch (ResourceStoreException e) {
                                LoggingService.logException((Plugin)WlsUiPlugin.getInstance(), (Throwable)e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
            };
            dialog.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            this.promptError(e);
        }
    }

    private void showError(final CoreException e) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)NewDeploymentPlanFileWizardPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, (String)Resources.planGenTaskFailed, (Throwable)e, (int)0, (boolean)true);
            }
        });
    }

    private void promptError(InvocationTargetException e) {
        if (e.getTargetException() instanceof CoreException) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (Throwable)e, (int)1, (boolean)true);
        } else {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)"");
        }
    }

    private File exportArchive(IProject proj, IProgressMonitor monitor) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
        model.setStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", proj.getName());
        String ext = FacetUtil.getResourceExtension((IProject)proj);
        IPath resStateLoc = ResourcesPlugin.getPlugin().getStateLocation();
        File projTempFolder = new File(String.valueOf(resStateLoc.toOSString()) + "/.project/" + proj.getName());
        String appRootPath = projTempFolder + "/planGen/";
        String archiveDest = String.valueOf(appRootPath) + proj.getName() + ext;
        model.setStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", archiveDest);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
        model.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)comp);
        try {
            if (".war".equals(ext)) {
                this.exportWar(monitor, model);
            } else if (".ear".equals(ext)) {
                this.exportEar(monitor, model);
            } else {
                this.exportEjbJar(monitor, model);
            }
        }
        catch (ExecutionException e) {
            LoggingService.logException((Plugin)WlsUiPlugin.getInstance(), (Throwable)e);
        }
        if (new File(archiveDest).exists()) {
            return new File(archiveDest);
        }
        return null;
    }

    private void exportEar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.EarExportPreOperation preOp = new WLSExportOperation.EarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        EARComponentExportOperation exportOp = new EARComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.EarExportPostOperation postOp = new WLSExportOperation.EarExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    private void exportWar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.WarExportPreOperation preOp = new WLSExportOperation.WarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        WebComponentExportOperation exportOp = new WebComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.WarExportPostOperation postOp = new WLSExportOperation.WarExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    private void exportEjbJar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.EarExportPreOperation preOp = new WLSExportOperation.EarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        EJBComponentExportOperation exportOp = new EJBComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.EjbExportPostOperation postOp = new WLSExportOperation.EjbExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    protected boolean allowLinking() {
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String overwriteExistingFile;
        public static String invalidaFileExtenstion;
        public static String invalidaFileName;
        public static String pageDescription;
        public static String pageTitle;
        public static String pageHeader;
        public static String applicationName;
        public static String targetServerVersion;
        public static String planGenTaskName1;
        public static String planGenTaskName2;
        public static String planGenTaskName;
        public static String planGenTaskFailed;

        static {
            Resources.initializeMessages((String)NewDeploymentPlanFileWizardPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

