/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal.jms;

import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class MessagingPerformancePreferenceBrowseHandler
extends BrowseActionHandler {
    private static final PerformanceValue[] VALUES = new PerformanceValue[]{new PerformanceValue(Resources.int0, Resources.desc0), new PerformanceValue(Resources.int25, Resources.desc25), new PerformanceValue(Resources.int50, Resources.desc50), new PerformanceValue(Resources.int75, Resources.desc75), new PerformanceValue(Resources.int100, Resources.desc100)};

    public String browse(Presentation context) {
        ValueProperty property = this.property().definition();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(((SwtPresentation)context).shell(), (ILabelProvider)new LabelProvider()){

            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                list.setComparator((Comparator)PerformanceComparator.INSTANCE);
                return list;
            }
        };
        dialog.setElements((Object[])VALUES);
        dialog.setMultipleSelection(false);
        dialog.setHelpAvailable(false);
        dialog.setTitle(property.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return ((PerformanceValue)result[0]).getValue();
        }
        return null;
    }

    private static final class PerformanceComparator
    implements Comparator<String> {
        private static final PerformanceComparator INSTANCE = new PerformanceComparator();

        private PerformanceComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            int index0 = arg0.indexOf(40);
            Integer int0 = new Integer(arg0.substring(0, index0 - 1));
            int index1 = arg1.indexOf(40);
            Integer int1 = new Integer(arg1.substring(0, index1 - 1));
            return int0.compareTo(int1);
        }
    }

    private static final class PerformanceValue {
        private String value;
        private String description;

        public PerformanceValue(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return Resources.bind((String)Resources.buildDescription, (Object)this.value, (Object)this.description);
        }
    }

    private static final class Resources
    extends NLS {
        public static String buildDescription;
        public static String int0;
        public static String int25;
        public static String int50;
        public static String int75;
        public static String int100;
        public static String desc0;
        public static String desc25;
        public static String desc50;
        public static String desc75;
        public static String desc100;

        static {
            Resources.initializeMessages((String)MessagingPerformancePreferenceBrowseHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

