/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import java.io.File;
import oracle.eclipse.tools.common.ui.dialogs.XPathSelectionDialog;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.weblogic.J2EEDescriptorCatalog;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsDescriptorCatalog;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableAssignment;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class XPathBrowseHandler
extends BrowseActionHandler {
    public String browse(Presentation context) {
        String uri;
        WebLogicServerVersion serverVersion;
        String descriptorType;
        IVariableAssignment assignment;
        block12: {
            String appName;
            IProject proj;
            block13: {
                assignment = (IVariableAssignment)this.getModelElement();
                IModuleDescriptor descriptor = (IModuleDescriptor)assignment.parent().element();
                descriptorType = descriptor.getRootElement().text();
                if (descriptorType == null) {
                    return "";
                }
                IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)descriptor.nearest(IWeblogicDeploymentPlan.class);
                File file = (File)plan.adapt(File.class);
                IFile workspaceFile = EclipseFileUtil.getWorkspaceFile((File)file);
                if (workspaceFile == null) {
                    return "";
                }
                proj = workspaceFile.getProject();
                serverVersion = null;
                try {
                    IFacetedProject fproj = ProjectFacetsManager.create((IProject)proj);
                    if (fproj != null) {
                        serverVersion = WebLogicServerVersion.detect((IProject)proj);
                        break block12;
                    }
                    appName = plan.getApplicationName().text();
                    if (appName != null) break block13;
                    return "";
                }
                catch (CoreException coreException) {}
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(appName);
            if (res instanceof IProject) {
                proj = (IProject)res;
                serverVersion = WebLogicServerVersion.detect((IProject)proj);
            }
        }
        if (serverVersion == null) {
            serverVersion = WebLogicServerVersion.VERSION_10_3_0;
        }
        if ((uri = WlsDescriptorCatalog.getInstance().findDescriptorUri(serverVersion, descriptorType)) == null) {
            String j2eeVersion = "5.0";
            if (serverVersion == WebLogicServerVersion.VERSION_9_2) {
                j2eeVersion = "1.4";
            }
            uri = J2EEDescriptorCatalog.getInstance().findDescriptorUri(j2eeVersion, descriptorType);
        }
        if (uri != null) {
            String initialNodePath = assignment.getXpath().text();
            XPathSelectionDialog dlg = new XPathSelectionDialog(Display.getDefault().getActiveShell(), uri);
            dlg.setInitialNodePath(initialNodePath);
            if (dlg.open() == 0) {
                return dlg.getXPath();
            }
        }
        return null;
    }
}

