/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import oracle.eclipse.tools.weblogic.WebLogicDescriptorInfo;
import oracle.eclipse.tools.weblogic.WebLogicDescriptorType;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import oracle.eclipse.tools.weblogic.facets.CoreWlsExtensionFacetsGroup;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class WebLogicServerVersionActionsContributor
extends PropertyEditorAssistContributor {
    private static final String ID = "WebLogic.ServerVersionActionsContributor";
    private static final int PRIORITY = 400;

    public WebLogicServerVersionActionsContributor() {
        this.setId(ID);
        this.setPriority(400);
    }

    public void contribute(final PropertyEditorAssistContext context) {
        org.eclipse.sapphire.Element element = context.getPart().getLocalModelElement();
        final IWebLogicDescriptor descriptor = (IWebLogicDescriptor)element.nearest(IWebLogicDescriptor.class);
        Value val = descriptor.getServerVersion();
        Status valres = val.validation();
        if (valres.severity() == Status.Severity.ERROR) {
            IFacetedProject fproj;
            String type = valres.type();
            WebLogicServerVersion version = WebLogicServerVersion.convert((Version)((Version)val.content()));
            if (version == null) {
                version = WebLogicServerVersion.convert((Version)((Version)val.getDefaultContent()));
            }
            PropertyEditorAssistContribution.Factory contribution = null;
            String actionLabel = null;
            PropertyEditorAssistSection section = context.getSection("actions");
            if (type.equals("Oracle.WebLogicServer.Tools.NamespaceDoesNotMatch")) {
                XmlElement root = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(false);
                WebLogicDescriptorType descriptorType = WebLogicDescriptorType.getDescriptorType((IWebLogicDescriptor)descriptor);
                final WebLogicDescriptorInfo dinfo = descriptorType.getDescriptorInfo(version);
                final String currentNamespace = root.getDomNode().getNamespaceURI();
                final String expectedNamespace = dinfo.getNamespace();
                contribution = PropertyEditorAssistContribution.factory();
                actionLabel = Resources.changeNamespaceToMatchAction;
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + WebLogicServerVersionActionsContributor.escapeForXml((String)actionLabel) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        Document document = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement().getDomNode().getOwnerDocument();
                        XmlUtil.changeNamespace((Document)document, (String)currentNamespace, (String)expectedNamespace, (String)dinfo.getSchemaLocation());
                    }
                });
                section.addContribution(contribution.create());
            } else if (type.equals("Oracle.WebLogicServer.Tools.InvalidSchemaLocation")) {
                final XmlElement root = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(false);
                WebLogicDescriptorType descriptorType = WebLogicDescriptorType.getDescriptorType((IWebLogicDescriptor)descriptor);
                final WebLogicDescriptorInfo dinfo = descriptorType.getDescriptorInfo(version);
                contribution = PropertyEditorAssistContribution.factory();
                actionLabel = Resources.fixSchemaLocationDeclAction;
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + WebLogicServerVersionActionsContributor.escapeForXml((String)actionLabel) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        XmlUtil.configSchemaLocation((Element)root.getDomNode(), (String)dinfo.getSchemaLocation());
                    }
                });
                section.addContribution(contribution.create());
            } else if (type.equals("Oracle.WebLogicServer.Tools.FacetDoesNotMatch") && (fproj = WebLogicServerVersionActionsContributor.fproj((IProject)descriptor.adapt(IProject.class))) != null) {
                final IProjectFacetVersion fv = CoreWlsExtensionFacetsGroup.findInstalledMember((IFacetedProject)fproj);
                contribution = PropertyEditorAssistContribution.factory();
                actionLabel = NLS.bind((String)Resources.changeServerVersionToMatchAction, (Object)fv.getVersionString());
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + WebLogicServerVersionActionsContributor.escapeForXml((String)actionLabel) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        descriptor.setServerVersion(fv.getVersionString());
                    }
                });
                section.addContribution(contribution.create());
                final String verstr = version.getFacetVersionString();
                contribution = PropertyEditorAssistContribution.factory();
                actionLabel = NLS.bind((String)Resources.changeFacetToMatchAction, (Object)fv.getProjectFacet().getLabel(), (Object)verstr);
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + WebLogicServerVersionActionsContributor.escapeForXml((String)actionLabel) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IFacetedProjectWorkingCopy fpjwc = fproj.createWorkingCopy();
                            fpjwc.changeProjectFacetVersion(fv.getProjectFacet().getVersion(verstr));
                            if (fpjwc.validate().getSeverity() != 4) {
                                fpjwc.commitChanges(null);
                            } else {
                                String msg = NLS.bind((String)Resources.unableToChangeFacetVersion, (Object)fv.getProjectFacet().getLabel(), (Object)verstr);
                                MessageDialog.openError((Shell)context.getShell(), (String)Resources.operationFailedTitle, (String)msg);
                            }
                        }
                        catch (CoreException e) {
                            WlsUiPlugin.logException((Exception)((Object)e));
                        }
                    }
                });
                section.addContribution(contribution.create());
            }
        }
    }

    private static IFacetedProject fproj(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            WlsUiPlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String changeNamespaceToMatchAction;
        public static String fixSchemaLocationDeclAction;
        public static String changeFacetToMatchAction;
        public static String changeServerVersionToMatchAction;
        public static String unableToChangeFacetVersion;
        public static String operationFailedTitle;

        static {
            Resources.initializeMessages((String)WebLogicServerVersionActionsContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

