/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariable;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableAssignment;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class VariableReferencesElementFactory
extends FormComponentPart {
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new FormComponentPresentation(this, parent, composite){
            private Composite linksPanel;

            public void render() {
                Composite parent = this.composite();
                Label label = new Label(parent, 0);
                label.setText(Resources.referencedBy);
                label.setLayoutData((Object)SwtUtil.valign((GridData)SwtUtil.gdhindent((GridData)SwtUtil.gd(), (int)9), (int)128));
                this.linksPanel = new Composite(parent, 0);
                this.linksPanel.setLayoutData((Object)SwtUtil.gdhindent((GridData)SwtUtil.gdhfill(), (int)9));
                this.linksPanel.setLayout((Layout)SwtUtil.glayout((int)1, (int)0, (int)0));
                this.updateVariableReferences();
            }

            private void updateVariableReferences() {
                if (this.linksPanel == null) {
                    return;
                }
                Control[] controlArray = this.linksPanel.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                IVariable var = (IVariable)VariableReferencesElementFactory.this.getModelElement();
                boolean referenced = false;
                if (var != null) {
                    String varName = var.getName().text();
                    IWeblogicDeploymentPlan planModel = (IWeblogicDeploymentPlan)var.nearest(IWeblogicDeploymentPlan.class);
                    ElementList modules = planModel.getModuleOverride();
                    for (IModuleOverride m : modules) {
                        String moduleName = m.getModuleName().text();
                        for (IModuleDescriptor desc : m.getModuleDescriptors()) {
                            String descriptorName = desc.getUri().text();
                            for (IVariableAssignment assign : desc.getVariableAssignments()) {
                                String assignName = assign.getName().text();
                                if (assignName == null || !assignName.equals(varName)) continue;
                                referenced = true;
                                Link link = new Link(this.linksPanel, 0);
                                link.setLayoutData((Object)SwtUtil.gd());
                                link.addSelectionListener(new SelectionListener(){

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                    }

                                    public void widgetSelected(SelectionEvent e) {
                                        String nodePath = ((Link)e.getSource()).getData().toString();
                                        SapphireEditor editor = (SapphireEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                        ((MasterDetailsEditorPage)editor.getPage()).outline().setSelection(nodePath);
                                    }
                                });
                                StringBuilder nodePath = new StringBuilder();
                                nodePath.append("Modules");
                                nodePath.append("/");
                                nodePath.append(moduleName);
                                nodePath.append("/");
                                nodePath.append(desc.getRootElement().text());
                                link.setData((Object)nodePath);
                                link.setText("<a>" + moduleName + "/" + descriptorName + "</a>");
                            }
                        }
                    }
                }
                if (!referenced) {
                    Label label = new Label(this.linksPanel, 0);
                    label.setLayoutData((Object)SwtUtil.gd());
                    label.setText(Resources.nothing);
                }
            }
        };
    }

    private static final class Resources
    extends NLS {
        public static String referencedBy;
        public static String nothing;

        static {
            Resources.initializeMessages((String)VariableReferencesElementFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

