/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRefDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.ui.j2eelib.BrowseLibraryModulesDialog;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;

public final class SharedLibrariesAddActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        MasterDetailsContentNodePart node = (MasterDetailsContentNodePart)this.getPart();
        ILibraryRefDescriptorPart descriptor = (ILibraryRefDescriptorPart)node.getModelElement().nearest(ILibraryRefDescriptorPart.class);
        boolean isWebModuleDescriptor = descriptor instanceof IWebLogicWebModuleDescriptor;
        BrowseLibraryModulesDialog dialog = new BrowseLibraryModulesDialog(((SwtPresentation)context).shell(), isWebModuleDescriptor, true);
        ILibraryRef firstAddedLibraryRef = null;
        if (dialog.open() == 0) {
            for (LibraryModule module : dialog.getLibraryModules()) {
                boolean libRefExistsAlready = false;
                for (ILibraryRef x : descriptor.getLibraryRefs()) {
                    String libName = x.getLibraryName().text();
                    if (libName == null || !libName.equals(module.getName())) continue;
                    libRefExistsAlready = true;
                    break;
                }
                if (libRefExistsAlready) continue;
                ILibraryRef libref = null;
                try {
                    libref = (ILibraryRef)descriptor.getLibraryRefs().insert();
                }
                catch (EditFailedException editFailedException) {
                    return null;
                }
                libref.setLibraryName(module.getName());
                libref.setSpecificationVersion(StringUtil.toStringNullable((Object)module.getSpecificationVersion()));
                libref.setExactMatchRequired(Boolean.valueOf(true));
                if (firstAddedLibraryRef != null) continue;
                firstAddedLibraryRef = libref;
            }
            if (firstAddedLibraryRef != null) {
                for (MasterDetailsContentNodePart n : node.nodes()) {
                    if (n.getModelElement() != firstAddedLibraryRef) continue;
                    n.select();
                }
            }
        }
        return null;
    }
}

