/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.weblogic.J2EEDescriptorCatalog;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsDescriptorCatalog;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;

public final class DescriptorUriBrowseHandler
extends BrowseActionHandler {
    public String browse(Presentation context) {
        Element element = this.getModelElement();
        DescriptorUriSelectionDialog dlg = new DescriptorUriSelectionDialog(Display.getDefault().getActiveShell(), WebLogicServerVersion.VERSION_10_3_0, this.getModuleOverride(element).getModuleType().text(), element);
        dlg.setElements(this.findExisitingDescriptors(element).toArray());
        dlg.open();
        String ret = null;
        if (dlg.getResult() != null) {
            ret = dlg.getResult()[0].toString();
        }
        return ret;
    }

    private IModuleOverride getModuleOverride(Element modelElement) {
        IModuleDescriptor descriptor = (IModuleDescriptor)modelElement;
        IModuleOverride moduleElm = (IModuleOverride)descriptor.nearest(IModuleOverride.class);
        return moduleElm;
    }

    public Collection<String> findExisitingDescriptors(Element modelElement) {
        ArrayList<String> ret = new ArrayList<String>();
        String moduleName = this.getModuleOverride(modelElement).getModuleName().text();
        IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)modelElement.nearest(IWeblogicDeploymentPlan.class);
        File file = (File)plan.adapt(File.class);
        IFile workspaceFile = FileUtil.getWorkspaceFile((File)file);
        if (workspaceFile == null) {
            return ret;
        }
        IProject proj = workspaceFile.getProject();
        String appName = plan.getApplicationName().text();
        if (appName == null) {
            return ret;
        }
        String projectName = appName.indexOf(46) > 0 ? appName.substring(0, appName.lastIndexOf(46)) : appName;
        WlsDescriptorCatalog.findDescriptorsInModule((IProject)proj, (String)projectName, (String)moduleName, ret);
        return ret;
    }

    private final class DescriptorUriSelectionDialog
    extends ElementListSelectionDialog {
        WebLogicServerVersion wlsServerVersion;
        String moduleType;
        private Element modelElement;

        DescriptorUriSelectionDialog(Shell shell, WebLogicServerVersion wlsServerVersion, String moduleType, Element modelElement) {
            super(shell, new ILabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element.toString();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.wlsServerVersion = null;
            this.moduleType = null;
            this.wlsServerVersion = wlsServerVersion;
            this.moduleType = moduleType;
            this.modelElement = modelElement;
            this.setTitle(Resources.dlgTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Control ret = super.createDialogArea(parent);
            this.createShowDescriptorCheckbox(parent);
            return ret;
        }

        private void createShowDescriptorCheckbox(Composite parent) {
            final Button showExistingOnlyBtn = new Button(parent, 32);
            GridData data = new GridData();
            data.grabExcessVerticalSpace = false;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.horizontalIndent = 10;
            showExistingOnlyBtn.setText(Resources.showExistingOnly);
            showExistingOnlyBtn.setLayoutData((Object)data);
            showExistingOnlyBtn.setFont(parent.getFont());
            showExistingOnlyBtn.setSelection(true);
            showExistingOnlyBtn.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (!showExistingOnlyBtn.getSelection()) {
                        ArrayList ret = new ArrayList();
                        ret.addAll(WlsDescriptorCatalog.getInstance().getDescriptorFileNames(DescriptorUriSelectionDialog.this.wlsServerVersion, DescriptorUriSelectionDialog.this.moduleType));
                        ret.addAll(J2EEDescriptorCatalog.getInstance().getDescriptorFileNames(DescriptorUriSelectionDialog.this.moduleType));
                        DescriptorUriSelectionDialog.this.setListElements(ret.toArray());
                    } else {
                        DescriptorUriSelectionDialog.this.setListElements(DescriptorUriBrowseHandler.this.findExisitingDescriptors(DescriptorUriSelectionDialog.this.modelElement).toArray());
                    }
                }
            });
        }
    }

    private static final class Resources
    extends NLS {
        public static String dlgTitle;
        public static String showExistingOnly;

        static {
            Resources.initializeMessages((String)DescriptorUriBrowseHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

