/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.OEPECheckedListDialogField;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariable;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableAssignment;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableDefinition;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class CleanupDeployPlanAction
extends SapphireActionHandler {
    public static final ImageDescriptor DESC_UNASSIGNED_NULL_VALUE_VARAIBLE = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"/images/descriptors/null-unassigned.png");
    public static final ImageDescriptor DESC_UNASSIGNED_NONNULL_VALUE_VARAIBLE = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"/images/descriptors/non-null-unassigned.png");
    public static final ImageDescriptor DESC_ASSIGNED_NULL_VALUE_VARAIBLE = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"/images/descriptors/null-assigned.png");
    public static final ImageDescriptor DESC_UNDEFINED_VARAIBLE = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"/images/descriptors/undefined-variable.gif");
    public static final ImageDescriptor DESC_DESCRIPTOR_WITH_NO_OVERRIDE = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"/images/descriptors/null-unassigned.png");

    protected Object run(Presentation context) {
        IWeblogicDeploymentPlan planModel = (IWeblogicDeploymentPlan)this.getPart().getModelElement().nearest(IWeblogicDeploymentPlan.class);
        IVariableDefinition varDef = planModel.getVariableDefinition();
        HashSet<String> allVarNames = new HashSet<String>();
        LinkedList<RemoveableElementRef> removableElements = new LinkedList<RemoveableElementRef>();
        ElementList variables = varDef.getVariables();
        for (IVariable var : variables) {
            allVarNames.add(var.getName().text());
            if (!((Boolean)var.getAssigned().content()).booleanValue()) {
                if (((Boolean)var.getAssignNullAttribute().content()).booleanValue()) {
                    removableElements.add(new RemoveableElementRef(variables, (Element)var, var.getName().text(), 1));
                    continue;
                }
                removableElements.add(new RemoveableElementRef(variables, (Element)var, var.getName().text(), 2));
                continue;
            }
            if (!((Boolean)var.getAssignNullAttribute().content()).booleanValue()) continue;
            removableElements.add(new RemoveableElementRef(variables, (Element)var, var.getName().text(), 3));
        }
        ElementList modules = planModel.getModuleOverride();
        for (IModuleOverride m : modules) {
            String moduleName = m.getModuleName().text();
            ElementList descriptors = m.getModuleDescriptors();
            for (IModuleDescriptor desc : descriptors) {
                String descriptorName = desc.getUri().text();
                if (desc.getVariableAssignments().size() == 0) {
                    String descPath = String.valueOf(moduleName) + "/" + descriptorName;
                    RemoveableElementRef descWithNoOverride = new RemoveableElementRef(descriptors, (Element)desc, descPath, 5);
                    removableElements.add(descWithNoOverride);
                }
                ElementList assignments = desc.getVariableAssignments();
                for (IVariableAssignment varAssign : assignments) {
                    String assignName = varAssign.getName().text();
                    if (allVarNames.contains(assignName)) continue;
                    RemoveableElementRef undefined = new RemoveableElementRef(assignments, (Element)varAssign, varAssign.getName().text(), 4);
                    if (removableElements.size() > 0) {
                        removableElements.add(0, undefined);
                        continue;
                    }
                    removableElements.add(undefined);
                }
            }
        }
        this.promptRemovableElements(removableElements);
        return null;
    }

    private void promptRemovableElements(List<RemoveableElementRef> removableElements) {
        CleanupDeployPlanWizard wizard = new CleanupDeployPlanWizard(removableElements);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        int SIZING_WIZARD_WIDTH = 600;
        int SIZING_WIZARD_HEIGHT = 400;
        dialog.create();
        dialog.getShell().setSize(Math.max(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().x), SIZING_WIZARD_HEIGHT);
        if (dialog.open() == 0) {
            for (RemoveableElementRef elm : wizard.getElementsToRemove()) {
                elm.remove();
            }
        }
    }

    class CleanupDeployPlanWizard
    extends Wizard {
        List<RemoveableElementRef> removableElements;
        CleanupDeployPlanWizardPage page1;
        List<RemoveableElementRef> elementsToRemove = new ArrayList<RemoveableElementRef>();

        public CleanupDeployPlanWizard(List<RemoveableElementRef> removableElements) {
            this.removableElements = removableElements;
            this.setWindowTitle(Resources.wizardTitle);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_CLEAN_UP);
            this.setHelpAvailable(false);
        }

        public void addPages() {
            this.page1 = new CleanupDeployPlanWizardPage("selecteElementsPage");
            this.addPage((IWizardPage)this.page1);
        }

        public List<RemoveableElementRef> getElementsToRemove() {
            return this.elementsToRemove;
        }

        public boolean canFinish() {
            return true;
        }

        public boolean performFinish() {
            List ret = this.page1.getSelected();
            if (ret.size() > 0) {
                for (Object o : ret) {
                    RemoveableElementRef ref = (RemoveableElementRef)o;
                    this.elementsToRemove.add(ref);
                }
            }
            return true;
        }
    }

    class CleanupDeployPlanWizardPage
    extends WizardPage {
        OEPECheckedListDialogField dlgField;
        public static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.weblogic.ui.CleanUpDeployPlanWizard";

        protected CleanupDeployPlanWizardPage(String pageName) {
            super(pageName);
            this.setTitle(Resources.wizardTitle);
            this.setDescription(Resources.wizardDesc);
        }

        public void createControl(Composite parent) {
            CleanupDeployPlanWizard wizard = (CleanupDeployPlanWizard)this.getWizard();
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout(3, false));
            this.setControl((Control)comp);
            Label label = new Label(comp, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = 3;
            label.setLayoutData((Object)gd);
            if (wizard.removableElements.size() == 0) {
                label.setText(Resources.noErrorWasFound);
                return;
            }
            label.setText(Resources.cleanupCandidates);
            this.dlgField = new OEPECheckedListDialogField(null, new ILabelProvider(){
                String[] msg = new String[]{Resources.nullVariableNotUsed, Resources.variableNotUsed, Resources.variableNullValue, Resources.variableNotDefined, Resources.descriptorNoOverride};

                public Image getImage(Object element) {
                    RemoveableElementRef ref = (RemoveableElementRef)element;
                    SwtResourceCache imageCache = CleanupDeployPlanAction.this.getPart().getSwtResourceCache();
                    Image ret = null;
                    if (ref.reasonCode == 1) {
                        ret = imageCache.image(DESC_UNASSIGNED_NULL_VALUE_VARAIBLE);
                    } else if (ref.reasonCode == 2) {
                        ret = imageCache.image(DESC_UNASSIGNED_NONNULL_VALUE_VARAIBLE);
                    } else if (ref.reasonCode == 3) {
                        ret = imageCache.image(DESC_ASSIGNED_NULL_VALUE_VARAIBLE);
                    } else if (ref.reasonCode == 4) {
                        ret = imageCache.image(DESC_UNDEFINED_VARAIBLE);
                    } else if (ref.reasonCode == 5) {
                        ret = imageCache.image(DESC_DESCRIPTOR_WITH_NO_OVERRIDE);
                    }
                    return ret;
                }

                public String getText(Object element) {
                    RemoveableElementRef ref = (RemoveableElementRef)element;
                    String name = ref.getName();
                    String label = String.format(this.msg[ref.reasonCode - 1], name);
                    return label;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.dlgField.doFillIntoGrid(comp, 3);
            this.dlgField.setViewerComparator((ViewerComparator)new ViewerSorter(){

                public int category(Object element) {
                    RemoveableElementRef ref = (RemoveableElementRef)element;
                    return ref.getReason();
                }
            });
            this.dlgField.setElements(wizard.removableElements);
        }

        public List getSelected() {
            if (this.dlgField == null) {
                return Collections.EMPTY_LIST;
            }
            return this.dlgField.getCheckedElements();
        }

        public final void performHelp() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(HELP_CONTEXT_ID);
        }
    }

    private static final class RemoveableElementRef {
        static final int UNASSIGNED_NULL_VALUE_VARAIBLE = 1;
        static final int UNASSIGNED_NONNULL_VALUE_VARAIBLE = 2;
        static final int ASSIGNED_NULL_VALUE_VARAIBLE = 3;
        static final int UNDEFINED_VARAIBLE_ASSIGNMENT = 4;
        static final int DESCRIPTOR_WITH_NO_OVERRIDE = 5;
        private final ElementList<?> list;
        private final Element element;
        private final String name;
        private final int reasonCode;

        public RemoveableElementRef(ElementList<?> list, Element element, String name, int reasonCode) {
            this.list = list;
            this.element = element;
            this.name = name;
            this.reasonCode = reasonCode;
        }

        public int getReason() {
            return this.reasonCode;
        }

        public String getName() {
            return this.name;
        }

        public void remove() {
            this.list.remove((Object)this.element);
        }
    }

    private static final class Resources
    extends NLS {
        public static String wizardDesc;
        public static String wizardTitle;
        public static String cleanupCandidates;
        public static String noErrorWasFound;
        public static String nullVariableNotUsed;
        public static String variableNotUsed;
        public static String variableNullValue;
        public static String variableNotDefined;
        public static String descriptorNoOverride;

        static {
            Resources.initializeMessages((String)CleanupDeployPlanAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

