/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.common.internal;

import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class LibraryRefContextRootActionsContributor
extends PropertyEditorAssistContributor {
    private static final String ID = "WebLogic.LibraryRefContextRootActionsContributor";
    private static final int PRIORITY = 400;

    public LibraryRefContextRootActionsContributor() {
        this.setId(ID);
        this.setPriority(400);
    }

    public void contribute(PropertyEditorAssistContext context) {
        final ILibraryRef libref = (ILibraryRef)context.getPart().getLocalModelElement();
        Value contextRoot = libref.getContextRoot();
        final String contextRootDefaultValue = (String)contextRoot.getDefaultContent();
        if (contextRoot.text(false) == null && contextRootDefaultValue != null) {
            PropertyEditorAssistSection section = context.getSection("actions");
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            String actionLabel = NLS.bind((String)Resources.setContextRootExplicitly, (Object)contextRootDefaultValue);
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + LibraryRefContextRootActionsContributor.escapeForXml((String)actionLabel) + "</a></p>");
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    libref.setContextRoot(contextRootDefaultValue);
                }
            });
            section.addContribution(contribution.create());
        }
    }

    private static final class Resources
    extends NLS {
        public static String setContextRootExplicitly;

        static {
            Resources.initializeMessages((String)LibraryRefContextRootActionsContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

