/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.credential;

import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.ui.credential.KeystoreDialog;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class EditKeystoreActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        KeystoreResource kres;
        block4: {
            Element credential = context.part().getModelElement();
            String path = this.getKeystorePath(credential);
            String passwd = this.getPassword(credential);
            if (this.isNull(path) || this.isNull(passwd)) {
                return null;
            }
            kres = new KeystoreResource(path, passwd);
            IStatus ret = kres.refresh();
            if (ret.isOK()) break block4;
            ErrorDialog.openError((Shell)((SwtPresentation)context).shell(), (String)"Error", (String)"", (IStatus)ret);
            return null;
        }
        try {
            IKeystore ks = (IKeystore)IKeystore.TYPE.instantiate((Resource)kres);
            KeystoreDialog dlg = new KeystoreDialog(Display.getDefault().getActiveShell(), (Element)ks);
            dlg.open();
            ks.dispose();
        }
        catch (Exception e) {
            IStatus sts = WlsUiPlugin.createErrorStatus(e);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error open keystore", (IStatus)sts);
        }
        return null;
    }

    private boolean isNull(String val) {
        return val == null || val.trim().length() == 0;
    }

    protected abstract String getKeystorePath(Element var1);

    protected abstract String getPassword(Element var1);

    public boolean isEnabled() {
        Element credential = this.getModelElement();
        String path = this.getKeystorePath(credential);
        String passwd = this.getPassword(credential);
        return path != null && passwd != null;
    }
}

