/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.applib.internal;

import oracle.eclipse.tools.weblogic.WlsEarUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AppLibrariesContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private String containerId;
    private IProject earProject;
    private Label earProjectsLabel;
    private Combo earProjectsCombo;

    public AppLibrariesContainerPage() {
        super(Resources.title);
        this.setTitle(Resources.title);
        this.setDescription(Resources.description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    public void initialize(IJavaProject jproject, IClasspathEntry[] cp) {
    }

    public IClasspathEntry getSelection() {
        int sel = this.earProjectsCombo.getSelectionIndex();
        String pjname = this.earProjectsCombo.getItem(sel).trim();
        IPath containerPath = new Path(this.containerId).append(pjname);
        return JavaCore.newContainerEntry((IPath)containerPath);
    }

    public void setSelection(IClasspathEntry cpe) {
        IPath path;
        if (cpe != null && (path = cpe.getPath()).segmentCount() == 2) {
            this.containerId = path.segment(0);
            String pjname = path.segment(1);
            this.earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pjname);
            return;
        }
        this.containerId = "oracle.eclipse.tools.weblogic.lib.application";
        this.earProject = null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.earProjectsLabel = new Label(composite, 0);
        this.earProjectsLabel.setText(Resources.earListLabel);
        this.earProjectsCombo = new Combo(composite, 12);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.earProjectsCombo.setLayoutData((Object)gd);
        int i = 0;
        for (IProject project : WlsEarUtil.findEarProjects()) {
            String pjname = project.getName();
            this.earProjectsCombo.add(pjname);
            if (this.earProject != null && this.earProject.getName().equals(pjname)) {
                this.earProjectsCombo.select(i);
            }
            ++i;
        }
        if (this.earProject == null && this.earProjectsCombo.getItemCount() > 0) {
            this.earProjectsCombo.select(0);
        }
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return this.earProjectsCombo.getSelectionIndex() != -1;
    }

    private static final class Resources
    extends NLS {
        public static String title;
        public static String description;
        public static String earListLabel;

        static {
            Resources.initializeMessages((String)AppLibrariesContainerPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

