/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.search.ExtensionPluginSearchScope;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.BaseSearchAction;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.osgi.framework.Version;

public class FindReferencesAction
extends BaseSearchAction {
    private Object fSelectedObject;
    private String fPluginID;

    public FindReferencesAction(Object object, String pluginID) {
        super(PDEUIMessages.SearchAction_references);
        this.fSelectedObject = object;
        this.fPluginID = pluginID;
        this.initialize();
    }

    private void initialize() {
        this.setImageDescriptor(PDEPluginImages.DESC_PSEARCH_OBJ);
    }

    protected ISearchQuery createSearchQuery() {
        PluginSearchInput input = new PluginSearchInput();
        PluginSearchScope scope = null;
        if (this.fSelectedObject instanceof IPlugin) {
            input.setSearchElement(1);
            input.setSearchString(((IPlugin)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginExtensionPoint) {
            Version fileVersion;
            input.setSearchElement(3);
            String extensionID = ((IPluginExtensionPoint)this.fSelectedObject).getId();
            IPluginModelBase model = ((IPluginExtensionPoint)this.fSelectedObject).getPluginModel();
            String schemaVersion = model.getPluginBase().getSchemaVersion();
            Version version = fileVersion = schemaVersion != null ? new Version(schemaVersion) : null;
            if ((fileVersion == null || fileVersion.compareTo(new Version("3.2")) >= 0) && extensionID.indexOf(46) >= 0) {
                input.setSearchString(extensionID);
            } else {
                String id = model.getPluginBase().getId();
                if (id == null || id.trim().length() == 0) {
                    id = this.fPluginID;
                }
                if (id == null || id.trim().length() == 0) {
                    id = "*";
                }
                input.setSearchString(String.valueOf(id) + "." + extensionID);
            }
            scope = new ExtensionPluginSearchScope(input);
        } else if (this.fSelectedObject instanceof IPluginImport) {
            input.setSearchElement(1);
            input.setSearchString(((IPluginImport)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginExtension) {
            input.setSearchElement(3);
            input.setSearchString(((IPluginExtension)this.fSelectedObject).getPoint());
            input.setSearchScope((PluginSearchScope)new ExtensionPluginSearchScope(input));
        }
        input.setSearchLimit(2);
        input.setSearchScope(scope == null ? new PluginSearchScope() : scope);
        return new PluginSearchQuery(input);
    }
}

