/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private Map<Position, IManifestHeader> fPositionToElement = new HashMap<Position, IManifestHeader>();

    public BundleFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    @Override
    public void addFoldingRegions(Set<Position> currentRegions, IEditingModel model) throws BadLocationException {
        IBundle bundle = ((BundleModel)model).getBundle();
        IManifestHeader importPackageHeader = bundle.getManifestHeader("Import-Package");
        IManifestHeader exportPackageHeader = bundle.getManifestHeader("Export-Package");
        IManifestHeader requireBundleHeader = bundle.getManifestHeader("Require-Bundle");
        try {
            this.addFoldingRegions(currentRegions, importPackageHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, exportPackageHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, requireBundleHeader, model.getDocument());
        }
        catch (BadLocationException badLocationException) {}
    }

    private void addFoldingRegions(Set<Position> regions, IManifestHeader header, IDocument document) throws BadLocationException {
        int endLine;
        if (header == null) {
            return;
        }
        int startLine = document.getLineOfOffset(header.getOffset());
        if (startLine < (endLine = document.getLineOfOffset(header.getOffset() + header.getLength() - 1))) {
            int start = document.getLineOffset(startLine);
            int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
            Position position = new Position(start, end - start);
            regions.add(position);
            this.fPositionToElement.put(position, header);
        }
    }
}

