/*-
 *
 *  This file is part of Oracle NoSQL Database
 *  Copyright (C) 2011, 2014 Oracle and/or its affiliates.  All rights reserved.
 *
 *  Oracle NoSQL Database is free software: you can redistribute it and/or
 *  modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation, version 3.
 *
 *  Oracle NoSQL Database is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public
 *  License in the LICENSE file along with Oracle NoSQL Database.  If not,
 *  see <http://www.gnu.org/licenses/>.
 *
 *  An active Oracle commercial licensing agreement for this product
 *  supercedes this license.
 *
 *  For more information please contact:
 *
 *  Vice President Legal, Development
 *  Oracle America, Inc.
 *  5OP-10
 *  500 Oracle Parkway
 *  Redwood Shores, CA 94065
 *
 *  or
 *
 *  berkeleydb-info_us@oracle.com
 *
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  EOF
 *
 */

package oracle.kv.table;

import java.util.List;

/**
 * IndexKey is a specialization of RecordValue to represent a key used to
 * access a specific index defined on a table. It may contain all or part of a
 * the fields associated with the index.  If partial the fields must be set in
 * order of significance, as defined by the list returned by {@link #getFields}.
 * If an attempt is made to set a field that is not part of the index
 * IllegalArgumentException is thrown.
 *<p>
 * IndexKey objects are constructed using
 * {@link Index#createIndexKey createIndexKey}.
 *
 * @since 3.0
 */

public interface IndexKey extends RecordValue {

    /**
     * Returns the Index associated with this key.
     *
     * @return the Index
     */
    Index getIndex();

    /**
     * Returns an unmodifiable list of fields, in key order, that
     * comprise this key.  This method returns the same list as {@link
     * Index#getFields} for this instance's Index.
     *
     * @return the fields
     *
     * @since 3.0.6
     */
    @Override
    List<String> getFields();
}
