/*-
 *
 *  This file is part of Oracle NoSQL Database
 *  Copyright (C) 2011, 2014 Oracle and/or its affiliates.  All rights reserved.
 *
 *  Oracle NoSQL Database is free software: you can redistribute it and/or
 *  modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation, version 3.
 *
 *  Oracle NoSQL Database is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public
 *  License in the LICENSE file along with Oracle NoSQL Database.  If not,
 *  see <http://www.gnu.org/licenses/>.
 *
 *  An active Oracle commercial licensing agreement for this product
 *  supercedes this license.
 *
 *  For more information please contact:
 *
 *  Vice President Legal, Development
 *  Oracle America, Inc.
 *  5OP-10
 *  500 Oracle Parkway
 *  Redwood Shores, CA 94065
 *
 *  or
 *
 *  berkeleydb-info_us@oracle.com
 *
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  EOF
 *
 */

package oracle.kv.impl.mgmt;

import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.measurement.ProxiedServiceStatusChange;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.ServiceStatusTracker;

/**
 * This is the external interface to standardized monitoring and management,
 * used by the StorageNodeAgent
 */
public interface MgmtAgent {

    /**
     * For the SNA's status, we just add a listener to its status tracker.
     */
    void setSnaStatusTracker(ServiceStatusTracker snaStatusTracker);

    /**
     * Notify the agent of a new RepNode to track.
     */
    void addRepNode(RepNodeParams rnp, ServiceManager mgr)
        throws Exception;

    /**
     * Stop tracking the indicated RepNode.
     */
    void removeRepNode(RepNodeId rnid);

    /**
     * Notify the agent of a local Admin instance.
     */
    void addAdmin(AdminParams ap, ServiceManager mgr)
        throws Exception;

    /**
     * Stop tracking the Admin.
     */
    void removeAdmin();

    /**
     * Shut down the agent.  This should eliminate all threads under the agent's
     * control, so that the SNA process may shut down cleanly.
     */
    void shutdown();

    /**
     * Handle a "proxied" status change generated by the process manager.  This
     * happens when, for example, a RepNode crashes and can't report its own
     * status; then the SNA's process manager reports a status of
     * ERROR_NO_RESTART.
     */
    void proxiedStatusChange(ProxiedServiceStatusChange sc);

    /**
     * Check whether the  MgmtAgent is configured with the given parameters.
     */
    boolean checkParametersEqual(int pollp, String traph, int trapp);
}
