/*-
 *
 *  This file is part of Oracle NoSQL Database
 *  Copyright (C) 2011, 2014 Oracle and/or its affiliates.  All rights reserved.
 *
 *  Oracle NoSQL Database is free software: you can redistribute it and/or
 *  modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation, version 3.
 *
 *  Oracle NoSQL Database is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public
 *  License in the LICENSE file along with Oracle NoSQL Database.  If not,
 *  see <http://www.gnu.org/licenses/>.
 *
 *  An active Oracle commercial licensing agreement for this product
 *  supercedes this license.
 *
 *  For more information please contact:
 *
 *  Vice President Legal, Development
 *  Oracle America, Inc.
 *  5OP-10
 *  500 Oracle Parkway
 *  Redwood Shores, CA 94065
 *
 *  or
 *
 *  berkeleydb-info_us@oracle.com
 *
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  EOF
 *
 */

package oracle.kv.impl.fault;

import oracle.kv.KVSecurityException;

/**
 * When a authentication/authorization check is made within a KVStore component,
 * either within a SecureProxy instance, or in specialized security tests,
 * a KVSecurityException may result. When these happen, we need to report this
 * exception at the RMI entrypoint. However, internal operations that make RMI
 * method calls may also, in rare circumstances, result in KVSecurityExceptions.
 * These should normally NOT be reported to the accessing client as a
 * KVSecurityException, since the problem is not one that they caused.
 * <p>
 * In order to be able to distinguish the exceptions that belong to the client 
 * from the ones that belong to the server component, we capture the exceptions
 * generated by the client at the point they occur, and wrap them in a
 * ClientAccessException.  Within the ProcessFaultHandler for a service, if a
 * caught exception is a KVSecurityException, we recognize that it is an
 * exception caused by the service itself, and the Exception is generally
 * in some other exception type.  Conversely, if the fault handler handles a
 * ClientAccessException, it knows that this should be communicated to the
 * client as KVSecurityException, and throws the ClientAccessException cause
 * instead.
 */
public class ClientAccessException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    public ClientAccessException(KVSecurityException wrappedException) {
        super(wrappedException);
    }

    @Override
    public synchronized KVSecurityException getCause() {
        return (KVSecurityException) super.getCause();
    }
}
