/*-
 *
 *  This file is part of Oracle NoSQL Database
 *  Copyright (C) 2011, 2014 Oracle and/or its affiliates.  All rights reserved.
 *
 *  Oracle NoSQL Database is free software: you can redistribute it and/or
 *  modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation, version 3.
 *
 *  Oracle NoSQL Database is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public
 *  License in the LICENSE file along with Oracle NoSQL Database.  If not,
 *  see <http://www.gnu.org/licenses/>.
 *
 *  An active Oracle commercial licensing agreement for this product
 *  supercedes this license.
 *
 *  For more information please contact:
 *
 *  Vice President Legal, Development
 *  Oracle America, Inc.
 *  5OP-10
 *  500 Oracle Parkway
 *  Redwood Shores, CA 94065
 *
 *  or
 *
 *  berkeleydb-info_us@oracle.com
 *
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  EOF
 *
 */

package oracle.kv.impl.api.avro;

import org.apache.avro.Schema;

/**
 * A simple immutable property container for a Schema and its ID.  Also refers
 * to the previous version of the schema.
 *
 * @see SchemaCache
 */
@SuppressWarnings("javadoc")
class SchemaInfo {
    private final Schema schema;
    private final int id;
    private final SchemaInfo prevVersion;
    /* Mutable property for schema pointer in C API.  May be zero. */
    private volatile long cSchema;

    SchemaInfo(Schema schema, int id, SchemaInfo prevVersion) {
        this.schema = schema;
        this.id = id;
        this.prevVersion = prevVersion;
    }

    Schema getSchema() {
        return schema;
    }

    int getId() {
        return id;
    }

    SchemaInfo getPreviousVersion() {
        return prevVersion;
    }

    long getCSchema() {
        return cSchema;
    }

    void setCSchema(long cSchema) {
        this.cSchema = cSchema;
    }
}
