/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.kv.util.shell.Shell;

public class ShellInputReader {
    private static final String JL2_READER_CLS = "jline.console.ConsoleReader";
    private static final String JL2_TERMINAL_CLS = "jline.Terminal";
    private static final String JL2_FILE_HISTORY_CLS = "jline.console.history.FileHistory";
    private static final String JL2_HISTORY_CLS = "jline.console.history.History";
    private static final String METHOD_SET_HISTORY = "setHistory";
    private static final int MID_JL2_CR_READLINE = 0;
    private static final int MID_JL2_CR_GETTERM = 1;
    private static final String[] METHODS_JL2_READER = new String[]{"readLine", "getTerminal"};
    private static final int MID_JL2_TERM_GETHEIGHT = 0;
    private static final String[] METHODS_JL2_TERM = new String[]{"getHeight"};
    private static final int MID_JL2_FILE_HISTORY_SETMAXSIZE = 0;
    private static final int MID_JL2_FILE_HISTORY_FLUSH = 1;
    private static final String[] METHODS_JL2_FILE_HISTORY = new String[]{"setMaxSize", "flush"};
    private static final MethodDef[] JL2ReaderMethodsDef = new MethodDef[]{new MethodDef(METHODS_JL2_READER[0], new Class[]{String.class, Character.class}), new MethodDef(METHODS_JL2_READER[1], null)};
    private static final MethodDef[] JL2TermMethodsDef = new MethodDef[]{new MethodDef(METHODS_JL2_TERM[0], null)};
    private static final MethodDef[] JL2FileHistoryMethodsDef = new MethodDef[]{new MethodDef(METHODS_JL2_FILE_HISTORY[0], new Class[]{Integer.TYPE}), new MethodDef(METHODS_JL2_FILE_HISTORY[1], null)};
    private static final int TERMINAL_HEIGHT_DEFAULT = 25;
    private static final String PROP_JLINE_DISABLE = "oracle.kv.shell.jline.disable";
    private static final String PROP_HISTORY_FILE = "oracle.kv.shell.history.file";
    private static final String PROP_HISTORY_SIZE = "oracle.kv.shell.history.size";
    private Object jReaderObj = null;
    private Object jFileHistoryObj = null;
    private BufferedReader inputReader = null;
    private PrintStream output = null;
    private Map<String, Method> jReaderMethods = null;
    private Map<String, Method> jTermMethods = null;
    private Map<String, Method> jFileHistoryMethods = null;
    private String prompt = "";

    public ShellInputReader(InputStream input, PrintStream output) {
        this(input, output, null);
    }

    public ShellInputReader(Shell shell) {
        this(shell.input, shell.output, ShellInputReader.getHistoryFile(shell));
    }

    public ShellInputReader(InputStream input, PrintStream output, File historyFile) {
        this.initInputReader(input, output, historyFile);
        this.output = output;
    }

    private void initInputReader(InputStream input, PrintStream output1, File historyFile) {
        if (this.isJlineCompatiblePlatform()) {
            try {
                Method mtd;
                Class<?> jReader = Class.forName(JL2_READER_CLS);
                Class<?> jTerminal = Class.forName(JL2_TERMINAL_CLS);
                Class<?> jFileHistory = Class.forName(JL2_FILE_HISTORY_CLS);
                this.jReaderMethods = new HashMap<String, Method>();
                for (MethodDef mdef : JL2ReaderMethodsDef) {
                    mtd = jReader.getMethod(mdef.getName(), mdef.getArgTypes());
                    this.jReaderMethods.put(mdef.getName(), mtd);
                }
                this.jTermMethods = new HashMap<String, Method>();
                for (MethodDef mdef : JL2TermMethodsDef) {
                    mtd = jTerminal.getMethod(mdef.getName(), mdef.getArgTypes());
                    this.jTermMethods.put(mdef.getName(), mtd);
                }
                this.jFileHistoryMethods = new HashMap<String, Method>();
                for (MethodDef mdef : JL2FileHistoryMethodsDef) {
                    mtd = jFileHistory.getMethod(mdef.getName(), mdef.getArgTypes());
                    this.jFileHistoryMethods.put(mdef.getName(), mtd);
                }
                Constructor<?> csr = jReader.getConstructor(InputStream.class, OutputStream.class);
                this.jReaderObj = csr.newInstance(input, output1);
                if (historyFile != null) {
                    csr = jFileHistory.getConstructor(File.class);
                    this.jFileHistoryObj = csr.newInstance(historyFile);
                    this.invokeMethod(this.jReaderObj, jReader.getMethod(METHOD_SET_HISTORY, Class.forName(JL2_HISTORY_CLS)), new Object[]{this.jFileHistoryObj});
                    this.setHistoryFileSize();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (this.jReaderObj == null) {
            this.inputReader = new BufferedReader(new InputStreamReader(input));
        }
    }

    private static File getHistoryFile(Shell shell) {
        String path = System.getProperty(PROP_HISTORY_FILE);
        File file = null;
        file = path != null ? new File(path) : new File(System.getProperty("user.home"), ".jline-" + shell.getClass().getName() + ".history");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                shell.verboseOutput("Failed to create the command line history file: " + file.getAbsolutePath() + ", command history will be stored in memory.");
                return null;
            }
        } else if (!file.canRead() || !file.canWrite()) {
            shell.verboseOutput("Cannot access the command line history file: " + file.getAbsolutePath() + ", command history will be stored in memory.");
            return null;
        }
        return file;
    }

    private void setHistoryFileSize() throws IOException {
        int maxSize;
        String historySize = System.getProperty(PROP_HISTORY_SIZE);
        if (historySize == null || this.jFileHistoryObj == null) {
            return;
        }
        try {
            maxSize = Integer.valueOf(historySize);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        this.invokeJFileHistoryMethod(this.jFileHistoryObj, METHODS_JL2_FILE_HISTORY[0], new Object[]{maxSize});
    }

    public void shutdown() {
        if (this.jFileHistoryObj != null) {
            try {
                this.invokeJFileHistoryMethod(this.jFileHistoryObj, METHODS_JL2_FILE_HISTORY[1], null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isJlineCompatiblePlatform() {
        if (Boolean.getBoolean(PROP_JLINE_DISABLE)) {
            return false;
        }
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("windows") == -1;
    }

    public void setDefaultPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getDefaultPrompt() {
        return this.prompt;
    }

    public String readLine() throws IOException {
        return this.readLine(null);
    }

    public String readLine(String promptString) throws IOException {
        String prompt1;
        String string = prompt1 = promptString != null ? promptString : this.prompt;
        if (this.jReaderObj != null) {
            String name = METHODS_JL2_READER[0];
            return (String)this.invokeJReaderMethod(this.jReaderObj, name, new Object[]{prompt1, null});
        }
        this.output.print(prompt1);
        return this.inputReader.readLine();
    }

    public char[] readPassword(String promptString) throws IOException {
        String pwdPrompt;
        String input = null;
        String string = pwdPrompt = promptString != null ? promptString : this.prompt;
        if (this.jReaderObj != null) {
            String name = METHODS_JL2_READER[0];
            input = (String)this.invokeJReaderMethod(this.jReaderObj, name, new Object[]{pwdPrompt, new Character('\u0000')});
            return input == null ? null : input.toCharArray();
        }
        Console console = System.console();
        if (console != null) {
            return console.readPassword(pwdPrompt, new Object[0]);
        }
        this.output.print(pwdPrompt);
        input = this.inputReader.readLine();
        return input == null ? null : input.toCharArray();
    }

    public int getTerminalHeight() {
        if (this.jReaderObj != null) {
            try {
                String name = METHODS_JL2_READER[1];
                Object jTermObj = this.invokeJReaderMethod(this.jReaderObj, name, null);
                name = METHODS_JL2_TERM[0];
                return (Integer)this.invokeJTermMethod(jTermObj, name, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getTermHeightImpl();
    }

    private Object invokeJReaderMethod(Object jReaderObj1, String name, Object[] args) throws IOException {
        Method method = null;
        if (!this.jReaderMethods.containsKey(name)) {
            throw new IOException("Method " + name + " of Jline.ConsoleReader is not initialized.");
        }
        method = this.jReaderMethods.get(name);
        return this.invokeMethod(jReaderObj1, method, args);
    }

    private Object invokeJTermMethod(Object jTermObj, String name, Object[] args) throws IOException {
        Method method = null;
        if (!this.jTermMethods.containsKey(name)) {
            throw new IOException("Method " + name + " of " + JL2_TERMINAL_CLS + " is not initialized.");
        }
        method = this.jTermMethods.get(name);
        return this.invokeMethod(jTermObj, method, args);
    }

    private Object invokeJFileHistoryMethod(Object obj, String name, Object[] args) throws IOException {
        Method method = null;
        if (!this.jFileHistoryMethods.containsKey(name)) {
            throw new IOException("Method " + name + " of " + JL2_FILE_HISTORY_CLS + " is not initialized.");
        }
        method = this.jFileHistoryMethods.get(name);
        return this.invokeMethod(obj, method, args);
    }

    private Object invokeMethod(Object obj, Method method, Object[] args) throws IOException {
        String name = method.getName();
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Invoke method " + name + " of Jline.ConsoleReader failed", iae);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Invoke method " + name + " of Jline.ConsoleReader failed", iae);
        }
        catch (InvocationTargetException ite) {
            throw new IOException("Invoke method " + name + " of Jline.ConsoleReader failed", ite);
        }
    }

    private int getTermHeightImpl() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") != -1) {
            return 25;
        }
        int height = this.getUnixTermHeight();
        if (height == -1) {
            height = 25;
        }
        return height;
    }

    private int getUnixTermHeight() {
        String ttyProps = null;
        String name = "rows";
        try {
            ttyProps = this.getTermSttyProps();
            if (ttyProps != null && ttyProps.length() > 0) {
                return this.getTermSttyPropValue(ttyProps, "rows");
            }
        }
        catch (IOException ignored) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return -1;
    }

    private String getTermSttyProps() throws IOException, InterruptedException {
        String[] cmd = new String[]{"/bin/sh", "-c", "stty -a </dev/tty"};
        Process proc = Runtime.getRuntime().exec(cmd);
        String s = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            sb.append(s);
        }
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        while ((s = stdError.readLine()) != null) {
            sb.append(s);
        }
        proc.waitFor();
        return sb.toString();
    }

    private int getTermSttyPropValue(String props, String name) {
        StringTokenizer tokenizer = new StringTokenizer(props, ";\n");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken().trim();
            if (str.startsWith(name)) {
                return Integer.parseInt(str.substring(name.length() + 1, str.length()));
            }
            if (!str.endsWith(name)) continue;
            return Integer.parseInt(str.substring(0, str.length() - name.length() - 1));
        }
        return 0;
    }

    private static class MethodDef {
        private final String name;
        private final Class<?>[] argsTypes;

        MethodDef(String name, Class<?>[] types) {
            this.name = name;
            this.argsTypes = types;
        }

        public String getName() {
            return this.name;
        }

        public Class<?>[] getArgTypes() {
            return this.argsTypes;
        }
    }
}

