/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.kv.KVSecurityException;
import oracle.kv.util.shell.ShellArgumentException;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellHelpException;
import oracle.kv.util.shell.ShellInputReader;
import oracle.kv.util.shell.ShellUsageException;

public abstract class Shell {
    protected final InputStream input;
    protected final PrintStream output;
    private ShellInputReader inputReader = null;
    protected final CommandHistory history;
    private int exitCode;
    protected boolean showHidden = false;
    private VariablesMap shellVariables = null;
    protected Stack<ShellCommand> stCurrentCommands = null;
    protected boolean isSecured = false;
    public static final String tab = "\t";
    public static final String eol = System.getProperty("line.separator");
    public static final String eolt = eol + "\t";
    public static final int EXIT_OK = 0;
    public static final int EXIT_USAGE = 64;
    public static final int EXIT_INPUTERR = 65;
    public static final int EXIT_UNKNOWN = 1;
    public static final int EXIT_NOPERM = 77;
    private boolean verbose = false;
    private boolean global_verbose = false;
    private boolean terminate = false;

    public abstract List<? extends ShellCommand> getCommands();

    public abstract String getPrompt();

    public abstract String getUsageHeader();

    public abstract void init();

    public abstract void shutdown();

    public Shell(InputStream input, PrintStream output) {
        this.input = input;
        this.output = output;
        this.history = new CommandHistory();
        this.stCurrentCommands = new Stack();
        this.shellVariables = new VariablesMap();
    }

    public String getUsage() {
        String usage = this.getUsageHeader();
        for (ShellCommand shellCommand : this.getCommands()) {
            String help;
            if (!this.showHidden && shellCommand.isHidden() || (help = shellCommand.getCommandName()) == null) continue;
            usage = usage + tab + help + eol;
        }
        return usage;
    }

    public boolean showHidden() {
        return this.showHidden;
    }

    protected boolean toggleHidden() {
        this.showHidden = !this.showHidden;
        return this.showHidden;
    }

    public void prompt() {
        String prompt = this.getPrompt();
        if (prompt != null) {
            this.output.print(prompt);
        }
    }

    public void pushCurrentCommand(ShellCommand command) {
        this.stCurrentCommands.push(command);
    }

    public ShellCommand getCurrentCommand() {
        if (this.stCurrentCommands.size() > 0) {
            return this.stCurrentCommands.peek();
        }
        return null;
    }

    public void popCurrentCommand() {
        this.stCurrentCommands.pop();
    }

    public String getCurrentCommandPropmt() {
        ShellCommand command = this.getCurrentCommand();
        if (command == null) {
            return null;
        }
        Iterator it = this.stCurrentCommands.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            ShellCommand cmd = (ShellCommand)it.next();
            if (cmd.getPrompt() == null) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(cmd.getPrompt());
        }
        if (sb.length() > 0) {
            sb.append("-> ");
        }
        return sb.toString();
    }

    public void addVariable(String name, Object value) {
        this.shellVariables.add(name, value);
    }

    public Object getVariable(String name) {
        return this.shellVariables.get(name);
    }

    public Set<Map.Entry<String, Object>> getAllVariables() {
        return this.shellVariables.getAll();
    }

    public void removeVariable(String name) {
        this.shellVariables.remove(name);
    }

    public void removeAllVariables() {
        this.shellVariables.reset();
    }

    public boolean doRetry() {
        return false;
    }

    public boolean handleShellException(String line, ShellException se) {
        if (this.doRetry()) {
            return true;
        }
        if (se instanceof ShellHelpException) {
            this.history.add(line, null);
            this.output.println(((ShellHelpException)se).getVerboseHelpMessage());
            this.exitCode = 64;
            return false;
        }
        if (se instanceof ShellUsageException) {
            this.history.add(line, null);
            ShellUsageException sue = (ShellUsageException)se;
            this.output.println(sue.getMessage() + eol + sue.getVerboseHelpMessage());
            this.exitCode = 64;
            return false;
        }
        if (se instanceof ShellArgumentException) {
            this.history.add(line, null);
            this.output.println(se.getMessage());
            this.exitCode = 65;
            return false;
        }
        this.history.add(line, se);
        this.output.println("Error handling command " + line + ": " + se.getMessage());
        return false;
    }

    public void handleUnknownException(String line, Exception e) {
        this.history.add(line, e);
        this.exitCode = 1;
        this.output.println("Unknown Exception: " + e.getClass());
    }

    public boolean handleKVSecurityException(String line, KVSecurityException kvse) {
        this.history.add(line, kvse);
        this.output.println("Error handling command " + line + ": " + kvse.getMessage());
        this.exitCode = 77;
        return false;
    }

    public void verboseOutput(String msg) {
        if (this.verbose || this.global_verbose) {
            this.output.println(msg);
        }
    }

    public void setTerminate() {
        this.terminate = true;
    }

    public boolean getTerminate() {
        return this.terminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() {
        try {
            this.inputReader = new ShellInputReader(this);
            this.inputReader.setDefaultPrompt(this.getPrompt());
            String line = null;
            while (!this.terminate) {
                block6: {
                    try {
                        line = this.inputReader.readLine(this.getCurrentCommandPropmt());
                        if (line != null) break block6;
                        break;
                    }
                    catch (IOException ioe) {
                        this.output.println("Exception reading input: " + ioe);
                        continue;
                    }
                }
                this.execute(line);
            }
        }
        finally {
            this.inputReader.shutdown();
            this.shutdown();
        }
    }

    public void println(String msg) {
        this.output.println(msg);
    }

    public void execute(String line) {
        line = line.trim();
        try {
            if (line.length() == 0) {
                return;
            }
            try {
                this.runLine(line);
            }
            catch (KVSecurityException kvse) {
                if (this.handleKVSecurityException(line, kvse)) {
                    this.runLine(line);
                }
            }
        }
        catch (ShellException se) {
            if (this.handleShellException(line, se)) {
                this.execute(line);
            }
        }
        catch (Exception e) {
            this.handleUnknownException(line, e);
        }
    }

    public ShellCommand findCommand(String commandName) {
        for (ShellCommand shellCommand : this.getCommands()) {
            if (!shellCommand.matches(commandName)) continue;
            return shellCommand;
        }
        return null;
    }

    public static String[] extractArg(String[] args, String arg) {
        String[] retArgs = new String[args.length - 1];
        int i = 0;
        for (String s : args) {
            if (arg.equals(s)) continue;
            retArgs[i++] = s;
        }
        return retArgs;
    }

    private String[] checkVerbose(String[] args) {
        String[] retArgs = args;
        if (Shell.checkArg(args, "-verbose")) {
            this.verbose = true;
            retArgs = Shell.extractArg(args, "-verbose");
        }
        return retArgs;
    }

    public String[] parseLine(String line) {
        ArrayList<String> words = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(line));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        st.commentChar(35);
        try {
            while (true) {
                int tokenType;
                if ((tokenType = st.nextToken()) == -3) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == 39 || tokenType == 34) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == -2) {
                    this.output.println("Unexpected numeric token!");
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        return words.toArray(new String[words.size()]);
    }

    public void runLine(String line) throws ShellException {
        this.exitCode = 0;
        if (line.length() > 0 && !line.startsWith("#")) {
            String[] splitArgs = this.parseLine(line);
            String commandName = splitArgs[0];
            String result = this.run(commandName, splitArgs);
            if (result != null) {
                this.output.println(result);
            }
            this.history.add(line, null);
        }
    }

    public String run(String commandName, String[] args) throws ShellException {
        ShellCommand command = null;
        String[] cmdArgs = null;
        command = this.getCurrentCommand();
        if (command != null) {
            cmdArgs = new String[args.length + 1];
            cmdArgs[0] = command.getCommandName();
            System.arraycopy(args, 0, cmdArgs, 1, args.length);
        } else {
            command = this.findCommand(commandName);
            cmdArgs = args;
        }
        if (command != null) {
            this.verbose = false;
            cmdArgs = this.checkVerbose(cmdArgs);
            return command.execute(cmdArgs, this);
        }
        throw new ShellArgumentException("Could not find command: " + commandName + eol + this.getUsage());
    }

    public boolean getVerbose() {
        return this.verbose || this.global_verbose;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public ShellInputReader getInput() {
        return this.inputReader;
    }

    public boolean toggleVerbose() {
        this.global_verbose = !this.global_verbose;
        return this.global_verbose;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    public static String nextArg(String[] args, int index, ShellCommand cmd) throws ShellException {
        if (++index < args.length) {
            return args[index];
        }
        throw new ShellUsageException("Flag " + args[index - 1] + " requires an argument", cmd);
    }

    public void invalidArgument(String arg, ShellCommand command) throws ShellException {
        String msg = "Invalid argument: " + arg + eolt + command.getBriefHelp();
        throw new ShellArgumentException(msg);
    }

    public void unknownArgument(String arg, ShellCommand command) throws ShellException {
        String msg = "Unknown argument: " + arg;
        throw new ShellUsageException(msg, command);
    }

    public void badArgCount(ShellCommand command) throws ShellException {
        String msg = "Incorrect number of arguments for command: " + command.getCommandName();
        throw new ShellUsageException(msg, command);
    }

    public void badArgUsage(String arg, String info, ShellCommand command) throws ShellException {
        String msg = "Invalid usage of the " + arg + " argument to the command: " + command.getCommandName();
        if (info != null && !info.isEmpty()) {
            msg = msg + " - " + info;
        }
        throw new ShellUsageException(msg, command);
    }

    public void requiredArg(String arg, ShellCommand command) throws ShellException {
        String msg = "Missing required argument" + (arg != null ? " (" + arg + ")" : "") + " for command: " + command.getCommandName();
        throw new ShellUsageException(msg, command);
    }

    public static String makeWhiteSpace(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    public static void checkHelp(String[] args, ShellCommand command) throws ShellException {
        for (String s : args) {
            String sl = s.toLowerCase();
            if (!sl.equals("-help") && !sl.equals("help") && !sl.equals("?") && !sl.equals("-?")) continue;
            throw new ShellHelpException(command);
        }
    }

    public static boolean checkArg(String[] args, String arg) {
        for (String s : args) {
            String sl = s.toLowerCase();
            if (!sl.equals(arg)) continue;
            return true;
        }
        return false;
    }

    public static String getArg(String[] args, String arg) {
        boolean returnNext = false;
        for (String s : args) {
            if (returnNext) {
                return s;
            }
            String sl = s.toLowerCase();
            if (!sl.equals(arg)) continue;
            returnNext = true;
        }
        return null;
    }

    public static boolean matches(String inputName, String commandName) {
        return Shell.matches(inputName, commandName, 0);
    }

    public static boolean matches(String inputName, String commandName, int prefixMatchLength) {
        if (inputName.length() < prefixMatchLength) {
            return false;
        }
        if (prefixMatchLength > 0) {
            String match = inputName.toLowerCase();
            return commandName.toLowerCase().startsWith(match);
        }
        return commandName.toLowerCase().equals(inputName.toLowerCase());
    }

    public static class VariablesMap
    implements Cloneable {
        private final HashMap<String, Object> variablesMap = new HashMap();

        public void add(String name, Object value) {
            this.variablesMap.put(name, value);
        }

        public Object get(String name) {
            return this.variablesMap.get(name);
        }

        public Set<Map.Entry<String, Object>> getAll() {
            return this.variablesMap.entrySet();
        }

        public void remove(String name) {
            if (this.variablesMap.containsKey(name)) {
                this.variablesMap.remove(name);
            }
        }

        public int size() {
            return this.variablesMap.size();
        }

        public void reset() {
            this.variablesMap.clear();
        }

        public VariablesMap clone() {
            VariablesMap map = new VariablesMap();
            for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
                map.add(entry.getKey(), entry.getValue());
            }
            return map;
        }

        public String toString() {
            String retString = "";
            for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
                retString = retString + Shell.tab + entry.getKey() + ": " + entry.getValue() + eol;
            }
            return retString;
        }
    }

    public static class CommandComparator
    implements Comparator<ShellCommand> {
        @Override
        public int compare(ShellCommand o1, ShellCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }

    class CommandHistoryElement {
        String command;
        Exception exception;

        public CommandHistoryElement(String command, Exception exception) {
            this.command = command;
            this.exception = exception;
        }

        public String getCommand() {
            return this.command;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public class CommandHistory {
        private final List<CommandHistoryElement> history1 = new ArrayList<CommandHistoryElement>(100);

        public void add(String command, Exception e) {
            this.history1.add(new CommandHistoryElement(command, e));
        }

        public CommandHistoryElement get(int which) {
            if (this.history1.size() > which) {
                return this.history1.get(which);
            }
            Shell.this.output.println("No such command in history at offset " + which);
            return null;
        }

        public int getSize() {
            return this.history1.size();
        }

        public String dump(int from, int to) {
            from = Math.min(from, this.history1.size());
            to = Math.min(to, this.history1.size() - 1);
            String hist = "";
            for (int i = from; i <= to; ++i) {
                hist = hist + this.dumpCommand(i, false);
            }
            return hist;
        }

        public boolean commandFaulted(int command) {
            CommandHistoryElement cmd = this.history1.get(command);
            return cmd.getException() != null;
        }

        public String dumpCommand(int command, boolean withFault) {
            CommandHistoryElement cmd = this.history1.get(command);
            String res = "";
            res = cmd.getCommand();
            if (withFault && cmd.getException() != null) {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                cmd.getException().printStackTrace(new PrintWriter(b, true));
                res = res + eolt + b.toString();
            }
            return command + " " + res + eol;
        }

        public String dumpFaultingCommands(int from, int to) {
            from = Math.min(from, this.history1.size());
            to = Math.min(to, this.history1.size() - 1);
            String hist = "";
            for (int i = from; i <= to; ++i) {
                CommandHistoryElement cmd = this.history1.get(i);
                Exception e = cmd.getException();
                if (e == null) continue;
                String res = "";
                res = cmd.getCommand();
                hist = hist + i + " " + res + ": " + e.getClass() + eol;
            }
            return hist;
        }

        public Exception getLastException() {
            for (int i = this.history1.size() - 1; i >= 0; --i) {
                CommandHistoryElement cmd = this.history1.get(i);
                if (cmd.getException() == null) continue;
                return cmd.getException();
            }
            return null;
        }

        public String dumpLastFault() {
            for (int i = this.history1.size() - 1; i >= 0; --i) {
                CommandHistoryElement cmd = this.history1.get(i);
                if (cmd.getException() == null) continue;
                return this.dumpCommand(i, true);
            }
            return "";
        }
    }

    public static class ExitCommand
    extends ShellCommand {
        public ExitCommand() {
            super("exit", 2);
        }

        @Override
        protected boolean matches(String commandName) {
            return super.matches(commandName) || Shell.matches(commandName, "quit", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            shell.setTerminate();
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "exit | quit";
        }

        @Override
        protected String getCommandDescription() {
            return "Exit the interactive command shell.";
        }
    }

    public static class HelpCommand
    extends ShellCommand {
        public HelpCommand() {
            super("help", 2);
        }

        @Override
        protected boolean matches(String commandName) {
            return "?".equals(commandName) || super.matches(commandName);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            if (args.length == 1) {
                return shell.getUsage();
            }
            String commandName = args[1];
            ShellCommand command = shell.findCommand(commandName);
            if (command != null) {
                return command.getHelp(Arrays.copyOfRange(args, 1, args.length), shell);
            }
            return "Could not find command: " + commandName + eol + shell.getUsage();
        }

        @Override
        protected String getCommandSyntax() {
            return "help [command [sub-command]]";
        }

        @Override
        protected String getCommandDescription() {
            return "Print help messages.  With no arguments the top-level shell commands" + eolt + "are listed.  With additional commands " + "and sub-commands, additional" + eolt + "detail is provided.";
        }
    }

    public static class LoadCommand
    extends ShellCommand {
        public LoadCommand() {
            super("load", 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String path = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    path = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (path == null) {
                shell.requiredArg("-file", this);
            }
            FileReader fr = null;
            BufferedReader br = null;
            String retString = "";
            try {
                String line;
                fr = new FileReader(path);
                br = new BufferedReader(fr);
                while ((line = br.readLine()) != null && !shell.getTerminate()) {
                    try {
                        shell.runLine(line);
                    }
                    catch (ShellException se) {
                        if (shell.handleShellException(line, se)) continue;
                        retString = "Script error in line \"" + line + "\", ending execution";
                        break;
                    }
                    catch (Exception e) {
                        shell.handleUnknownException(line, e);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                String string = "Failed to load file: " + path;
                return string;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return retString;
        }

        @Override
        protected String getCommandSyntax() {
            return "load -file <path to file>";
        }

        @Override
        protected String getCommandDescription() {
            return "Load the named file and interpret its contents as a script of commands" + eolt + "to be executed.  If any command in " + "the script fails execution will end.";
        }
    }
}

