/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.internal;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.IndexNotAvailableException;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.ParametersHolder;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.TopologyStore;
import oracle.kv.impl.metadata.MetadataHolder;
import oracle.kv.impl.util.FormatUtils;

public class AdminDump {
    private static int DEFAULT_TOPO_VERSIONS = 0;
    private final PrintStream out;
    private File envHome = null;
    private int showTopos = DEFAULT_TOPO_VERSIONS;
    private boolean showParams = false;
    private boolean showCounts = false;
    private boolean showEvents = false;
    private boolean showModel = false;

    private AdminDump(PrintStream out) {
        this.out = out;
    }

    public static void main(String[] args) throws Exception {
        AdminDump dumper = new AdminDump(System.out);
        dumper.parseArgs(args);
        try {
            dumper.run();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void run() {
        this.out.println("For internal use only.");
        this.out.println("Information from admin database in " + this.envHome);
        DateFormat fm = FormatUtils.getDateTimeAndTimeZoneFormatter();
        this.out.println("Current time: " + fm.format(new Date(System.currentTimeMillis())));
        this.displayAdminInfo();
    }

    private void displayAdminInfo() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setAllowCreate(false);
        Environment env = new Environment(this.envHome, envConfig);
        AdminDBCatalog catalog = new AdminDBCatalog(env, this.out);
        catalog.openReadOnlyStore();
        EntityStore estore = catalog.getEntityStore();
        if (this.showModel) {
            this.listModel(estore, env);
        }
        if (this.showCounts) {
            catalog.countRecords();
        }
        if (this.showEvents) {
            catalog.displayEvents();
        }
        if (this.showParams) {
            Parameters params = Parameters.fetch(estore, null);
            this.out.println(params.printRepNodeParams());
        }
        if (this.showTopos > 0) {
            List<RealizedTopology> topos = TopologyStore.readLastTopos(estore, this.showTopos);
            for (RealizedTopology t : topos) {
                this.out.println("--------- deployed topology --------");
                this.out.println(t.display(false));
            }
        }
    }

    private void listModel(EntityStore estore, Environment env) {
        this.out.println("-----------------Class types in Admin DB");
        for (String className : estore.getModel().getKnownClasses()) {
            this.out.println(className);
        }
        this.out.println("-----------------Stores in Admin DB");
        for (String storeName : EntityStore.getStoreNames(env)) {
            this.out.println(storeName);
        }
    }

    public void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-numTopos")) {
                this.showTopos = Integer.parseInt(argv[argc++]);
                continue;
            }
            if (thisArg.equals("-showCounts")) {
                this.showCounts = true;
                continue;
            }
            if (thisArg.equals("-showParams")) {
                this.showParams = true;
                continue;
            }
            if (thisArg.equals("-showEvents")) {
                this.showEvents = true;
                continue;
            }
            if (thisArg.equals("-showModel")) {
                this.showModel = true;
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    private void printUsage(String msg) {
        if (msg != null) {
            this.out.println(msg);
        }
        this.out.println("Usage: " + AdminDump.class.getName());
        this.out.println(" -h <dir>        # admin service environment directory");
        this.out.println(" -numTopos <num> # number of historical topo versions");
        this.out.println("                 # to display");
        this.out.println(" -showParams     # dump RN params");
        this.out.println(" -showCounts     # show record counts by record type");
        this.out.println(" -showEvents     # show all events");
        this.out.println(" -showModel      # show all classes in the db");
        System.exit(-1);
    }

    private static class AdminDBCatalog {
        private final Environment env;
        private EntityStore estore;
        private PrintStream out;
        EntityType[] recordTypes = new EntityType[]{new EntityType("events", CriticalEvent.EventKey.class, CriticalEvent.class), new EntityType("metadata", String.class, MetadataHolder.class), new EntityType("plans", Integer.class, AbstractPlan.class), new EntityType("params", String.class, ParametersHolder.class), new EntityType("memo", String.class, Admin.Memo.class), new EntityType("topoHistory", Long.class, RealizedTopology.class), new EntityType("topoCandidates", String.class, TopologyCandidate.class)};

        AdminDBCatalog(Environment env, PrintStream out) {
            this.env = env;
            this.out = out;
            this.openReadOnlyStore();
        }

        EntityStore getEntityStore() {
            return this.estore;
        }

        private void openReadOnlyStore() {
            StoreConfig stConfig = new StoreConfig();
            stConfig.setAllowCreate(false);
            stConfig.setReadOnly(true);
            stConfig.setTransactional(false);
            this.estore = new EntityStore(this.env, "AdminEntityStore", stConfig);
        }

        Map<String, PrimaryIndex<?, ?>> getPrimaryIndices() {
            TreeMap pIdxList = new TreeMap();
            for (EntityType t : this.recordTypes) {
                try {
                    pIdxList.put(t.name, this.estore.getPrimaryIndex(t.primaryKey, t.entity));
                }
                catch (IndexNotAvailableException ignore) {
                    // empty catch block
                }
            }
            return pIdxList;
        }

        private void countRecords() {
            long totalCount = 0L;
            long count = 0L;
            Map<String, PrimaryIndex<?, ?>> indexMap = this.getPrimaryIndices();
            this.out.println("---------------- Counting records");
            for (Map.Entry<String, PrimaryIndex<?, ?>> idx : indexMap.entrySet()) {
                String typeName = idx.getKey();
                PrimaryIndex<?, ?> pIdx = idx.getValue();
                count = pIdx.count();
                totalCount += count;
                this.out.println(typeName + " = " + count);
            }
            this.out.println("total records = " + totalCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayEvents() {
            PrimaryIndex<CriticalEvent.EventKey, CriticalEvent> pi = this.estore.getPrimaryIndex(CriticalEvent.EventKey.class, CriticalEvent.class);
            try (EntityCursor eventCursor = pi.entities();){
                int i = 0;
                for (CriticalEvent ev : eventCursor) {
                    this.out.println(i++ + " " + ev);
                }
            }
        }

        private class EntityType {
            final String name;
            final Class<?> primaryKey;
            final Class<?> entity;

            public EntityType(String name, Class<?> primaryKey, Class<?> entity) {
                this.name = name;
                this.primaryKey = primaryKey;
                this.entity = entity;
            }
        }
    }
}

