/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.kv.Direction;
import oracle.kv.KVStore;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.Value;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.avro.JsonAvroBinding;
import oracle.kv.avro.JsonRecord;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.shell.CommandUtils;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;

public class AggregateCommand
extends CommandWithSubs {
    static final String COMMAND_OVERVIEW = "The Aggregate command encapsulates commands that performs simple data" + eol + "aggregation operations on numeric fields of values " + "from a store or rows" + eol + "from a table.";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new AggregateKVSub(), new AggregateTableSub());

    public AggregateCommand() {
        super(subs, "aggregate", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return COMMAND_OVERVIEW;
    }

    static class AggregateTableSub
    extends AggregateSubCommand {
        static final String COMMAND_NAME = "table";
        static final String TABLE_FLAG = "-name";
        static final String TABLE_FLAG_DESC = "-name <name>";
        static final String INDEX_FLAG = "-index";
        static final String INDEX_FLAG_DESC = "-index <name>";
        static final String FIELD_FLAG = "-field";
        static final String FIELD_FLAG_DESC = "-field <name>";
        static final String VALUE_FLAG = "-value";
        static final String VALUE_FLAG_DESC = "-value <value>";
        static final String START_FLAG_DESC = "-start <value>";
        static final String END_FLAG_DESC = "-end <value>";
        static final String JSON_FLAG = "-json";
        static final String JSON_FLAG_DESC = "-json <string>";
        static final String COMMAND_SYNTAX = "aggregate table -name <name>" + eolt + "[-count] [-sum <field[,field]*>] [-avg <field[,field]*>]" + eolt + "[" + "-index <name>" + "] [" + "-field <name>" + " " + "-value <value>" + "]*" + eolt + "[" + "-field <name>" + " [" + "-start <value>" + "] [" + "-end <value>" + "]]" + eolt + "[" + "-json <string>" + "]";
        static final String COMMAND_DESCRIPTION = "Performs simple data aggregation operations on numeric fields of a table." + eolt + "-count" + " returns the count of matching records." + eolt + "-sum" + " returns the sum of the values of matching " + "fields." + eolt + "-avg" + " returns the average of the values of matching " + "fields." + eolt + "-field" + " and " + "-value" + " pairs are used to " + "used to specify fields of the" + eolt + "primary key or " + "index key used for the operation.  If no fields are" + eolt + "specified an iteration of the entire table or index is " + "performed." + eolt + "-field" + "," + "-start" + " and " + "-end" + " flags " + "can be used to define a value range for" + eolt + "the last field specified." + eolt + "-json" + " indicates that the key field values are in " + "JSON format.";

        public AggregateTableSub() {
            super(COMMAND_NAME, 3);
        }

        @Override
        void exec(String[] args, Shell shell, AggregateSubCommand.AggResult aggResult) throws ShellException {
            Shell.checkHelp(args, this);
            String tableName = null;
            HashMap<String, String> mapVals = new HashMap<String, String>();
            String frFieldName = null;
            String rgStart = null;
            String rgEnd = null;
            String indexName = null;
            String jsonString = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (FIELD_FLAG.equals(arg)) {
                    String fname = Shell.nextArg(args, i++, this);
                    if (++i < args.length) {
                        arg = args[i];
                        if (VALUE_FLAG.equals(arg)) {
                            String fVal = Shell.nextArg(args, i++, this);
                            mapVals.put(fname, fVal);
                            continue;
                        }
                        while (i < args.length) {
                            arg = args[i];
                            if ("-start".equals(arg)) {
                                rgStart = Shell.nextArg(args, i++, this);
                            } else {
                                if (!"-end".equals(arg)) break;
                                rgEnd = Shell.nextArg(args, i++, this);
                            }
                            ++i;
                        }
                        if (rgStart == null && rgEnd == null) {
                            shell.invalidArgument(arg + ", " + VALUE_FLAG + " or " + "-start" + " | " + "-end" + " is reqired", this);
                        }
                        frFieldName = fname;
                        --i;
                        continue;
                    }
                    shell.requiredArg("-value or -start | -end", this);
                    continue;
                }
                if (INDEX_FLAG.equals(arg)) {
                    indexName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (JSON_FLAG.equals(arg)) {
                    jsonString = Shell.nextArg(args, i++, this);
                    continue;
                }
                i = this.checkGenericArg(shell, arg, args, i);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            this.validateAggArgs(shell);
            TableAPI tableImpl = ((CommandShell)shell).getStore().getTableAPI();
            Table table = CommandUtils.findTable(tableImpl, tableName);
            List<String> fields = this.getAggFields();
            if (fields != null) {
                for (String field : fields) {
                    if (table.getField(field) != null) continue;
                    shell.invalidArgument("Field does not exist in table: " + field, this);
                }
            }
            RecordValue key = null;
            if (jsonString != null) {
                key = CommandUtils.createKeyFromJson(table, indexName, jsonString);
            } else {
                key = indexName == null ? table.createPrimaryKey() : CommandUtils.findIndex(table, indexName).createIndexKey();
                for (Map.Entry entry : mapVals.entrySet()) {
                    CommandUtils.putIndexKeyValues(key, table, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            MultiRowOptions mro = null;
            if (rgStart != null || rgEnd != null) {
                mro = CommandUtils.createMultiRowOptions(tableImpl, table, key, null, null, frFieldName, rgStart, rgEnd);
            }
            this.execAgg(tableImpl, key, mro, fields, aggResult);
        }

        private void execAgg(final TableAPI tableImpl, final RecordValue key, final MultiRowOptions mro, final List<String> fields, final AggregateSubCommand.AggResult aggResult) throws ShellException {
            new CommandUtils.RunTableAPIOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void doOperation() throws ShellException {
                    try (TableIterator<Comparable<FieldValue>> iter = null;){
                        iter = fields == null ? (key.isPrimaryKey() ? tableImpl.tableKeysIterator(key.asPrimaryKey(), mro, null) : tableImpl.tableKeysIterator(key.asIndexKey(), mro, null)) : (key.isPrimaryKey() ? tableImpl.tableIterator(key.asPrimaryKey(), mro, null) : tableImpl.tableIterator(key.asIndexKey(), mro, null));
                        while (iter.hasNext()) {
                            if (fields != null) {
                                Row row = (Row)iter.next();
                                for (String field : fields) {
                                    AggregateTableSub.this.tallyFieldValue(aggResult, row, field);
                                }
                            } else {
                                iter.next();
                            }
                            aggResult.tallyCount();
                        }
                    }
                }
            }.run();
        }

        private void tallyFieldValue(AggregateSubCommand.AggResult aggResult, Row row, String field) {
            FieldValue fv = row.get(field);
            if (fv.isNull()) {
                return;
            }
            if (fv.isInteger()) {
                aggResult.tallyInt(field, fv.asInteger().get());
            } else if (fv.isLong()) {
                aggResult.tallyLong(field, fv.asLong().get());
            } else if (fv.isFloat()) {
                aggResult.tallyFloat(field, Float.valueOf(fv.asFloat().get()));
            } else if (fv.isDouble()) {
                aggResult.tallyDouble(field, fv.asDouble().get());
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }
    }

    static class AggregateKVSub
    extends AggregateSubCommand {
        static final String COMMAND_NAME = "kv";
        static final String KEY_FLAG = "-key";
        static final String KEY_FLAG_DESC = "-key <key>";
        static final String START_FLAG_DESC = "-start <prefixString>";
        static final String END_FLAG_DESC = "-end <prefixString>";
        static final String SCHEMA_FLAG = "-schema";
        static final String SCHEMA_FLAG_DESC = "-schema <name>";
        static final String COMMAND_SYNTAX = "aggregate kv [-count] [-sum <field[,field]*>] [-avg <field[,field]*>]" + eolt + "[" + "-schema <name>" + "] [" + "-key <key>" + "] " + eolt + "[" + "-start <prefixString>" + "] [" + "-end <prefixString>" + "]";
        static final String COMMAND_DESCRIPTION = "Performs simple data aggregation operations on numeric fields." + eolt + "-count" + " returns the count of matching records" + eolt + "-sum" + " returns the sum of the values of matching " + "fields." + eolt + "     All records with the specified schema with the named field" + eolt + "     are matched.  Unmatched records are ignored." + eolt + "-avg" + " returns the average of the values of matching " + "fields." + eolt + "     All records with the specified schema with the named field" + eolt + "     are matched.  Unmatched records are ignored." + eolt + "-schema" + " specifies the avro schema name." + eolt + "-key" + " specifies the key (prefix) to use." + eolt + "-start" + " and " + "-end" + " flags can be used for " + "restricting the range used" + eolt + "for iteration.";
        private static final Schema.Type[] SCHEMA_NUMERIC_TYPES = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};

        public AggregateKVSub() {
            super(COMMAND_NAME, 2);
        }

        @Override
        void exec(String[] args, Shell shell, AggregateSubCommand.AggResult aggResult) throws ShellException {
            List<String> fields;
            Shell.checkHelp(args, this);
            Key key = null;
            String rangeStart = null;
            String rangeEnd = null;
            String schemaName = null;
            KVStore store = ((CommandShell)shell).getStore();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (KEY_FLAG.equals(arg)) {
                    String keyString = Shell.nextArg(args, i++, this);
                    try {
                        key = CommandUtils.createKeyFromURI(keyString);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(iae.getMessage(), this);
                    }
                    continue;
                }
                if ("-start".equals(arg)) {
                    rangeStart = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-end".equals(arg)) {
                    rangeEnd = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SCHEMA_FLAG.equals(arg)) {
                    schemaName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i = this.checkGenericArg(shell, arg, args, i);
            }
            this.validateAggArgs(shell);
            KeyRange kr = null;
            if (rangeStart != null || rangeEnd != null) {
                try {
                    kr = new KeyRange(rangeStart, true, rangeEnd, true);
                }
                catch (IllegalArgumentException iae) {
                    shell.invalidArgument(iae.getMessage(), this);
                }
            }
            if ((fields = this.getAggFields()) != null && schemaName == null) {
                shell.requiredArg(SCHEMA_FLAG, this);
            }
            JsonAvroBinding binding = null;
            if (schemaName != null) {
                binding = this.getAvroBinding(store, schemaName);
            }
            this.execAgg(store, key, kr, fields, binding, aggResult);
        }

        private JsonAvroBinding getAvroBinding(KVStore store, String schemaName) throws ShellException {
            AvroCatalog catalog = store.getAvroCatalog();
            catalog.refreshSchemaCache(null);
            Map<String, Schema> schemaMap = catalog.getCurrentSchemas();
            Schema schema = schemaMap.get(schemaName);
            if (schema == null) {
                throw new ShellException("Schema does not exist or is disabled: " + schemaName);
            }
            try {
                return catalog.getJsonBinding(schema);
            }
            catch (UndefinedSchemaException use) {
                throw new ShellException("Schema does not exist or is disabled: " + schemaName);
            }
        }

        private void execAgg(KVStore store, Key key, KeyRange kr, List<String> fields, JsonAvroBinding binding, AggregateSubCommand.AggResult aggResult) throws ShellException {
            Iterator<Object> it = null;
            try {
                if (binding == null) {
                    if (this.keyContainsMinorPath(key)) {
                        it = store.multiGetKeysIterator(Direction.FORWARD, 100, key, kr, null);
                    } else {
                        it = store.storeKeysIterator(Direction.UNORDERED, 100, key, kr, null, null, 0L, null, this.getIteratorConfig());
                        if (!it.hasNext() && key != null) {
                            this.closeIterator(it);
                            it = store.multiGetKeysIterator(Direction.FORWARD, 100, key, kr, null);
                        }
                    }
                } else if (this.keyContainsMinorPath(key)) {
                    it = store.multiGetIterator(Direction.FORWARD, 100, key, kr, null);
                } else {
                    it = store.storeIterator(Direction.UNORDERED, 100, key, kr, null, null, 0L, null, this.getIteratorConfig());
                    if (!it.hasNext() && key != null) {
                        this.closeIterator(it);
                        it = store.multiGetIterator(Direction.FORWARD, 100, key, kr, null);
                    }
                }
                while (it.hasNext()) {
                    if (binding != null) {
                        Value value = ((KeyValueVersion)it.next()).getValue();
                        JsonRecord jsonRec = this.getJsonRec(binding, value);
                        if (jsonRec == null) continue;
                        if (fields != null) {
                            for (String field : fields) {
                                this.tallyFieldValue(aggResult, jsonRec, field);
                            }
                        }
                    } else {
                        it.next();
                    }
                    aggResult.tallyCount();
                }
            }
            catch (Exception e) {
                throw new ShellException(e.getMessage(), e);
            }
            finally {
                if (it != null) {
                    this.closeIterator(it);
                }
            }
        }

        private boolean keyContainsMinorPath(Key key) {
            return key != null && key.getMinorPath() != null && key.getMinorPath().size() > 0;
        }

        private StoreIteratorConfig getIteratorConfig() {
            return new StoreIteratorConfig().setMaxConcurrentRequests(0);
        }

        private void closeIterator(Iterator<?> iterator) {
            if (iterator instanceof ParallelScanIterator) {
                ((ParallelScanIterator)iterator).close();
            }
        }

        private JsonRecord getJsonRec(JsonAvroBinding binding, Value value) {
            if (value == null || value.getFormat() != Value.Format.AVRO) {
                return null;
            }
            try {
                return binding.toObject(value);
            }
            catch (SchemaNotAllowedException ignored) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }

        private void tallyFieldValue(AggregateSubCommand.AggResult aggResult, JsonRecord jsonRec, String field) {
            Schema.Type type = this.getScalarType(jsonRec.getSchema(), field);
            if (type == null) {
                return;
            }
            JsonNode jsonNode = jsonRec.getJsonNode().get(field);
            if (jsonNode.isNull() || !jsonNode.isNumber()) {
                return;
            }
            switch (type) {
                case INT: {
                    aggResult.tallyInt(field, jsonNode.getIntValue());
                    break;
                }
                case LONG: {
                    aggResult.tallyLong(field, jsonNode.getLongValue());
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    aggResult.tallyDouble(field, jsonNode.getDoubleValue());
                    break;
                }
            }
        }

        private Schema.Type getScalarType(Schema schema, String fieldName) {
            Schema.Field field = schema.getField(fieldName);
            if (field == null) {
                return null;
            }
            Schema.Type fieldType = field.schema().getType();
            for (Schema.Type type : SCHEMA_NUMERIC_TYPES) {
                if (!fieldType.equals((Object)type)) continue;
                return fieldType;
            }
            return null;
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }
    }

    static abstract class AggregateSubCommand
    extends CommandWithSubs.SubCommand {
        static final String COUNT_FLAG = "-count";
        static final String COUNT_FLAG_DESC = "-count";
        static final String SUM_FLAG = "-sum";
        static final String SUM_FLAG_DESC = "-sum <field[,field]*>";
        static final String AVG_FLAG = "-avg";
        static final String AVG_FLAG_DESC = "-avg <field[,field]*>";
        static final String START_FLAG = "-start";
        static final String END_FLAG = "-end";
        static final String genericFlags = "[-count] [-sum <field[,field]*>] [-avg <field[,field]*>]";
        boolean doCounting;
        List<String> sumFields;
        List<String> avgFields;
        AggResult result;

        AggregateSubCommand(String name, int prefixLength) {
            super(name, prefixLength);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            this.doCounting = false;
            this.sumFields = new ArrayList<String>();
            this.avgFields = new ArrayList<String>();
            this.result = new AggResult();
            this.exec(args, shell, this.result);
            return this.genStatsSummary(this.result);
        }

        abstract void exec(String[] var1, Shell var2, AggResult var3) throws ShellException;

        int checkGenericArg(Shell shell, String arg, String[] args, int i) throws ShellException {
            int rval = i;
            if ("-count".equals(arg)) {
                this.doCounting = true;
            } else if (SUM_FLAG.equals(arg)) {
                String[] fields;
                String str = Shell.nextArg(args, rval++, this);
                for (String field : fields = str.split(",")) {
                    if (this.sumFields.contains(field)) continue;
                    this.sumFields.add(field);
                }
            } else if (AVG_FLAG.equals(arg)) {
                String[] fields;
                String str = Shell.nextArg(args, rval++, this);
                for (String field : fields = str.split(",")) {
                    if (this.avgFields.contains(field)) continue;
                    this.avgFields.add(field);
                }
            } else {
                shell.unknownArgument(arg, this);
            }
            return rval;
        }

        List<String> getAggFields() {
            if (this.sumFields.isEmpty() && this.avgFields.isEmpty()) {
                return null;
            }
            ArrayList<String> fields = new ArrayList<String>();
            if (!this.sumFields.isEmpty()) {
                for (String field : this.sumFields) {
                    if (fields.contains(field)) continue;
                    fields.add(field);
                }
            }
            if (!this.avgFields.isEmpty()) {
                for (String field : this.avgFields) {
                    if (fields.contains(field)) continue;
                    fields.add(field);
                }
            }
            return fields;
        }

        void validateAggArgs(Shell shell) throws ShellException {
            if (!this.doCounting && this.sumFields.isEmpty() && this.avgFields.isEmpty()) {
                shell.requiredArg("-count or -sum or -avg", this);
            }
        }

        String genStatsSummary(AggResult aggResult) {
            String fieldInfo;
            StringBuilder sb = new StringBuilder();
            long count = aggResult.getCount();
            if (this.doCounting) {
                sb.append("Row count: ");
                sb.append(count);
                if (this.sumFields.isEmpty() && this.avgFields.isEmpty()) {
                    return sb.toString();
                }
            }
            Formatter fmt = new Formatter(sb);
            if (!this.sumFields.isEmpty()) {
                sb.append(eol);
                sb.append("Sum:");
                for (String field : this.sumFields) {
                    if (count == 0L) {
                        fmt.format(eolt + "%s: Not available", field);
                        continue;
                    }
                    Number sum = aggResult.getSum(field);
                    if (sum == null) {
                        fmt.format(eolt + "%s: Not available", field);
                        continue;
                    }
                    fieldInfo = this.getFieldInfo(aggResult, field);
                    if (sum instanceof Double) {
                        if (((Double)sum).isInfinite()) {
                            fmt.format(eolt + "%s: numeric overflow", fieldInfo);
                            continue;
                        }
                        fmt.format(eolt + "%s: %.2f", fieldInfo, sum);
                        continue;
                    }
                    fmt.format(eolt + "%s: %d", fieldInfo, sum);
                }
            }
            if (!this.avgFields.isEmpty()) {
                sb.append(eol);
                sb.append("Average:");
                for (String field : this.avgFields) {
                    if (count == 0L) {
                        fmt.format(eolt + "%s: Not available", field);
                        continue;
                    }
                    Double avg = aggResult.getAvg(field);
                    fieldInfo = this.getFieldInfo(aggResult, field);
                    if (avg == null) {
                        fmt.format(eolt + "%s: Not available", field);
                        continue;
                    }
                    if (avg.isInfinite()) {
                        fmt.format(eolt + "%s: numeric overflow", fieldInfo);
                        continue;
                    }
                    fmt.format(eolt + "%s: %.2f", fieldInfo, (double)avg);
                }
            }
            fmt.close();
            return sb.toString();
        }

        private String getFieldInfo(AggResult aggResult, String field) {
            int cnt = aggResult.getCount(field);
            return field + "(" + cnt + (cnt > 1 ? " values" : " value") + ")";
        }

        static class CalcSumDouble
        extends CalcSum<Double> {
            CalcSumDouble(Number value) {
                super(value);
            }

            CalcSumDouble(CalcSum<?> sum) {
                super(sum);
            }

            @Override
            Double zero() {
                return 0.0;
            }

            @Override
            Double valueOf(Number v) {
                return v.doubleValue();
            }

            @Override
            Double add(Double v1, Number v2) {
                return v1 + v2.doubleValue();
            }
        }

        static class CalcSumLong
        extends CalcSum<Long> {
            CalcSumLong(Number value) {
                super(value);
            }

            CalcSumLong(CalcSum<?> sum) {
                super(sum);
            }

            @Override
            Long zero() {
                return 0L;
            }

            @Override
            Long valueOf(Number v) {
                return v.longValue();
            }

            @Override
            Long add(Long v1, Number v2) {
                return this.longAddAndCheck(v1, v2.longValue());
            }

            private long longAddAndCheck(long a, long b) {
                if (a > b) {
                    return this.longAddAndCheck(b, a);
                }
                if (a < 0L) {
                    if (b < 0L) {
                        if (Long.MIN_VALUE - b <= a) {
                            return a + b;
                        }
                        throw new ArithmeticException("Add failed: underflow");
                    }
                    return a + b;
                }
                if (a <= Long.MAX_VALUE - b) {
                    return a + b;
                }
                throw new ArithmeticException("Add failed: overflow");
            }
        }

        static abstract class CalcSum<T extends Number> {
            private int count;
            private T sum;

            CalcSum() {
                this.sum = this.zero();
                this.count = 0;
            }

            CalcSum(Number value) {
                this.sum = this.valueOf(value);
                this.count = 1;
            }

            CalcSum(CalcSum<?> cs) {
                this.sum = this.valueOf((Number)cs.getValue());
                this.count = cs.getCount();
            }

            void doSum(Number value) {
                this.sum = this.add(this.sum, value);
                ++this.count;
            }

            T getValue() {
                return this.sum;
            }

            int getCount() {
                return this.count;
            }

            abstract T zero();

            abstract T valueOf(Number var1);

            abstract T add(T var1, Number var2);
        }

        static class AggResult {
            private long count = 0L;
            private HashMap<String, CalcSum<?>> sums = new HashMap();

            AggResult() {
            }

            void tallyCount() {
                ++this.count;
            }

            long getCount() {
                return this.count;
            }

            Number getSum(String field) {
                CalcSum<?> sum = this.sums.get(field);
                if (sum == null) {
                    return null;
                }
                return sum.getValue();
            }

            int getCount(String field) {
                CalcSum<?> sum = this.sums.get(field);
                if (sum == null) {
                    return 0;
                }
                return sum.getCount();
            }

            Double getAvg(String field) {
                Number sum = this.getSum(field);
                int cnt = this.getCount(field);
                if (sum == null || cnt == 0) {
                    return null;
                }
                return sum.doubleValue() / (double)cnt;
            }

            void tallyInt(String field, Integer value) {
                this.tallyLong(field, value.longValue());
            }

            void tallyLong(String field, Long value) {
                CalcSum sum = this.sums.get(field);
                if (sum == null) {
                    sum = new CalcSumLong(value);
                    this.sums.put(field, sum);
                    return;
                }
                if (sum instanceof CalcSumLong) {
                    try {
                        sum.doSum(value);
                    }
                    catch (ArithmeticException ae) {
                        sum = new CalcSumDouble(sum);
                        ((CalcSumDouble)sum).doSum(value);
                        this.sums.put(field, sum);
                    }
                } else {
                    ((CalcSumDouble)sum).doSum(value);
                }
            }

            void tallyFloat(String field, Float value) {
                this.tallyDouble(field, value.doubleValue());
            }

            void tallyDouble(String field, Double value) {
                CalcSumDouble sum = this.sums.get(field);
                if (sum == null) {
                    sum = new CalcSumDouble(value);
                    this.sums.put(field, sum);
                } else {
                    ((CalcSumDouble)sum).doSum(value);
                }
            }
        }
    }
}

