/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.server;

import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.rep.LogFileRewriteListener;
import com.sleepycat.je.rep.SyncupProgress;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.util.FileUtils;

public class JENotifyHooks {

    public static class LogRewriteListener
    implements LogFileRewriteListener {
        private final File snapshotDir;
        private final Logger logger;

        public LogRewriteListener(File dir, Logger logger) {
            this.snapshotDir = dir;
            this.logger = logger;
        }

        @Override
        public void rewriteLogFiles(Set<File> files) {
            if (!this.snapshotDir.exists()) {
                return;
            }
            try {
                for (File file : files) {
                    this.logFileModifyTrigger(this.snapshotDir, file.getName());
                }
            }
            catch (IOException ie) {
                String msg = "JE/HA sync-up roll-back needs to modify an existing log file that is part of a Snapshot, but copying that file failed";
                this.logger.severe(msg);
                throw new RuntimeException(msg, ie);
            }
        }

        private void logFileModifyTrigger(File snapshotDir1, String name) throws IOException {
            for (File file : snapshotDir1.listFiles()) {
                if (file.isDirectory()) {
                    this.logFileModifyTrigger(file, name);
                }
                if (!file.getName().equals(name)) continue;
                File tempName = new File(snapshotDir1, name + ".temp");
                FileUtils.copyFile(file, tempName);
                tempName.renameTo(file);
            }
        }
    }

    public static class SyncupListener
    implements ProgressListener<SyncupProgress> {
        private static final String PREFIX = "JE syncup: ";
        private final Logger logger;

        public SyncupListener(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean progress(SyncupProgress phase, long n, long total) {
            if (n == -1L) {
                this.logger.log(Level.INFO, "JE syncup: {0}", (Object)phase);
            } else {
                this.logger.log(Level.INFO, "JE syncup: {0} {1}/{2}", new Object[]{phase, n, total});
            }
            return true;
        }
    }

    public static class RecoveryListener
    implements ProgressListener<RecoveryProgress> {
        static final String PREFIX = "JE recovery: ";
        private final Logger logger;

        public RecoveryListener(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean progress(RecoveryProgress phase, long n, long total) {
            if (n == -1L) {
                this.logger.log(Level.INFO, "JE recovery: {0}", (Object)phase);
            } else {
                this.logger.log(Level.INFO, "JE recovery: {0} {1}/{2}", new Object[]{phase, n, total});
            }
            return true;
        }
    }

    public static class RedirectHandler
    extends Handler {
        static final String PREFIX = "JE: ";
        private final Logger logger;

        public RedirectHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void publish(LogRecord record) {
            this.logger.log(record.getLevel(), PREFIX + record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

