/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.persist.EntityStore;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TxnUtil {
    public static void abort(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        Environment env = DbInternal.getEnvironment(transaction);
        try {
            if (env != null && env.isValid()) {
                transaction.abort();
            }
        }
        catch (IllegalArgumentException iae) {
            TxnUtil.ignoreIfClosed(env, iae);
        }
        catch (IllegalStateException ise) {
            TxnUtil.ignoreIfClosedOrAbort(transaction, env, ise);
        }
        catch (UnknownMasterException ume) {
            TxnUtil.ignoreIfClosedOrAbort(transaction, env, ume);
        }
        catch (ReplicaWriteException rwe) {
            TxnUtil.ignoreIfClosedOrAbort(transaction, env, rwe);
        }
    }

    private static void ignoreIfClosed(Environment env, RuntimeException re) {
        assert (env != null);
        if (env.isValid()) {
            throw re;
        }
    }

    private static void ignoreIfClosedOrAbort(Transaction transaction, Environment env, RuntimeException re) {
        assert (env != null);
        if (Transaction.State.MUST_ABORT.equals((Object)transaction.getState()) || Transaction.State.ABORTED.equals((Object)transaction.getState())) {
            return;
        }
        if (!env.isValid()) {
            return;
        }
        throw re;
    }

    public static void close(Cursor cursor) {
        try {
            cursor.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static RuntimeException close(Logger logger, final Database db, String dbType) {
        Environment env = db.getEnvironment();
        if (env == null) {
            return null;
        }
        return new WithDbCloseExceptionHandler(){

            @Override
            void closeInternal() {
                db.close();
            }
        }.close(logger, env, dbType);
    }

    public static RuntimeException close(Logger logger, Environment env, final EntityStore store, String entityType) {
        return new WithDbCloseExceptionHandler(){

            @Override
            void closeInternal() {
                store.close();
            }
        }.close(logger, env, entityType);
    }

    private static abstract class WithDbCloseExceptionHandler {
        private WithDbCloseExceptionHandler() {
        }

        abstract void closeInternal();

        RuntimeException close(Logger logger, Environment env, String dbType) {
            try {
                this.closeInternal();
                return null;
            }
            catch (IllegalStateException e) {
                this.logCloseException(logger, dbType, e);
                return e;
            }
            catch (RuntimeException re) {
                if (env.isValid()) {
                    logger.log(Level.SEVERE, "Unexpected exception closing " + dbType + " database.", re);
                    throw re;
                }
                this.logCloseException(logger, dbType, re);
                return re;
            }
        }

        private void logCloseException(Logger logger, String dbType, RuntimeException re) {
            logger.info("Ignoring exception closing " + dbType + " database " + " Exception:" + re.getClass().getName() + " Message:" + re.getMessage());
        }
    }
}

