/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public final class TopologyPrinter {
    public static final EnumSet<Filter> all = EnumSet.allOf(Filter.class);
    public static final EnumSet<Filter> components = EnumSet.of(Filter.STORE, Filter.DC, Filter.RN, Filter.SN, Filter.SHARD);

    private TopologyPrinter() {
        throw new AssertionError((Object)("Instantiated utility class " + TopologyPrinter.class));
    }

    public static void printTopology(Topology t, PrintStream out, Parameters params, EnumSet<Filter> filter, Map<ResourceId, ServiceChange> statusMap, Map<ResourceId, PerfEvent> perfMap, boolean verbose) {
        TopologyPrinter.printTopology(t, out, params, filter, verbose, null, statusMap, perfMap);
    }

    private static void printTopology(Topology t, PrintStream out, Parameters params, EnumSet<Filter> filter, boolean verbose, Map<RepNodeId, String> mountPointMap, Map<ResourceId, ServiceChange> statusMap, Map<ResourceId, PerfEvent> perfMap) {
        int indent = 0;
        int indentAmount = 2;
        boolean showStatus = filter.contains((Object)Filter.STATUS) && statusMap != null;
        boolean showPerf = filter.contains((Object)Filter.PERF) && perfMap != null;
        String storeName = t.getKVStoreName();
        if (filter.contains((Object)Filter.STORE)) {
            out.println("store=" + storeName + "  numPartitions=" + t.getPartitionMap().size() + " sequence=" + t.getSequenceNumber());
            indent += 2;
        }
        if (filter.contains((Object)Filter.DC)) {
            List<Datacenter> dcList = t.getSortedDatacenters();
            for (Datacenter dc : dcList) {
                out.println(TopologyPrinter.makeWhiteSpace(indent) + "zn" + ": " + dc);
            }
            if (dcList.size() > 0) {
                out.println();
            }
        }
        TreeMap snMap = new TreeMap();
        for (StorageNodeId snid : t.getStorageNodeMap().getAllIds()) {
            snMap.put(snid, new ArrayList());
        }
        List<RepNode> rnList = t.getSortedRepNodes();
        for (RepNode repNode : rnList) {
            List l = (List)snMap.get(repNode.getStorageNodeId());
            l.add(repNode.getResourceId());
        }
        for (Map.Entry entry : snMap.entrySet()) {
            StorageNodeId snId = (StorageNodeId)entry.getKey();
            String capacityInfo = null;
            StorageNodeParams snp = null;
            if (params != null && (snp = params.get(snId)) != null) {
                capacityInfo = " capacity=" + snp.getCapacity();
            }
            if (filter.contains((Object)Filter.SN)) {
                out.print(TopologyPrinter.makeWhiteSpace(indent) + "sn=" + t.get(snId));
                if (capacityInfo != null) {
                    out.print(capacityInfo);
                }
                if (showStatus) {
                    out.println(" " + TopologyPrinter.getStatus(statusMap, snId));
                } else {
                    out.println();
                }
                indent += 2;
            }
            if (filter.contains((Object)Filter.RN)) {
                ArrayList<String> rnsWithMountPoints = new ArrayList<String>();
                for (RepNodeId rnId : (List)entry.getValue()) {
                    RepNodeParams rnp;
                    String oneRN = "[" + rnId + "]";
                    if (showStatus) {
                        oneRN = oneRN + " " + TopologyPrinter.getStatus(statusMap, rnId, params);
                    }
                    if (!verbose) {
                        out.println(TopologyPrinter.makeWhiteSpace(indent) + oneRN);
                        if (!showPerf) continue;
                        out.println(TopologyPrinter.makeWhiteSpace((indent + 1) * 2) + TopologyPrinter.getPerf(perfMap, rnId));
                        continue;
                    }
                    String mountPoint = null;
                    if (mountPointMap != null) {
                        mountPoint = mountPointMap.get(rnId);
                    } else if (params != null && (rnp = params.get(rnId)) != null) {
                        mountPoint = rnp.getMountPointString();
                    }
                    if (mountPoint == null) {
                        out.print(TopologyPrinter.makeWhiteSpace(indent) + oneRN);
                        if (snp == null) {
                            out.println();
                        } else {
                            out.println("  " + snp.getRootDirPath());
                        }
                        if (!showPerf) continue;
                        out.println(TopologyPrinter.makeWhiteSpace((indent + 1) * 2) + TopologyPrinter.getPerf(perfMap, rnId));
                        continue;
                    }
                    rnsWithMountPoints.add(oneRN + "  " + mountPoint);
                    if (!showPerf) continue;
                    rnsWithMountPoints.add(TopologyPrinter.makeWhiteSpace((indent + 1) * 2) + TopologyPrinter.getPerf(perfMap, rnId));
                }
                for (String s : rnsWithMountPoints) {
                    out.println(TopologyPrinter.makeWhiteSpace(indent) + s);
                }
            }
            if (!filter.contains((Object)Filter.SN)) continue;
            indent -= 2;
        }
        if (filter.contains((Object)Filter.SHARD)) {
            out.println();
            Map<RepGroupId, List<PartitionId>> partToRG = TopologyPrinter.sortPartitions(t);
            for (Map.Entry<RepGroupId, List<PartitionId>> entry : partToRG.entrySet()) {
                RepGroupId rgId = entry.getKey();
                List<PartitionId> partIds = entry.getValue();
                RepGroup rg = t.get(rgId);
                out.println(TopologyPrinter.makeWhiteSpace(indent) + "shard=" + rg + " num partitions=" + partIds.size());
                if (filter.contains((Object)Filter.RN)) {
                    indent += 2;
                    ArrayList<RepNode> rns = new ArrayList<RepNode>(rg.getRepNodes());
                    Collections.sort(rns);
                    for (RepNode rn : rns) {
                        RepNodeParams rnp;
                        out.print(TopologyPrinter.makeWhiteSpace(indent) + rn);
                        if (verbose && params != null && (rnp = params.get((RepNodeId)rn.getResourceId())) != null) {
                            out.print(" haPort=" + rnp.getJENodeHostPort());
                        }
                        out.println();
                    }
                }
                if (verbose) {
                    out.println(TopologyPrinter.makeWhiteSpace(indent) + "partitions=" + TopologyPrinter.listPartitions(partIds));
                }
                if (!filter.contains((Object)Filter.RN)) continue;
                indent -= 2;
            }
        }
    }

    private static String getStatus(Map<ResourceId, ServiceChange> statusMap, ResourceId rId) {
        ServiceChange change = statusMap.get(rId);
        if (change == null) {
            return "UNREPORTED";
        }
        return change.getStatus().toString();
    }

    private static String getStatus(Map<ResourceId, ServiceChange> statusMap, RepNodeId rnId, Parameters params) {
        RepNodeParams rnp;
        String status = TopologyPrinter.getStatus(statusMap, rnId);
        if (params != null && (rnp = params.get(rnId)) != null && rnp.isDisabled()) {
            return "Stopped/" + status;
        }
        return status;
    }

    private static String getPerf(Map<ResourceId, PerfEvent> perfMap, ResourceId rId) {
        PerfEvent perf = perfMap.get(rId);
        if (perf == null) {
            return "No performance info available";
        }
        StringBuilder sb = new StringBuilder();
        LatencyInfo singleCum = perf.getSingleCum();
        LatencyInfo multiCum = perf.getMultiCum();
        sb.append("   single-op avg latency=").append(singleCum.getLatency().getAvg()).append(" ms");
        sb.append("   multi-op avg latency=").append(multiCum.getLatency().getAvg()).append(" ms");
        if (perf.needsAlert()) {
            sb.append("[ALERT]");
        }
        return sb.toString();
    }

    public static String listPartitions(List<PartitionId> partIds) {
        int first;
        if (partIds.isEmpty()) {
            return "";
        }
        Collections.sort(partIds, new Comparator<PartitionId>(){

            @Override
            public int compare(PartitionId o1, PartitionId o2) {
                return o1.getPartitionId() - o2.getPartitionId();
            }
        });
        int last = first = partIds.get(0).getPartitionId();
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        for (PartitionId p : partIds) {
            int pId = p.getPartitionId();
            if (pId == last) continue;
            if (pId == last + 1) {
                last = pId;
                continue;
            }
            if (last > first) {
                sb.append("-").append(last);
            }
            last = first = pId;
            sb.append(",").append(first);
        }
        if (last > first) {
            sb.append("-").append(last);
        }
        return sb.toString();
    }

    public static String printTopology(Topology t, Parameters params, boolean verbose) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TopologyPrinter.printTopology(t, new PrintStream(outStream), params, all, verbose, null, null, null);
        return outStream.toString();
    }

    public static String printTopology(Topology t) {
        return TopologyPrinter.printTopology(t, null, false);
    }

    public static String printTopology(TopologyCandidate tc, Parameters params, boolean verbose) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TopologyPrinter.printTopology(tc.getTopology(), new PrintStream(outStream), params, all, verbose, tc.getAllMountPoints(), null, null);
        return outStream.toString();
    }

    private static String makeWhiteSpace(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    private static Map<RepGroupId, List<PartitionId>> sortPartitions(Topology t) {
        TreeMap<RepGroupId, List<PartitionId>> partToRG = new TreeMap<RepGroupId, List<PartitionId>>(new RGComparator());
        for (RepGroup rg : t.getRepGroupMap().getAll()) {
            partToRG.put((RepGroupId)rg.getResourceId(), new ArrayList());
        }
        for (Partition p : t.getPartitionMap().getAll()) {
            List pIds = (List)partToRG.get(p.getRepGroupId());
            pIds.add(p.getResourceId());
        }
        return partToRG;
    }

    public static void printZoneInfo(DatacenterId id, String name, Topology topo, PrintStream out, Parameters params) {
        int indent = 0;
        int indentAmount = 2;
        boolean showAll = id == null && name == null;
        Datacenter showZone = null;
        List<Datacenter> dcList = topo.getSortedDatacenters();
        for (Datacenter zone : dcList) {
            if (showAll) {
                out.println(TopologyPrinter.makeWhiteSpace(indent) + "zn" + ": " + zone);
                continue;
            }
            if (id != null && id.equals(zone.getResourceId())) {
                showZone = zone;
                break;
            }
            if (name == null || !name.equals(zone.getName())) continue;
            showZone = zone;
            break;
        }
        if (showAll) {
            return;
        }
        if (showZone == null) {
            out.println(TopologyPrinter.makeWhiteSpace(indent) + "zn" + ": unknown id or name");
            return;
        }
        out.println(TopologyPrinter.makeWhiteSpace(indent) + "zn" + ": " + showZone);
        DatacenterId showZoneId = (DatacenterId)showZone.getResourceId();
        List<StorageNode> snList = topo.getSortedStorageNodes();
        String capacityInfo = null;
        StorageNodeParams snp = null;
        indent += 2;
        for (StorageNode sn : snList) {
            if (!showZoneId.equals(sn.getDatacenterId())) continue;
            out.print(TopologyPrinter.makeWhiteSpace(indent) + "[" + sn.getResourceId() + "] " + sn.getHostname() + ":" + sn.getRegistryPort());
            if (params != null && (snp = params.get((StorageNodeId)sn.getResourceId())) != null) {
                capacityInfo = " capacity=" + snp.getCapacity();
            }
            if (capacityInfo != null) {
                out.print(capacityInfo);
            }
            out.println();
        }
    }

    private static class RGComparator
    implements Comparator<RepGroupId> {
        private RGComparator() {
        }

        @Override
        public int compare(RepGroupId o1, RepGroupId o2) {
            return o1.getGroupId() - o2.getGroupId();
        }
    }

    public static enum Filter {
        STORE,
        DC,
        RN,
        SN,
        SHARD,
        STATUS,
        PERF;

    }
}

