/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Arrays;
import oracle.kv.FaultException;
import oracle.kv.KVStoreException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopologyLocator {
    public static final String HOST_PORT_SEPARATOR = ":";

    public static Topology get(String[] registryHostPorts, int maxRNs, LoginManager loginMgr, String expectedStoreName) throws KVStoreException {
        Topology initialTopology = TopologyLocator.getInitialTopology(registryHostPorts, loginMgr, expectedStoreName);
        int maxTopoSeqNum = 0;
        RepNodeAdminAPI currentAdmin = null;
        Exception exception = null;
        RegistryUtils registryUtils = new RegistryUtils(initialTopology, loginMgr);
        block6: for (RepGroup rg : initialTopology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                try {
                    RepNodeAdminAPI admin = registryUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    int seqNum = admin.getTopoSeqNum();
                    if (seqNum > maxTopoSeqNum) {
                        maxTopoSeqNum = seqNum;
                        currentAdmin = admin;
                    }
                    if (--maxRNs >= 0) continue;
                    break block6;
                }
                catch (SessionAccessException e) {
                    exception = e;
                }
                catch (RemoteException e) {
                    exception = e;
                }
                catch (NotBoundException e) {
                    exception = e;
                }
            }
        }
        if (currentAdmin != null) {
            try {
                return currentAdmin.getTopology();
            }
            catch (RemoteException e) {
                exception = e;
            }
        }
        throw new KVStoreException("Could not establish an initial Topology from: " + Arrays.toString(registryHostPorts), exception);
    }

    private static Topology getInitialTopology(String[] registryHostPorts, LoginManager loginMgr, String expectedStoreName) throws KVStoreException {
        Exception cause = null;
        int maxTopoSeqNum = 0;
        RepNodeAdminAPI currentAdmin = null;
        for (String registryHostPort : registryHostPorts) {
            HostPort hostPort = HostPort.parse(registryHostPort);
            String registryHostname = hostPort.hostname();
            int registryPort = hostPort.port();
            try {
                Registry snRegistry = RegistryUtils.getRegistry(registryHostname, registryPort, expectedStoreName);
                for (String serviceName : snRegistry.list()) {
                    try {
                        LoginHandle loginHdl;
                        RepNodeAdminAPI admin;
                        int seqNum;
                        Remote stub;
                        if (!RegistryUtils.isRepNodeAdmin(serviceName) || !((stub = snRegistry.lookup(serviceName)) instanceof RepNodeAdmin) || (seqNum = (admin = RepNodeAdminAPI.wrap((RepNodeAdmin)stub, loginHdl = loginMgr == null ? null : loginMgr.getHandle(new HostPort(registryHostname, registryPort), ResourceId.ResourceType.REP_NODE))).getTopoSeqNum()) <= maxTopoSeqNum) continue;
                        maxTopoSeqNum = seqNum;
                        currentAdmin = admin;
                    }
                    catch (SessionAccessException e) {
                        cause = e;
                    }
                    catch (AccessException e) {
                        cause = e;
                    }
                    catch (NotBoundException e) {
                        cause = e;
                    }
                    catch (InternalFaultException e) {
                        if (cause != null) continue;
                        cause = e;
                    }
                }
            }
            catch (RemoteException e) {
                cause = e;
            }
        }
        if (currentAdmin == null) {
            throw new KVStoreException("Could not contact any RepNode at: " + Arrays.toString(registryHostPorts), cause);
        }
        try {
            return currentAdmin.getTopology();
        }
        catch (RemoteException e) {
            throw new KVStoreException("Could not establish an initial Topology from: " + Arrays.toString(registryHostPorts), cause);
        }
        catch (InternalFaultException e) {
            throw new FaultException(e, false);
        }
    }
}

