/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.util.ConfigurableService;

public class ServiceStatusTracker {
    private ServiceStatusChange prev = null;
    private ServiceStatusChange current = new ServiceStatusChange(ConfigurableService.ServiceStatus.STARTING);
    private final List<Listener> listeners;
    private Logger logger;

    public ServiceStatusTracker(Logger logger) {
        this.logger = logger;
        this.listeners = new LinkedList<Listener>();
    }

    public ServiceStatusTracker(Logger logger, AgentRepository agentRepository) {
        this(logger);
        this.addListener(new StatusMonitor(agentRepository));
    }

    public ConfigurableService.ServiceStatus getServiceStatus() {
        return this.current.getStatus();
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void addListener(AgentRepository agentRepository) {
        this.listeners.add(new StatusMonitor(agentRepository));
    }

    public synchronized void update(ConfigurableService.ServiceStatus newStatus) {
        if (this.current.getStatus().equals((Object)newStatus)) {
            this.current.updateTime();
            return;
        }
        this.prev = this.current;
        this.current = new ServiceStatusChange(newStatus);
        this.logger.info("Service status changed from " + (Object)((Object)this.prev.getStatus()) + " to " + (Object)((Object)newStatus));
        for (Listener listener : this.listeners) {
            listener.update(this.prev, this.current);
        }
    }

    private class StatusMonitor
    implements Listener {
        private final AgentRepository monitorAgentBuffer;

        StatusMonitor(AgentRepository monitorAgentBuffer) {
            this.monitorAgentBuffer = monitorAgentBuffer;
        }

        @Override
        public void update(ServiceStatusChange prevStatus, ServiceStatusChange newStatus) {
            this.monitorAgentBuffer.add(newStatus);
        }
    }

    public static interface Listener {
        public void update(ServiceStatusChange var1, ServiceStatusChange var2);
    }
}

