/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.mgmt.MgmtUtil;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.sna.StorageNodeAgentImpl;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.SecurityConfigCommand;
import oracle.kv.impl.util.SecurityConfigCreator;
import oracle.kv.impl.util.SecurityShell;
import oracle.kv.util.GenerateConfig;
import oracle.kv.util.Load;
import oracle.kv.util.Ping;
import oracle.kv.util.kvlite.KVLite;

public class KVStoreMain {
    private static final String HELP_COMMAND_NAME = "help";
    private static final String HELP_COMMAND_DESC = "prints usage info";
    private static final String HELP_COMMANDS_COMMAND = "commands";
    private static final String VERSION_COMMAND_NAME = "version";
    private static final String VERSION_COMMAND_DESC = "prints version";
    private static final String MAKECONFIG_COMMAND_NAME = "makebootconfig";
    private static final String MAKECONFIG_COMMAND_DESC = "creates configuration files required in kvroot";
    private static final String HARANGE_FLAG = "-harange";
    private static final String HAHOST_FLAG = "-hahost";
    private static final String SECURITY_CONFIGURE = "configure";
    private static final String SECURITY_ENABLE = "enable";
    private static final String SECURITY_NONE = "none";
    private static final String MAKECONFIG_COMMAND_ARGS = CommandParser.getRootUsage() + " " + CommandParser.getHostUsage() + " " + "-harange" + " <startPort,endPort>" + "\n\t" + "-store-security" + " configure|enable|none" + "\n\t" + CommandParser.getPortUsage() + " " + CommandParser.optional(CommandParser.getAdminUsage()) + CommandParser.optional("-runadmin") + CommandParser.optional("-config <configFile>") + "\n\t" + CommandParser.optional("-storagedir <directory path>") + CommandParser.optional("-capacity <n_rep_nodes>") + "\n\t" + CommandParser.optional("-num_cpus <ncpus>") + CommandParser.optional("-memory_mb <memory_mb>") + "\n\t" + CommandParser.optional("-servicerange <startPort,endPort>") + "\n\t" + CommandParser.optional("-hahost <haHostname>") + "\n\t" + SecurityConfigCommand.ConfigParserHelper.getConfigUsage() + "\n\t" + MgmtUtil.getMgmtUsage(false);
    private static final String FLAG_DESCRIPTIONS = "\n  -root <kvroot>\n\t# the root directory for the store\n  -host <hostname>\n\t# the hostname to use\n  -port <port>\n\t# the registry port to use\n  -store <storename>\n\t# the target store (used by load)\n  -source <snapshot>\n\t# the snapshot source for load\n  -status <path>\n\t# the status file used by load\n  -admin <adminport>\n\t# the HTTP port for the admin to use\n  -runadmin\n\t# force to start a bootstrap admin\n  -hahost <hostname>\n\t# the hostname to be used by HA. It defaults to the -host value.\n  -harange <portstart,portend>\n\t# the range of ports for replicated services to use. E.g. \"5030,5040\"\n  -servicerange <portstart,portend>\n\t# the range of ports for use by RMI services. \n\t# E.g. \"5050,5060\" or \"0\" for unconstrained use of ports\n  -config <configfile>\n\t# the configuration file in kvroot, defaults to \"config.xml\"\n  -storagedir <directory name>\n\t# directory to use for the Replication Nodes hosted by this SN, \n\t# more than one set of -storagedir <directory> flags may be specified.\n  -capacity <num_rep_nodes>\n\t# the number of RepNodes this Storage Node can handle.\n  -num_cpus <num_cpus>\n\t# the number of CPUs on the Storage Node.\n  -memory_mb <memory_in_mb>\n\t# the amount of memory available to use.\n  -script <scriptfile>\n\t# the admin script file to execute";
    private static Command[] ALL_COMMANDS = new Command[]{new Command("kvlite", "start KVLite; note all args (-host, -port, etc) have defaults"){

        @Override
        void run(String[] args) throws Exception {
            KVLite.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return KVLite.COMMAND_ARGS;
        }
    }, new Command("makebootconfig", "creates configuration files required in kvroot"){

        @Override
        void run(String[] args) {
            KVStoreMain.makeBootConfig(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return MAKECONFIG_COMMAND_ARGS;
        }
    }, new Command("securityconfig", "runs the security configuration command line interface"){

        @Override
        void run(String[] args) {
            SecurityShell.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return SecurityShell.COMMAND_ARGS;
        }
    }, new Command("start", "starts StorageNodeAgent (and if configured, store) in kvroot"){

        @Override
        void run(String[] args) {
            StorageNodeAgentImpl.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return StorageNodeAgent.COMMAND_ARGS;
        }
    }, new Command("stop", "stops StorageNodeAgent and services related to kvroot"){

        @Override
        void run(String[] args) {
            StorageNodeAgentImpl.main(KVStoreMain.makeArgs(args, new String[]{"-shutdown"}));
        }

        @Override
        String getUsageArgs() {
            return StorageNodeAgent.COMMAND_ARGS;
        }
    }, new Command("restart", "combines stop and start commands into one"){

        @Override
        void run(String[] args) {
            StorageNodeAgentImpl.main(KVStoreMain.makeArgs(args, new String[]{"-shutdown"}));
            StorageNodeAgentImpl.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return StorageNodeAgent.COMMAND_ARGS;
        }
    }, new Command("runadmin", "runs the command line interface"){

        @Override
        void run(String[] args) throws Exception {
            String[] prefixArgs = new String[]{args[0], "-kvstore-main", "runadmin"};
            if (args.length > 1) {
                String[] remainArgs = new String[args.length - 1];
                System.arraycopy(args, 1, remainArgs, 0, remainArgs.length);
                CommandShell.main(KVStoreMain.makeArgs(prefixArgs, remainArgs));
            } else {
                CommandShell.main(KVStoreMain.makeArgs(prefixArgs, new String[0]));
            }
        }

        @Override
        String getUsageArgs() {
            return CommandShell.COMMAND_ARGS;
        }
    }, new Command("load", "loads data into a store from a backup"){

        @Override
        void run(String[] args) throws Exception {
            Load.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return Load.COMMAND_ARGS;
        }
    }, new Command("ping", "attempts to contact a store to get status of running services"){

        @Override
        void run(String[] args) throws Exception {
            Ping.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return Ping.COMMAND_ARGS;
        }
    }, new Command("version", "prints version"){

        @Override
        void run(String[] args) {
            KVVersion.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return null;
        }

        @Override
        boolean isHelpCommand() {
            return true;
        }
    }, new Command("generateconfig", "generates configuration files for the specified storage node"){

        @Override
        void run(String[] args) {
            GenerateConfig.main(KVStoreMain.makeArgs(args, new String[0]));
        }

        @Override
        String getUsageArgs() {
            return GenerateConfig.COMMAND_ARGS;
        }
    }, new Command("help", "prints usage info"){

        @Override
        void run(String[] args) {
            KVStoreMain.doHelpCommand(args);
        }

        @Override
        String getUsageArgs() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            builder.append(KVStoreMain.HELP_COMMANDS_COMMAND);
            for (Command cmd : ALL_COMMANDS) {
                builder.append(" |\n\t ");
                builder.append(cmd.name);
            }
            builder.append(']');
            return builder.toString();
        }

        @Override
        boolean isHelpCommand() {
            return true;
        }
    }};

    private static String[] makeArgs(String[] origArgs, String ... addArgs) {
        int useOrigArgs = origArgs.length - 1;
        String[] newArgs = new String[useOrigArgs + addArgs.length];
        System.arraycopy(origArgs, 1, newArgs, 0, useOrigArgs);
        System.arraycopy(addArgs, 0, newArgs, useOrigArgs, addArgs.length);
        return newArgs;
    }

    private static Command findCommand(String name) {
        for (Command cmd : ALL_COMMANDS) {
            if (!cmd.name.equals(name)) continue;
            return cmd;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String cmdName = args.length == 0 ? HELP_COMMAND_NAME : args[0];
        Command cmd = KVStoreMain.findCommand(cmdName);
        if (cmd == null) {
            KVStoreMain.usage("Unknown command: " + cmdName);
        }
        if (KVStoreMain.findVerbose(args) && !cmd.isHelpCommand()) {
            System.err.println("Enter command: " + cmdName);
            cmd.run(args);
            System.err.println("Leave command: " + cmdName);
        } else {
            cmd.run(args);
        }
    }

    private static boolean findVerbose(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-verbose")) continue;
            return true;
        }
        return false;
    }

    private static void doHelpCommand(String[] args) {
        Command cmd;
        String cmdName;
        if (args.length <= 1) {
            KVStoreMain.usage(null);
        }
        if (HELP_COMMANDS_COMMAND.equals(cmdName = args[1])) {
            System.err.println("Commands are:");
            for (Command cmd2 : ALL_COMMANDS) {
                System.err.println("  " + cmd2.name + "\n\t# " + cmd2.description);
            }
            System.err.println("\nFlags used by the commands are:\n  -root <kvroot>\n\t# the root directory for the store\n  -host <hostname>\n\t# the hostname to use\n  -port <port>\n\t# the registry port to use\n  -store <storename>\n\t# the target store (used by load)\n  -source <snapshot>\n\t# the snapshot source for load\n  -status <path>\n\t# the status file used by load\n  -admin <adminport>\n\t# the HTTP port for the admin to use\n  -runadmin\n\t# force to start a bootstrap admin\n  -hahost <hostname>\n\t# the hostname to be used by HA. It defaults to the -host value.\n  -harange <portstart,portend>\n\t# the range of ports for replicated services to use. E.g. \"5030,5040\"\n  -servicerange <portstart,portend>\n\t# the range of ports for use by RMI services. \n\t# E.g. \"5050,5060\" or \"0\" for unconstrained use of ports\n  -config <configfile>\n\t# the configuration file in kvroot, defaults to \"config.xml\"\n  -storagedir <directory name>\n\t# directory to use for the Replication Nodes hosted by this SN, \n\t# more than one set of -storagedir <directory> flags may be specified.\n  -capacity <num_rep_nodes>\n\t# the number of RepNodes this Storage Node can handle.\n  -num_cpus <num_cpus>\n\t# the number of CPUs on the Storage Node.\n  -memory_mb <memory_in_mb>\n\t# the amount of memory available to use.\n  -script <scriptfile>\n\t# the admin script file to execute");
            KVStoreMain.usageExit();
        }
        if ((cmd = KVStoreMain.findCommand(cmdName)) == null) {
            KVStoreMain.usage("Unknown 'help' topic: " + args[1]);
        }
        String usageArgs = cmd.getUsageArgs();
        System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar " + cmdName + " " + (cmd.isHelpCommand() ? "" : CommandParser.optional("-verbose")) + (usageArgs == null ? "" : "\n\t" + usageArgs));
        System.err.println("# " + cmd.description);
        KVStoreMain.usageExit();
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null) {
            System.err.println(errorMsg);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: java -jar KVHOME/lib/kvstore.jar ");
        builder.append("\n  <");
        builder.append(KVStoreMain.ALL_COMMANDS[0].name);
        for (int i = 1; i < ALL_COMMANDS.length; ++i) {
            builder.append(" |\n   ");
            builder.append(KVStoreMain.ALL_COMMANDS[i].name);
        }
        builder.append("> [-verbose] [args]");
        builder.append("\nUse \"help <commandName>\" to get usage for a ");
        builder.append("specific command");
        builder.append("\nUse \"help commands\" to get detailed usage ");
        builder.append("information");
        builder.append("\nUse the -verbose flag to get debugging output");
        System.err.println(builder);
        KVStoreMain.usageExit();
    }

    private static void usageExit() {
        System.exit(2);
    }

    private static void makeBootConfig(String[] args) {
        MakeConfigParser cp = new MakeConfigParser(args);
        cp.parseArgs();
        File rootDir = new File(cp.getRootDir());
        File secFile = new File(rootDir, "security.policy");
        if (secFile.exists()) {
            System.err.println(secFile.toString() + " exists, not creating");
        } else {
            cp.verbose("Creating " + secFile);
            ConfigUtils.createSecurityPolicyFile(secFile);
        }
        File configFile = new File(rootDir, cp.configFile);
        if (configFile.exists()) {
            System.err.println(configFile.toString() + " exists, not creating");
        } else {
            cp.getSecurityConfig().populateDefaults();
            File secDir = new File(cp.getRootDir(), cp.getSecurityDir());
            if (cp.getSecurityAction().equals(SECURITY_CONFIGURE)) {
                if (secDir.exists()) {
                    System.err.println(secDir + " exists, not creating");
                } else {
                    SecurityConfigCreator scCreator = new SecurityConfigCreator(cp.getRootDir(), cp.getSecurityConfig(), new SecurityConfigCreator.GenericIOHelper(System.out));
                    try {
                        scCreator.createConfig();
                    }
                    catch (Exception e) {
                        System.err.println("Caught exception " + e);
                        return;
                    }
                }
            } else if (cp.getSecurityAction().equals(SECURITY_NONE)) {
                if (secDir.exists()) {
                    System.err.println(secDir + " will be ignored because -store-security " + "none was specified.");
                }
            } else if (cp.getSecurityAction().equals(SECURITY_ENABLE)) {
                if (!secDir.exists()) {
                    System.err.println(secDir + " does not exist. Be " + "sure to create it before starting " + "the server.");
                } else if (!KVStoreMain.isSecurityDir(secDir)) {
                    System.err.println(secDir + " does not appear to be " + "a valid security configuration.  Be " + "sure to replace it with a security " + "configuration before starting the " + "server.");
                }
            }
            cp.verbose("Creating " + configFile);
            BootstrapParams bp = cp.getBootstrapParams();
            ConfigUtils.createBootstrapConfig(bp, configFile);
        }
    }

    private static boolean isSecurityDir(File secDir) {
        String[] checkNames;
        if (!secDir.exists() || !secDir.isDirectory()) {
            return false;
        }
        for (String name : checkNames = new String[]{"security.xml", "store.keys", "store.trust"}) {
            if (new File(secDir, name).exists()) continue;
            return false;
        }
        return true;
    }

    private static class MakeConfigParser
    extends CommandParser {
        public static final String MOUNT_FLAG = "-storagedir";
        public static final String CAPACITY_FLAG = "-capacity";
        public static final String CPU_FLAG = "-num_cpus";
        public static final String MEMORY_FLAG = "-memory_mb";
        private static final String SERVICERANGE_FLAG = "-servicerange";
        private static final String STORE_SECURITY_FLAG = "-store-security";
        private static final String FORCE_ADMIN_FLAG = "-runadmin";
        String configFile = "config.xml";
        String haPortRange = null;
        String haHostname = null;
        String servicePortRange = null;
        String securityAction = null;
        MgmtUtil.ConfigParserHelper mgmtParser;
        SecurityConfigCommand.ConfigParserHelper securityParser;
        List<String> mountPoints = new ArrayList<String>();
        int capacity = 0;
        int num_cpus = 0;
        int memory_mb = 0;
        boolean isRunAdmin = false;

        MakeConfigParser(String[] args) {
            super(args);
            this.mgmtParser = new MgmtUtil.ConfigParserHelper(this, false);
            this.securityParser = new SecurityConfigCommand.ConfigParserHelper(this);
        }

        public List<String> getMountPoints() {
            return this.mountPoints;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getNumCPUs() {
            return this.num_cpus;
        }

        public int getMemoryMB() {
            return this.memory_mb;
        }

        public String getSecurityAction() {
            return this.securityAction;
        }

        public String getSecurityDir() {
            return this.getSecurityConfig().getSecurityDir();
        }

        private SecurityConfigCreator.ParsedConfig getSecurityConfig() {
            return this.securityParser.getConfig();
        }

        @Override
        public void verifyArgs() {
            if (this.getRootDir() == null) {
                this.missingArg("-root");
            }
            if (this.getHostname() == null) {
                this.missingArg("-host");
            }
            if (this.getRegistryPort() == 0) {
                this.missingArg("-port");
            }
            if (this.haPortRange == null) {
                this.missingArg(KVStoreMain.HARANGE_FLAG);
            }
            if (this.securityAction == null) {
                this.missingArg(STORE_SECURITY_FLAG);
            }
        }

        @Override
        public boolean checkArg(String arg) {
            if (arg.equals("-config")) {
                this.configFile = this.nextArg(arg);
                return true;
            }
            if (arg.equals(SERVICERANGE_FLAG)) {
                String nextArg = this.nextArg(arg);
                try {
                    PortRange.validateService(nextArg);
                }
                catch (RuntimeException e) {
                    this.usage(e.getMessage());
                }
                this.servicePortRange = nextArg;
                return true;
            }
            if (arg.equals(KVStoreMain.HARANGE_FLAG)) {
                String nextArg = this.nextArg(arg);
                try {
                    PortRange.validateHA(nextArg);
                }
                catch (RuntimeException e) {
                    this.usage(e.getMessage());
                }
                this.haPortRange = nextArg;
                return true;
            }
            if (arg.equals(KVStoreMain.HAHOST_FLAG)) {
                this.haHostname = this.nextArg(arg);
                return true;
            }
            if (arg.equals(MOUNT_FLAG)) {
                String nextArg = this.nextArg(arg);
                this.mountPoints.add(nextArg);
                return true;
            }
            if (arg.equals(CAPACITY_FLAG)) {
                String nextArg = this.nextArg(arg);
                this.capacity = Integer.parseInt(nextArg);
                return true;
            }
            if (arg.equals(CPU_FLAG)) {
                String nextArg = this.nextArg(arg);
                this.num_cpus = Integer.parseInt(nextArg);
                return true;
            }
            if (arg.equals(MEMORY_FLAG)) {
                String nextArg = this.nextArg(arg);
                this.memory_mb = Integer.parseInt(nextArg);
                return true;
            }
            if (arg.equals(STORE_SECURITY_FLAG)) {
                String nextArg;
                this.securityAction = nextArg = this.nextArg(arg);
                if (!(this.securityAction.equals(KVStoreMain.SECURITY_CONFIGURE) || this.securityAction.equals(KVStoreMain.SECURITY_ENABLE) || this.securityAction.equals(KVStoreMain.SECURITY_NONE))) {
                    this.usage("The value '" + this.securityAction + "' is not valid for " + STORE_SECURITY_FLAG);
                }
                return true;
            }
            if (arg.equals(FORCE_ADMIN_FLAG)) {
                this.isRunAdmin = true;
                return true;
            }
            if (this.securityParser.checkArg(arg)) {
                return true;
            }
            return this.mgmtParser.checkArg(arg);
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar makebootconfig\n\t" + MAKECONFIG_COMMAND_ARGS);
            KVStoreMain.usageExit();
        }

        private BootstrapParams getBootstrapParams() {
            boolean isSecure = !this.getSecurityAction().equals(KVStoreMain.SECURITY_NONE);
            BootstrapParams bp = new BootstrapParams(null, this.getHostname(), this.haHostname, this.haPortRange, this.servicePortRange, null, this.getRegistryPort(), this.getAdminPort(), this.getCapacity(), this.getMountPoints(), isSecure);
            if (this.getNumCPUs() != 0) {
                bp.setNumCPUs(this.getNumCPUs());
            }
            if (this.getMemoryMB() != 0) {
                bp.setMemoryMB(this.getMemoryMB());
            }
            if (isSecure) {
                bp.setSecurityDir(this.getSecurityDir());
            }
            bp.setForceBootstrapAdmin(this.isRunAdmin);
            this.mgmtParser.apply(bp);
            return bp;
        }
    }

    private static abstract class Command {
        final String name;
        final String description;

        Command(String name, String description) {
            this.name = name;
            this.description = description;
        }

        abstract void run(String[] var1) throws Exception;

        abstract String getUsageArgs();

        boolean isHelpCommand() {
            return false;
        }
    }
}

