/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

public class HostPort {
    private final String hostname;
    private final int port;

    public HostPort(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public static HostPort parse(String hostPort) {
        int registryPort;
        if (hostPort == null || hostPort.length() == 0) {
            throw new IllegalArgumentException("Null or empty host and port pair: " + hostPort);
        }
        int portStartIndex = hostPort.indexOf(":");
        if (portStartIndex <= 0 || portStartIndex == hostPort.length() - 1) {
            throw new IllegalArgumentException("Missing or illegal port separator char: " + hostPort);
        }
        String registryHostname = hostPort.substring(0, portStartIndex);
        try {
            registryPort = Integer.parseInt(hostPort.substring(portStartIndex + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal number format for port: " + hostPort + " " + e);
        }
        return new HostPort(registryHostname, registryPort);
    }

    public static HostPort[] parse(String[] hostPorts) {
        HostPort[] hps = new HostPort[hostPorts.length];
        for (int i = 0; i < hostPorts.length; ++i) {
            hps[i] = HostPort.parse(hostPorts[i]);
        }
        return hps;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof HostPort)) {
            return false;
        }
        HostPort otherHostPort = (HostPort)other;
        return this.hostname.equals(otherHostPort.hostname) && this.port == otherHostPort.port;
    }

    public int hashCode() {
        return this.hostname.hashCode() + this.port * 31;
    }
}

