/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.rep.CommitPointConsistencyPolicy;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Version;

public final class ConsistencyTranslator {
    private ConsistencyTranslator() {
        throw new AssertionError((Object)("Instantiated utility class " + ConsistencyTranslator.class));
    }

    public static ReplicaConsistencyPolicy translate(Consistency consistency) {
        if (Consistency.ABSOLUTE.equals(consistency)) {
            throw new IllegalStateException("There is no translation for " + Consistency.ABSOLUTE.getName());
        }
        if (Consistency.NONE_REQUIRED.equals(consistency) || Consistency.NONE_REQUIRED_NO_MASTER.equals(consistency)) {
            return NoConsistencyRequiredPolicy.NO_CONSISTENCY;
        }
        if (consistency instanceof Consistency.Time) {
            Consistency.Time c = (Consistency.Time)consistency;
            return new TimeConsistencyPolicy(c.getPermissibleLag(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS, c.getTimeout(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        if (consistency instanceof Consistency.Version) {
            Consistency.Version c = (Consistency.Version)consistency;
            CommitToken commitToken = new CommitToken(c.getVersion().getRepGroupUUID(), c.getVersion().getVersion());
            return new CommitPointConsistencyPolicy(commitToken, c.getTimeout(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        throw new UnsupportedOperationException("unknown consistency: " + consistency);
    }

    public static Consistency translate(ReplicaConsistencyPolicy consistency) {
        return ConsistencyTranslator.translate(consistency, null);
    }

    public static Consistency translate(ReplicaConsistencyPolicy consistency, Consistency kvConsistency) {
        if (NoConsistencyRequiredPolicy.NO_CONSISTENCY.equals(consistency)) {
            if (kvConsistency == null) {
                return Consistency.NONE_REQUIRED;
            }
            if (!Consistency.NONE_REQUIRED.equals(kvConsistency) && !Consistency.NONE_REQUIRED_NO_MASTER.equals(kvConsistency)) {
                throw new UnsupportedOperationException("invalid consistency [KV consistency=" + kvConsistency + ", HA consistency=" + consistency + "]");
            }
            return kvConsistency;
        }
        if (consistency instanceof TimeConsistencyPolicy) {
            TimeConsistencyPolicy c = (TimeConsistencyPolicy)consistency;
            return new Consistency.Time(c.getPermissibleLag(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS, c.getTimeout(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        if (consistency instanceof CommitPointConsistencyPolicy) {
            CommitPointConsistencyPolicy c = (CommitPointConsistencyPolicy)consistency;
            CommitToken commitToken = c.getCommitToken();
            Version version = new Version(commitToken.getRepenvUUID(), commitToken.getVLSN());
            return new Consistency.Version(version, c.getTimeout(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        throw new UnsupportedOperationException("unknown consistency: " + consistency);
    }
}

