/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManager;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

abstract class TopoCache {
    private final MasterBalanceManager.SNInfo snInfo;
    private volatile Topology topology;
    private final AtomicReference<MasterBalancingInterface.StateInfo> latestStateInfo;
    private int rnCount;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final LoginManager loginMgr;
    private long lastValidationTimeMs = 0L;
    private static long validationPeriodMs = 60000L;
    private final Logger logger;

    TopoCache(MasterBalanceManager.SNInfo snInfo, Logger logger, LoginManager loginMgr) {
        this.snInfo = snInfo;
        this.logger = logger;
        this.loginMgr = loginMgr;
        this.latestStateInfo = new AtomicReference<MasterBalancingInterface.StateInfo>(new MasterBalancingInterface.StateInfo(null, null, 0));
    }

    boolean isInitialized() {
        return this.topology != null;
    }

    Topology getTopology() {
        if (this.topology == null) {
            throw new IllegalStateException("no topology in topology cache");
        }
        return this.topology;
    }

    void noteLatestTopo(MasterBalancingInterface.StateInfo stateInfo) {
        block1: {
            MasterBalancingInterface.StateInfo si;
            do {
                si = this.latestStateInfo.get();
                if (stateInfo.topoSequenceNumber <= si.topoSequenceNumber) break block1;
            } while (!this.latestStateInfo.compareAndSet(si, stateInfo));
            return;
        }
    }

    int getPrimaryRF() {
        Topology topo = this.topology;
        if (topo == null) {
            throw new IllegalStateException("no topology in topology cache");
        }
        int rf = 0;
        for (Datacenter dc : topo.getDatacenterMap().getAll()) {
            if (!dc.getDatacenterType().isPrimary()) continue;
            rf += dc.getRepFactor();
        }
        return rf;
    }

    abstract Set<RepNodeId> getActiveRNs();

    public static long getValidationIntervalMs() {
        return validationPeriodMs;
    }

    public static void setValidationIntervalMs(long validationIntervalMs) {
        validationPeriodMs = validationIntervalMs;
    }

    boolean ensureTopology() {
        if (this.topology != null && this.topology.getSequenceNumber() >= this.latestStateInfo.get().topoSequenceNumber && System.currentTimeMillis() - this.lastValidationTimeMs < validationPeriodMs) {
            return true;
        }
        this.lastValidationTimeMs = System.currentTimeMillis();
        if (this.topology == null) {
            this.logger.info("Acquiring initial topology from RNs");
        }
        LinkedList<RepNodeId> topoRNs = new LinkedList<RepNodeId>(this.getActiveRNs());
        MasterBalancingInterface.StateInfo si = this.latestStateInfo.get();
        RepNodeId topoRnId = si.rnId;
        int topoSeqNum = si.topoSequenceNumber;
        if (topoRnId != null) {
            topoRNs.remove(topoRnId);
            topoRNs.add(0, topoRnId);
        }
        for (RepNodeId rnId : topoRNs) {
            try {
                Topology newTopology;
                RepNodeAdminAPI topoRn = RegistryUtils.getRepNodeAdmin(this.snInfo.storename, this.snInfo.snHostname, this.snInfo.snRegistryPort, topoRnId, this.loginMgr);
                int rnTopoSeqNum = topoRn.getTopoSeqNum();
                if (this.topology != null && this.topology.getSequenceNumber() >= rnTopoSeqNum || (newTopology = topoRn.getTopology()) == null || newTopology.getSequenceNumber() < topoSeqNum) continue;
                int topoVersion = newTopology.getVersion();
                if (topoVersion == 0) {
                    this.logger.warning("Ignoring r1 topology from: " + rnId);
                    continue;
                }
                this.topology = newTopology;
                MasterBalancingInterface.StateInfo newStateInfo = new MasterBalancingInterface.StateInfo(rnId, null, newTopology.getSequenceNumber());
                this.noteLatestTopo(newStateInfo);
                this.rnCount = 0;
                for (RepNodeId id : this.topology.getRepNodeIds()) {
                    RepNode rn = this.topology.get(id);
                    if (!rn.getStorageNodeId().equals(this.snInfo.snId)) continue;
                    ++this.rnCount;
                }
                this.logger.info("Topology acquired from RN: " + rnId + " Topo seq#: " + newTopology.getSequenceNumber());
                return true;
            }
            catch (RemoteException e) {
            }
            catch (NotBoundException e) {
            }
        }
        return this.topology != null;
    }

    int getRnCount() {
        assert (this.topology != null);
        return this.rnCount;
    }

    void shutdown() {
        this.shutdown.set(true);
    }
}

