/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import java.util.logging.Logger;
import oracle.kv.impl.sna.masterBalance.LeaseManager;
import oracle.kv.impl.topo.RepNodeId;

public class ReplicaLeaseManager
extends LeaseManager {
    ReplicaLeaseManager(Logger logger) {
        super(logger);
    }

    synchronized void getReplicaLease(ReplicaLease lease) {
        RepNodeId rnId = lease.getRepNodeId();
        LeaseManager.LeaseTask leaseTask = (LeaseManager.LeaseTask)this.leaseTasks.get(rnId);
        if (leaseTask != null) {
            leaseTask.cancel();
            leaseTask = null;
        }
        leaseTask = new LeaseManager.LeaseTask(lease);
        this.logger.info("Established replica lease:" + lease);
    }

    static class ReplicaLease
    implements LeaseManager.Lease {
        private final RepNodeId rnId;
        private final int leaseDurationMs;

        ReplicaLease(RepNodeId rnId, int leaseDurationMs) {
            this.rnId = rnId;
            this.leaseDurationMs = leaseDurationMs;
        }

        public String toString() {
            return String.format("Replica lease: %s, duration: %d ms", this.rnId.getFullName(), this.leaseDurationMs);
        }

        @Override
        public RepNodeId getRepNodeId() {
            return this.rnId;
        }

        @Override
        public int getLeaseDuration() {
            return this.leaseDurationMs;
        }
    }
}

