/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgent;

public class ThreadServiceManager
extends ServiceManager
implements Runnable {
    private Thread thread;

    public ThreadServiceManager(StorageNodeAgent sna, ManagedService service) {
        super(sna, service);
    }

    @Override
    public void run() {
        String[] args = this.service.createArgs();
        ManagedService.main(args);
        this.logger.info("Thread returning for service " + this.service.getServiceName());
    }

    @Override
    public void start() throws Exception {
        this.thread = new Thread(this);
        this.thread.start();
        this.logger.fine("ThreadServiceManager started thread");
        this.notifyStarted();
    }

    @Override
    public void stop() {
        this.thread.interrupt();
        this.waitFor(0);
    }

    @Override
    public void waitFor(int millis) {
        try {
            this.thread.join(millis);
            if (this.thread.isAlive()) {
                this.logger.info("Thread join timed out for " + this.service.getServiceName() + ", timeout millis: " + millis);
            } else {
                this.logger.info("Joined thread for " + this.service.getServiceName());
            }
        }
        catch (InterruptedException ie) {
            this.logger.info("Thread wait for service was interrupted");
        }
    }

    @Override
    public void dontRestart() {
    }

    @Override
    public boolean isRunning() {
        return this.thread != null;
    }
}

