/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.mgmt.MgmtAgent;
import oracle.kv.impl.mgmt.MgmtAgentFactory;
import oracle.kv.impl.mgmt.jmx.JmxAgent;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.param.ParameterTracker;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.TrustedLoginHandler;
import oracle.kv.impl.security.login.TrustedLoginImpl;
import oracle.kv.impl.sna.ManagedAdmin;
import oracle.kv.impl.sna.ManagedBootstrapAdmin;
import oracle.kv.impl.sna.ManagedRepNode;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.MonitorAgentImpl;
import oracle.kv.impl.sna.ProcessMonitor;
import oracle.kv.impl.sna.ProcessServiceManager;
import oracle.kv.impl.sna.SNAFaultException;
import oracle.kv.impl.sna.SNAFaultHandler;
import oracle.kv.impl.sna.SNASecurity;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeAgentImpl;
import oracle.kv.impl.sna.StorageNodeAgentInterface;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.sna.ThreadServiceManager;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManager;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManagerInterface;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.FileUtils;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.ServiceUtils;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.ServerSocketFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public final class StorageNodeAgent {
    public static final String START_COMMAND_NAME = "start";
    public static final String START_COMMAND_DESC = "starts StorageNodeAgent (and if configured, store) in kvroot";
    public static final String STOP_COMMAND_NAME = "stop";
    public static final String STOP_COMMAND_DESC = "stops StorageNodeAgent and services related to kvroot";
    public static final String RESTART_COMMAND_NAME = "restart";
    public static final String RESTART_COMMAND_DESC = "combines stop and start commands into one";
    public static final String CONFIG_FLAG = "-config";
    public static final String COMMAND_ARGS = CommandParser.getRootUsage() + " " + CommandParser.optional("-config <bootstrapFileName>");
    public static final String DEFAULT_CONFIG_FILE = "config.xml";
    public static final String DEFAULT_SECURITY_DIR = "security";
    public static final String DEFAULT_SECURITY_FILE = "security.xml";
    public static final String SHUTDOWN_FLAG = "-shutdown";
    public static final String THREADS_FLAG = "-threads";
    public static final String LINK_COMMAND = "ln";
    private final StorageNodeAgentImpl snai;
    private StorageNodeAgentInterface exportableSnaif;
    private String bootstrapDir;
    private String bootstrapFile;
    private File securityDir;
    private String securityConfigFile;
    private BootstrapParams bp;
    private SecurityParams sp;
    private File kvRoot;
    private File snRoot;
    private File kvConfigPath;
    private Registry registry;
    private String snaName;
    private StorageNodeId snid;
    private int serviceWaitMillis;
    private int repnodeWaitSecs;
    private int maxLink;
    private int linkExecWaitSecs;
    private boolean isWindows;
    private Boolean isLoopback;
    private boolean isVerbose;
    int capacity;
    int logFileLimit;
    int logFileCount;
    int numCPUs;
    int memoryMB;
    String mountPointsString;
    private boolean createBootstrapAdmin;
    private ServiceStatusTracker statusTracker;
    private boolean useThreads;
    private Logger logger;
    private final Map<String, ServiceManager> repNodeServices;
    private ServiceManager adminService;
    private MonitorAgentImpl monitorAgent;
    private MgmtAgent mgmtAgent;
    private TrustedLoginImpl trustedLogin;
    private SNASecurity snaSecurity;
    private final ParameterTracker snParameterTracker;
    private final ParameterTracker globalParameterTracker;
    private MasterBalanceManagerInterface masterBalanceManager;
    private String customProcessStartupPrefix;
    private TestHook<StorageNodeAgent> restartRNHook;
    private TestHook<StorageNodeAgent> restartAdminHook;
    private TestHook<StorageNodeAgent> stopRNHook;
    public static TestHook<Integer> FAULT_HOOK;
    private static TestHook<StorageNodeAgent> mbmPostShutdownHook;

    StorageNodeAgent(StorageNodeAgentImpl snai, boolean createBootstrapAdmin) {
        this.snai = snai;
        this.bootstrapDir = null;
        this.bootstrapFile = null;
        this.securityDir = null;
        this.securityConfigFile = null;
        this.kvRoot = null;
        this.snRoot = null;
        this.kvConfigPath = null;
        this.registry = null;
        this.snaName = "snaService";
        this.snid = new StorageNodeId(0);
        this.logger = null;
        this.statusTracker = null;
        this.mgmtAgent = null;
        this.useThreads = false;
        this.createBootstrapAdmin = createBootstrapAdmin;
        this.isLoopback = null;
        this.snParameterTracker = new ParameterTracker();
        this.globalParameterTracker = new ParameterTracker();
        this.repNodeServices = new HashMap<String, ServiceManager>();
        this.adminService = null;
        String os = System.getProperty("os.name");
        this.isWindows = os.indexOf("Windows") != -1;
    }

    MasterBalanceManagerInterface getMasterBalanceManager() {
        return this.masterBalanceManager;
    }

    void setRNTestHook(TestHook<StorageNodeAgent> hook) {
        this.restartRNHook = hook;
    }

    void setStopRNTestHook(TestHook<StorageNodeAgent> hook) {
        this.stopRNHook = hook;
    }

    void setAdminTestHook(TestHook<StorageNodeAgent> hook) {
        this.restartAdminHook = hook;
    }

    public static void setMBMPostShutdownHook(TestHook<StorageNodeAgent> mbmPostShutdownHook) {
        StorageNodeAgent.mbmPostShutdownHook = mbmPostShutdownHook;
    }

    void setRepNodeWaitSecs(int seconds) {
        this.repnodeWaitSecs = seconds;
    }

    boolean parseArgs(String[] args) {
        SNAParser parser = new SNAParser(args);
        parser.parseArgs();
        this.bootstrapDir = parser.getRootDir();
        return parser.getShutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean stopRunningAgent() {
        File configPath = new File(this.bootstrapDir, this.bootstrapFile);
        this.bp = ConfigUtils.getBootstrapParams(configPath, this.logger);
        String relSecurityDir = this.bp.getSecurityDir();
        if (relSecurityDir != null) {
            this.securityDir = new File(this.bootstrapDir, relSecurityDir);
            File securityConfigPath = new File(this.securityDir, this.securityConfigFile);
            if (!securityConfigPath.exists()) {
                System.err.println("Configuration declares that security should be present, but it was not found at " + securityConfigPath);
                return false;
            }
            this.sp = ConfigUtils.getSecurityParams(securityConfigPath, this.logger);
        } else {
            this.securityDir = null;
            this.sp = SecurityParams.makeDefault();
        }
        this.sp.initRMISocketPolicies();
        BootstrapParams.initRegistryCSF(this.sp);
        this.snaSecurity = new SNASecurity(this, this.bp, this.sp, null, null, this.logger);
        StorageNodeAgentAPI snai1 = null;
        try {
            if (this.bp.getStoreName() != null) {
                StorageNodeId snid1 = new StorageNodeId(this.bp.getId());
                String bn = RegistryUtils.bindingName(this.bp.getStoreName(), snid1.getFullName(), RegistryUtils.InterfaceType.MAIN);
                snai1 = RegistryUtils.getStorageNodeAgent(this.bp.getHostname(), this.bp.getRegistryPort(), bn, this.getLoginManager());
            } else {
                snai1 = RegistryUtils.getStorageNodeAgent(this.bp.getHostname(), this.bp.getRegistryPort(), "snaService", this.getLoginManager());
            }
            snai1.shutdown(true, false);
            return true;
        }
        catch (RemoteException re) {
            System.err.println("Exception shutting down Storage Node Agent: " + re.getMessage());
            return false;
        }
        catch (NotBoundException nbe) {
            System.err.println("Unable to contact Storage Node Agent: " + nbe.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void start() throws RemoteException {
        this.logger = LoggerUtils.getBootstrapLogger(this.bootstrapDir, "snaboot", this.snaName);
        this.statusTracker = new ServiceStatusTracker(this.logger);
        this.statusTracker.update(ConfigurableService.ServiceStatus.STARTING);
        File configPath = new File(this.bootstrapDir, this.bootstrapFile);
        this.logger.info("Starting, configuration file: " + configPath);
        this.bp = ConfigUtils.getBootstrapParams(configPath, this.logger);
        String relSecDir = this.bp.getSecurityDir();
        if (relSecDir != null) {
            this.securityDir = new File(this.bootstrapDir, relSecDir);
            File securityConfigPath = new File(this.securityDir, this.securityConfigFile);
            if (!securityConfigPath.exists()) {
                this.securityDir = null;
                this.logger.log(Level.SEVERE, "Configuration declares that security should be present, but it was not found at " + securityConfigPath);
                throw new IllegalStateException("Unable to continue without security.");
            }
            this.logger.info("Loading security configuration: " + securityConfigPath);
            this.sp = ConfigUtils.getSecurityParams(securityConfigPath, this.logger);
        } else {
            this.securityDir = null;
            this.sp = SecurityParams.makeDefault();
        }
        this.sp.initRMISocketPolicies();
        KVVersion previousVersion = this.bp.getSoftwareVersion();
        assert (previousVersion != null);
        boolean updateConfigFile = false;
        if (!previousVersion.equals(KVVersion.CURRENT_VERSION)) {
            VersionUtil.checkUpgrade(previousVersion);
            this.logger.log(Level.INFO, "Upgrade software version from version {0} to {1}", new Object[]{previousVersion.getNumericVersionString(), KVVersion.CURRENT_VERSION.getNumericVersionString()});
            this.bp.setSoftwareVersion(KVVersion.CURRENT_VERSION);
            updateConfigFile = true;
        }
        if (this.bp.getRootdir() == null) {
            this.bp.setRootdir(this.bootstrapDir);
            updateConfigFile = true;
        }
        if (updateConfigFile) {
            ConfigUtils.createBootstrapConfig(this.bp, configPath);
        }
        this.kvRoot = new File(this.bp.getRootdir());
        try {
            this.startup();
        }
        catch (RemoteException e) {
            this.cleanupRegistry();
            throw e;
        }
        if (this.sp.isSecure()) {
            LoginUpdater loginUpdater = new LoginUpdater();
            loginUpdater.addGlobalParamsUpdaters(this.snaSecurity);
            loginUpdater.addServiceParamsUpdaters(this.snaSecurity);
            if (this.trustedLogin != null) {
                loginUpdater.addGlobalParamsUpdaters(this.trustedLogin);
                loginUpdater.addServiceParamsUpdaters(this.trustedLogin);
            }
            this.snParameterTracker.addListener(loginUpdater.new LoginUpdater.ServiceParamsListener());
            this.globalParameterTracker.addListener(loginUpdater.new LoginUpdater.GlobalParamsListener());
        }
    }

    public void resetRMISocketPolicies() {
        this.sp.initRMISocketPolicies();
        if (this.isRegistered()) {
            StorageNodeParams snp = ConfigUtils.getStorageNodeParams(this.kvConfigPath, this.logger);
            snp.setRegistryCSF(this.sp);
        } else {
            BootstrapParams.initRegistryCSF(this.sp);
        }
    }

    private void startup() throws RemoteException {
        if (this.kvRoot.exists() && this.isRegistered()) {
            this.startupRegistered();
        } else {
            this.startupUnregistered();
        }
    }

    private void logwarning(String msg, Exception e) {
        this.logger.log(Level.WARNING, msg, e);
    }

    private void logsevere(String msg, Exception e) {
        this.logger.log(Level.SEVERE, msg, e);
    }

    private void revertToBootstrap() {
        try {
            File configPath = new File(this.bootstrapDir, this.bootstrapFile);
            this.bp.setStoreName(null);
            this.bp.setHostingAdmin(false);
            this.bp.setId(1);
            ConfigUtils.createBootstrapConfig(this.bp, configPath);
            this.snaName = "snaService";
            this.snid = new StorageNodeId(0);
        }
        catch (Exception e) {
            this.logsevere("Cannot revert to bootstrap configuration", e);
            throw new IllegalStateException(e);
        }
    }

    private void startupUnregistered() throws RemoteException {
        this.registry = this.createRegistry(null);
        BootstrapParams.initRegistryCSF(this.sp);
        this.snaSecurity = new SNASecurity(this, this.bp, this.sp, null, null, this.logger);
        this.bindUnregisteredSNA();
        this.bindUnregisteredTrustedLogin();
        this.mgmtAgent = MgmtAgentFactory.getAgent(this, null, this.statusTracker);
        this.capacity = this.bp.getCapacity();
        this.numCPUs = this.bp.getNumCPUs();
        this.memoryMB = this.bp.getMemoryMB();
        this.mountPointsString = StorageNodeAgent.joinStringList(this.bp.getMountPoints(), ",");
        this.snai.getFaultHandler().setLogger(this.logger);
        ManagedService.killManagedProcesses(this.getStoreName(), this.makeBootstrapAdminName(), this.getLogger());
        ManagedService.killManagedProcesses(this.bootstrapDir, this.bootstrapFile, this.getLogger());
        this.startBootstrapAdmin();
        this.statusTracker.update(ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY);
    }

    private synchronized void startupRegistered() throws RemoteException {
        this.initStorePaths();
        this.logger.info("Registered startup, config file: " + this.kvConfigPath);
        StorageNodeParams snp = null;
        GlobalParams gp = null;
        try {
            snp = ConfigUtils.getStorageNodeParams(this.kvConfigPath, this.logger);
            gp = ConfigUtils.getGlobalParams(this.kvConfigPath, this.logger);
        }
        catch (IllegalStateException e) {
            this.logger.info("Exception reading config file: " + e.getMessage());
        }
        if (snp == null || gp == null) {
            this.logger.info("Could not get required parameters, reverting to unregistered state");
            this.revertToBootstrap();
            this.cleanupRegistry();
            this.start();
            return;
        }
        this.setupMonitoring(gp, snp);
        this.logger.info("Changing log files to directory: " + FileNames.getLoggingDir(this.kvRoot, this.getStoreName()));
        this.logger = LoggerUtils.getLogger(StorageNodeAgentImpl.class, gp, snp);
        this.snai.getFaultHandler().setLogger(this.logger);
        this.snaSecurity = new SNASecurity(this, this.bp, this.sp, gp, snp, this.logger);
        ClientSocketFactory.setTimeoutLogger(this.logger);
        this.logger.info("Starting StorageNodeAgent for " + this.getStoreName());
        this.statusTracker.setLogger(this.logger);
        if (this.registry == null) {
            this.registry = this.createRegistry(snp);
        }
        this.snid = snp.getStorageNodeId();
        JmxAgent.setRMISocketPolicy(this.sp.getRMISocketPolicy());
        this.initSNParams(snp);
        snp.setRegistryCSF(this.sp);
        this.snai.startTestInterface();
        this.cleanupRunningComponents();
        RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), "SNA:" + (Object)((Object)RegistryUtils.InterfaceType.TRUSTED_LOGIN), this.trustedLogin);
        this.bindRegisteredTrustedLogin(gp, snp);
        this.startMasterBalanceManager(snp.getMasterBalance());
        this.startComponents();
        this.monitorAgent.startup();
        RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), this.snaName, this.exportableSnaif);
        this.snaName = this.snid.getFullName();
        this.bindRegisteredSNA(snp);
        this.statusTracker.update(ConfigurableService.ServiceStatus.RUNNING);
        if (this.adminService != null) {
            this.adminService.registered(this);
        }
        this.logger.info("Started StorageNodeAgent for " + this.getStoreName());
    }

    private void bindUnregisteredSNA() throws RemoteException {
        RMISocketPolicy policy = this.sp.getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = this.bp.getStorageNodeAgentSFP(policy);
        this.initExportableSnaif();
        RegistryUtils.rebind(this.getHostname(), this.getRegistryPort(), this.snaName, this.exportableSnaif, sfp.getClientFactory(), sfp.getServerFactory());
        this.logger.info("Bound to registry port " + this.getRegistryPort() + " using name " + this.snaName + " with SSF:" + sfp.getServerFactory());
    }

    private void bindUnregisteredTrustedLogin() throws RemoteException {
        RMISocketPolicy trustedPolicy = this.sp.getTrustedRMISocketPolicy();
        if (trustedPolicy != null) {
            RMISocketPolicy.SocketFactoryPair tsfp = this.bp.getSNATrustedLoginSFP(trustedPolicy);
            String snaTLName = "SNA:TRUSTED_LOGIN";
            SNAFaultHandler faultHandler = new SNAFaultHandler(this.logger);
            TrustedLoginHandler loginHandler = new TrustedLoginHandler(this.snid, true);
            this.trustedLogin = new TrustedLoginImpl(faultHandler, loginHandler, this.logger);
            RegistryUtils.rebind(this.getHostname(), this.getRegistryPort(), "SNA:TRUSTED_LOGIN", this.trustedLogin, tsfp.getClientFactory(), tsfp.getServerFactory());
            this.logger.info("Bound trusted login to registry port " + this.getRegistryPort() + " using name " + "SNA:TRUSTED_LOGIN" + " with SSF:" + tsfp.getServerFactory());
        }
    }

    private void bindRegisteredSNA(StorageNodeParams snp) throws RemoteException {
        String csfName = ClientSocketFactory.factoryName(this.getStoreName(), StorageNodeId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
        RMISocketPolicy rmiPolicy = this.sp.getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = snp.getStorageNodeAdminSFP(rmiPolicy, csfName);
        this.initExportableSnaif();
        RegistryUtils.rebind(this.getHostname(), this.getRegistryPort(), this.getStoreName(), this.snaName, RegistryUtils.InterfaceType.MAIN, this.exportableSnaif, sfp.getClientFactory(), sfp.getServerFactory());
        this.logger.info("Rebound to registry port " + this.getRegistryPort() + " using name " + this.snaName + " with SSF:" + sfp.getServerFactory());
    }

    private void bindRegisteredTrustedLogin(GlobalParams gp, StorageNodeParams snp) throws RemoteException {
        RMISocketPolicy trustedPolicy = this.sp.getTrustedRMISocketPolicy();
        if (trustedPolicy != null) {
            RMISocketPolicy.SocketFactoryPair tsfp = this.bp.getSNATrustedLoginSFP(trustedPolicy);
            SNAFaultHandler faultHandler = new SNAFaultHandler(this.logger);
            long sessionTimeout = gp.getSessionTimeoutUnit().toMillis(gp.getSessionTimeout());
            int sessionLimit = snp.getSessionLimit();
            TrustedLoginHandler loginHandler = new TrustedLoginHandler(this.snid, false, sessionTimeout, sessionLimit);
            String snaTLName = "SNA:TRUSTED_LOGIN";
            this.trustedLogin = new TrustedLoginImpl(faultHandler, loginHandler, this.logger);
            RegistryUtils.rebind(this.getHostname(), this.getRegistryPort(), "SNA:TRUSTED_LOGIN", this.trustedLogin, tsfp.getClientFactory(), tsfp.getServerFactory());
            this.logger.info("Bound trusted login to registry port " + this.getRegistryPort() + " using name " + "SNA" + " with SSF:" + tsfp.getServerFactory());
        }
    }

    void checkRegistered(String method) throws IllegalStateException {
        if (this.getStoreName() == null) {
            throw new IllegalStateException(method + ": Storage Node Agent is not registered");
        }
    }

    private void initExportableSnaif() {
        try {
            this.exportableSnaif = SecureProxy.create(this.snai, this.snaSecurity.getAccessChecker(), this.snai.getFaultHandler());
            this.logger.info("Successfully created secure proxy for the storage node agent");
        }
        catch (ConfigurationException ce) {
            throw new IllegalStateException("Unabled to create proxy", ce);
        }
    }

    private StorageNodeAgentImpl getImpl() {
        return this.snai;
    }

    StorageNodeStatus getStatus() {
        return new StorageNodeStatus(this.statusTracker.getServiceStatus());
    }

    MonitorAgentImpl getMonitorAgent() {
        return this.monitorAgent;
    }

    private File initStorePaths() {
        File kvDir = FileNames.getKvDir(this.kvRoot.toString(), this.getStoreName());
        StorageNodeId id = new StorageNodeId(this.bp.getId());
        this.snRoot = FileNames.getStorageNodeDir(kvDir, id);
        this.kvConfigPath = FileNames.getSNAConfigFile(this.kvRoot.toString(), this.getStoreName(), id);
        return kvDir;
    }

    private void ensureStoreDirectory() {
        File javaSecPolicy;
        File kvDir = this.initStorePaths();
        if (!this.snRoot.isDirectory() && FileNames.makeDir(this.snRoot)) {
            this.logger.info("Created a new store directory: " + this.snRoot);
        }
        if (!(javaSecPolicy = FileNames.getSecurityPolicyFile(kvDir)).exists()) {
            this.logger.fine("Creating security policy file: " + javaSecPolicy);
            File fromFile = new File(this.bootstrapDir, "security.policy");
            if (!fromFile.exists()) {
                throw new IllegalStateException("Cannot find bootstrap security file " + fromFile);
            }
            try {
                FileUtils.copyFile(fromFile, javaSecPolicy);
            }
            catch (IOException ie) {
                throw new IllegalStateException("Could not create policy file", ie);
            }
        }
    }

    protected Registry getRegistry() {
        return this.registry;
    }

    public int getRegistryPort() {
        return this.bp.getRegistryPort();
    }

    public String getServiceName() {
        return this.snaName;
    }

    public StorageNodeId getStorageNodeId() {
        return this.snid;
    }

    protected int getServiceWaitMillis() {
        return this.serviceWaitMillis;
    }

    protected int getRepnodeWaitSecs() {
        return this.repnodeWaitSecs;
    }

    protected int getMaxLink() {
        return this.maxLink;
    }

    protected int getLinkExecWaitSecs() {
        return this.linkExecWaitSecs;
    }

    private Registry createRegistry(StorageNodeParams snp) throws RemoteException {
        System.setProperty("java.rmi.server.hostname", this.getHostname());
        RMISocketPolicy rmiPolicy = this.sp.getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = snp == null ? StorageNodeParams.getDefaultRegistrySFP(rmiPolicy) : snp.getRegistrySFP(rmiPolicy);
        ServerSocketFactory ssf = sfp.getServerFactory();
        this.logger.info("Creating a Registry on port " + this.getHostname() + ":" + this.getRegistryPort() + " server socket factory:" + ssf);
        ExportException throwEE = null;
        int limitMs = 128000;
        int retryPeriodMs = 1000;
        for (int totalWaitMs = 0; totalWaitMs <= 128000; totalWaitMs += 1000) {
            try {
                throwEE = null;
                return LocateRegistry.createRegistry(this.getRegistryPort(), null, ssf);
            }
            catch (ExportException ee) {
                throwEE = ee;
                if (TestStatus.isActive() && ee.getCause() instanceof BindException) {
                    this.logger.info("Registry bind exception:" + ee.getCause().getMessage() + " Registry port:" + this.getRegistryPort());
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw throwEE;
                    }
                }
                throw throwEE;
            }
        }
        throw throwEE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRegistry() {
        try {
            if (this.isRegistered()) {
                RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), "SNA:TRUSTED_LOGIN", this.trustedLogin);
                RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), this.getStoreName(), this.snaName, RegistryUtils.InterfaceType.MAIN, this.exportableSnaif);
                if (this.monitorAgent != null) {
                    this.monitorAgent.stop();
                }
                this.snai.stopTestInterface();
            } else {
                try {
                    RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), "SNA:TRUSTED_LOGIN", this.trustedLogin);
                    RegistryUtils.unbind(this.getHostname(), this.getRegistryPort(), this.snaName, this.exportableSnaif);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.registry = null;
        }
    }

    private void setSystemInfo() {
        int mb;
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        this.logger.info("System architecture is " + bean.getArch());
        int ncpu = this.bp.getNumCPUs();
        if (ncpu == 0) {
            ncpu = bean.getAvailableProcessors();
            this.logger.info("Setting number of CPUs to " + ncpu);
            this.bp.setNumCPUs(ncpu);
        }
        if (!this.useThreads && !TestStatus.manyRNs() && (mb = this.bp.getMemoryMB()) == 0) {
            long bytes = this.getTotalPhysicalMemorySize(bean);
            if (bytes != 0L) {
                mb = (int)(bytes >> 20);
                this.logger.info("Setting memory MB to " + mb);
                this.bp.setMemoryMB(mb);
            } else {
                this.logger.info("Cannot get memory size");
            }
        }
    }

    private long getTotalPhysicalMemorySize(OperatingSystemMXBean bean) {
        Class<?> beanClass = bean.getClass();
        try {
            int cap;
            int maxInt = Integer.MAX_VALUE;
            Method m = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            long mem = (Long)m.invoke((Object)bean, new Object[0]);
            String bits = System.getProperty("sun.arch.data.model");
            if (bits == null) {
                return mem;
            }
            int intBits = Integer.parseInt(bits);
            if (intBits == 32 && mem / (long)(cap = this.bp.getCapacity()) > Integer.MAX_VALUE) {
                this.logger.info("Reducing total memory from " + mem + " to " + Integer.MAX_VALUE * cap + " bytes");
                mem = Integer.MAX_VALUE * cap;
            }
            return mem;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    void addShutdownHook() {
        if (this.logger != null) {
            this.logger.fine("Adding shutdown hook");
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
    }

    public BootstrapParams getBootstrapParams() {
        return this.bp;
    }

    public String getStoreName() {
        return this.bp.getStoreName();
    }

    public String getHostname() {
        return this.bp.getHostname();
    }

    public String getHAHostname() {
        return this.bp.getHAHostname();
    }

    boolean isLoopbackAddress() {
        if (this.isLoopback == null) {
            this.isLoopback = StorageNodeAgent.checkLoopback(this.getHAHostname());
        }
        return this.isLoopback;
    }

    public String getHAPortRange() {
        return this.bp.getHAPortRange();
    }

    public String getServicePortRange() {
        return this.bp.getServicePortRange();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getBootstrapDir() {
        return this.bootstrapDir;
    }

    public String getBootstrapFile() {
        return this.bootstrapFile;
    }

    public File getSecurityDir() {
        return this.securityDir;
    }

    public String getSecurityConfigFile() {
        return this.securityConfigFile;
    }

    public File getKvConfigFile() {
        return this.kvConfigPath;
    }

    String getCustomProcessStartupPrefix() {
        return this.customProcessStartupPrefix;
    }

    boolean verbose() {
        return this.isVerbose;
    }

    boolean isRunning(RepNodeId rnid) {
        ServiceManager mgr = this.repNodeServices.get(rnid.getFullName());
        if (mgr != null) {
            return mgr.isRunning();
        }
        return false;
    }

    ServiceManager getServiceManager(RepNodeId rnid) {
        return this.repNodeServices.get(rnid.getFullName());
    }

    public static boolean checkLoopback(String host) {
        InetSocketAddress isa = new InetSocketAddress(host, 0);
        return isa.getAddress().isLoopbackAddress();
    }

    private void startComponents() {
        AdminParams ap;
        List<ParameterMap> repNodes = ConfigUtils.getRepNodes(this.kvConfigPath, this.logger);
        for (ParameterMap map : repNodes) {
            RepNodeParams rn = new RepNodeParams(map);
            if (!rn.isDisabled()) {
                this.startRepNodeInternal(rn);
                continue;
            }
            this.logger.info(rn.getRepNodeId().getFullName() + ": Skipping automatic start of stopped RepNode ");
        }
        if (this.adminService == null && (ap = ConfigUtils.getAdminParams(this.kvConfigPath, this.logger)) != null && !ap.isDisabled()) {
            this.startAdminInternal(ap, this.bp.isHostingAdmin());
        }
    }

    private boolean stopAdminService(boolean stopService, boolean force) {
        if (this.adminService == null) {
            return false;
        }
        boolean stopped = false;
        String serviceName = this.adminService.getService().getServiceName();
        try {
            this.logger.info(serviceName + ": Stopping AdminService");
            this.adminService.dontRestart();
            if (stopService && !this.adminService.forceOK(force)) {
                CommandServiceAPI admin = ServiceUtils.waitForAdmin(this.getHostname(), this.getRegistryPort(), this.getLoginManager(), 5L, ConfigurableService.ServiceStatus.RUNNING);
                admin.stop(force);
                this.adminService.waitFor(this.serviceWaitMillis);
                stopped = true;
            }
        }
        catch (Exception e) {
            this.logwarning("Exception stopping Admin service", e);
        }
        if (!stopped) {
            this.adminService.stop();
        }
        this.logger.info(serviceName + ": Stopped AdminService");
        this.unbindService("commandService");
        this.unbindService("admin:LOGIN");
        this.mgmtAgent.removeAdmin();
        this.adminService = null;
        return true;
    }

    private void stopRepNodeServices(boolean stopService, boolean force) {
        for (ServiceManager mgr : this.repNodeServices.values()) {
            try {
                mgr.dontRestart();
                if (mgr.forceOK(force)) {
                    mgr.stop();
                } else {
                    ManagedRepNode mrn = (ManagedRepNode)mgr.getService();
                    if (stopService) {
                        RepNodeAdminAPI rna;
                        if (mgr.isRunning() && (rna = mrn.waitForRepNodeAdmin(this, 5)) != null) {
                            rna.shutdown(force);
                        }
                        mgr.waitFor(this.serviceWaitMillis);
                    }
                }
            }
            catch (Exception e) {
                this.logwarning(mgr.getService().getServiceName() + ": Exception stopping RepNode", e);
                mgr.stop();
            }
            this.unbindService(this.makeRepNodeBindingName(mgr.getService().getServiceName()));
        }
        this.repNodeServices.clear();
    }

    private String makeRepNodeBindingName(String fullName) {
        return RegistryUtils.bindingName(this.getStoreName(), fullName, RegistryUtils.InterfaceType.ADMIN);
    }

    private void unbindService(String serviceName) {
        try {
            this.registry.unbind(serviceName);
        }
        catch (NotBoundException nbe) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void startMasterBalanceManager(boolean enabled) {
        this.stopMasterBalanceManager();
        MasterBalanceManager.SNInfo snInfo = new MasterBalanceManager.SNInfo(this.getStoreName(), this.snid, this.getHostname(), this.getRegistryPort());
        this.masterBalanceManager = MasterBalanceManager.create(enabled, snInfo, this.logger, this.getLoginManager());
    }

    private void stopMasterBalanceManager() {
        if (this.masterBalanceManager == null) {
            return;
        }
        this.masterBalanceManager.shutdown();
    }

    private void cleanupRunningComponents() {
        AdminParams ap;
        List<ParameterMap> repNodes = ConfigUtils.getRepNodes(this.kvConfigPath, this.logger);
        for (ParameterMap map : repNodes) {
            RepNodeParams rn = new RepNodeParams(map);
            ManagedService.killManagedProcesses(this.getStoreName(), rn.getRepNodeId().getFullName(), this.getLogger());
        }
        if (this.adminService == null) {
            ManagedService.killManagedProcesses(this.getStoreName(), this.makeBootstrapAdminName(), this.getLogger());
        }
        if ((ap = ConfigUtils.getAdminParams(this.kvConfigPath, this.logger)) != null) {
            ManagedService.killManagedProcesses(this.getStoreName(), ap.getAdminId().getFullName(), this.getLogger());
        }
    }

    private File validateRepNodeDirectory(RepNodeParams rnp) {
        File mp = rnp.getMountPoint();
        if (mp != null) {
            if (!mp.isDirectory()) {
                String msg = "Directory specified for RepNode is either not present or is not a directory: " + mp.getAbsoluteFile();
                this.logger.info(msg);
                throw new IllegalArgumentException(msg);
            }
            return mp;
        }
        return null;
    }

    private boolean startRepNodeInternal(RepNodeParams rnp) {
        RepNodeId rnid = rnp.getRepNodeId();
        String serviceName = rnid.getFullName();
        this.logger.info(serviceName + ": Starting RepNode");
        try {
            File repNodeDir = this.validateRepNodeDirectory(rnp);
            ManagedRepNode ms = new ManagedRepNode(this.sp, rnp, this.kvRoot, this.snRoot, this.getStoreName());
            ServiceManager mgr = this.repNodeServices.get(serviceName);
            if (mgr != null) {
                boolean isRunning = mgr.isRunning();
                if (isRunning) {
                    this.logger.info(serviceName + ": Attempt to start a running RepNode.");
                    return true;
                }
                this.logger.info(serviceName + " exists but is not runnable." + "  Attempt to stop it and restart.");
                this.stopRepNode(rnid, true);
                return this.startRepNode(rnid);
            }
            mgr = this.useThreads ? new ThreadServiceManager(this, ms) : new ProcessServiceManager(this, ms);
            this.checkForRecovery(rnid, repNodeDir);
            this.mgmtAgent.addRepNode(rnp, mgr);
            mgr.start();
            this.repNodeServices.put(serviceName, mgr);
            this.logger.info(serviceName + ": Started RepNode");
        }
        catch (Exception e) {
            this.logsevere(serviceName + ": Exception starting RepNode", e);
            return false;
        }
        return true;
    }

    public RepNodeAdminAPI waitForRepNodeAdmin(RepNodeId rnid, ConfigurableService.ServiceStatus[] targets) {
        return this.waitForRepNodeAdmin(rnid, targets, this.repnodeWaitSecs);
    }

    private RepNodeAdminAPI waitForRepNodeAdmin(RepNodeId rnid, ConfigurableService.ServiceStatus[] targets, int waitSecs) {
        RepNodeAdminAPI rnai = null;
        try {
            rnai = ServiceUtils.waitForRepNodeAdmin(this.getStoreName(), this.getHostname(), this.getRegistryPort(), rnid, this.snid, this.getLoginManager(), waitSecs, targets);
        }
        catch (Exception e) {
            File logDir = FileNames.getLoggingDir(this.kvRoot, this.getStoreName());
            String logName = logDir + File.separator + rnid.toString() + "*.log";
            String msg = "Failed to attach to RepNodeService for " + rnid + " after waiting " + waitSecs + " seconds; see log, " + logName + ", on host " + this.getHostname() + " for more information.";
            this.logsevere(msg, e);
            RegistryUtils.checkForStartupProblem(this.getStoreName(), this.getHostname(), this.getRegistryPort(), rnid, this.snid, this.getLoginManager());
            return null;
        }
        return rnai;
    }

    public CommandServiceAPI waitForAdmin(ConfigurableService.ServiceStatus target, int timeoutSecs) {
        CommandServiceAPI cs = null;
        try {
            cs = ServiceUtils.waitForAdmin(this.getHostname(), this.getRegistryPort(), this.getLoginManager(), timeoutSecs, target);
        }
        catch (Exception e) {
            String msg = "Failed to attach to AdminService for after waiting " + this.repnodeWaitSecs + " seconds.";
            this.logger.severe(msg);
            throw new IllegalStateException(msg, e);
        }
        return cs;
    }

    void removeDataDir(ResourceId rid) {
        File dataDir = FileNames.getServiceDir(this.kvRoot.toString(), this.getStoreName(), null, this.snid, rid);
        this.logger.info("Removing data directory for resource " + rid + ": " + dataDir);
        if (dataDir.exists()) {
            this.removeFiles(dataDir);
        }
    }

    public boolean stopRepNode(RepNodeId rnid, boolean force) {
        return this.stopRepNode(rnid, force, this.serviceWaitMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stopRepNode(RepNodeId rnid, boolean force, int waitMillis) {
        boolean stopped = false;
        String serviceName = rnid.getFullName();
        this.logger.info(serviceName + ": stopRepNode called");
        ServiceManager mgr = this.repNodeServices.get(serviceName);
        boolean isRunning = true;
        if (mgr != null) {
            isRunning = mgr.isRunning();
        }
        if (mgr == null || !isRunning) {
            this.logger.info(serviceName + ": RepNode is not running");
        }
        if (mgr == null) {
            return false;
        }
        this.setServiceStoppedState(serviceName, "disabled", true);
        try {
            mgr.dontRestart();
            if (isRunning && !mgr.forceOK(force)) {
                ManagedRepNode mrn = (ManagedRepNode)mgr.getService();
                RepNodeAdminAPI rna = mrn.getRepNodeAdmin(this);
                rna.shutdown(force);
                mgr.waitFor(waitMillis);
                stopped = true;
                this.logger.info(serviceName + ": Stopped RepNode");
            }
        }
        catch (RuntimeException e) {
            this.logwarning(serviceName + ": Exception stopping RepNode", e);
        }
        catch (RemoteException re) {
            this.logwarning(serviceName + ": Exception stopping RepNode", re);
        }
        finally {
            if (!stopped) {
                mgr.stop();
            }
            this.unbindService(this.makeRepNodeBindingName(serviceName));
            this.repNodeServices.remove(serviceName);
            try {
                this.mgmtAgent.removeRepNode(rnid);
            }
            catch (RuntimeException ce) {
                this.logwarning(serviceName + ": Exception removing RepNode from mgmt" + " agent", ce);
            }
        }
        return isRunning;
    }

    private void startBootstrapAdmin() {
        if (this.bp.getAdminHttpPort() == 0) {
            this.createBootstrapAdmin = false;
        }
        if (this.bp.getForceBootstrapAdmin()) {
            this.createBootstrapAdmin = true;
        }
        if (this.createBootstrapAdmin) {
            this.startAdminInternal(null, true);
        } else {
            this.logger.info("No admin port, not starting Bootstrap Admin");
        }
    }

    public boolean startAdmin(AdminParams ap) {
        this.setServiceStoppedState(ap.getAdminId().getFullName(), "disabled", false);
        return this.startAdminInternal(ap, this.getBootstrapParams().isHostingAdmin());
    }

    private boolean startAdminInternal(AdminParams ap, boolean isBootstrap) {
        if (ap == null && !isBootstrap) {
            throw new IllegalStateException("Params for admin do not exist, should have been created.");
        }
        String serviceName = ap != null ? ap.getAdminId().getFullName() : "BootstrapAdmin";
        try {
            if (this.adminService != null) {
                boolean isRunning = this.adminService.isRunning();
                if (isRunning) {
                    this.logger.info(serviceName + ": Attempt to start a running AdminService");
                    return true;
                }
                this.logger.info(serviceName + " exists but is not runnable." + "  Attempt to stop it and restart.");
                this.stopAdminService(true, true);
            }
            this.logger.info(serviceName + ": Starting AdminService");
            ManagedAdmin ms = ap != null ? new ManagedAdmin(this.sp, ap, this.kvRoot, this.snRoot, this.getStoreName()) : new ManagedBootstrapAdmin(this);
            ServiceManager mgr = null;
            mgr = this.useThreads ? new ThreadServiceManager(this, ms) : new ProcessServiceManager(this, ms);
            if (ap != null) {
                this.checkForRecovery(ap.getAdminId(), null);
            }
            this.mgmtAgent.addAdmin(ap, mgr);
            mgr.start();
            this.adminService = mgr;
            this.logger.info(serviceName + ": Started AdminService");
        }
        catch (Exception e) {
            String msg = "Exception starting AdminService: " + e;
            this.logger.severe(msg);
            return false;
        }
        return true;
    }

    synchronized boolean isRegistered() {
        return this.getStoreName() != null;
    }

    public String makeBootstrapAdminName() {
        return "BootstrapAdmin." + this.getRegistryPort();
    }

    private void setupMonitoring(GlobalParams globalParams, StorageNodeParams snp) {
        if (this.monitorAgent != null) {
            return;
        }
        AgentRepository monitorBuffer = new AgentRepository(globalParams.getKVStoreName(), snp.getStorageNodeId());
        this.statusTracker.addListener(monitorBuffer);
        this.monitorAgent = new MonitorAgentImpl(this, globalParams, snp, this.sp, monitorBuffer, this.statusTracker);
    }

    List<ParameterMap> register(GlobalParams gp, StorageNodeParams snp, boolean hostingAdmin) {
        this.logger.info("Register: root: " + this.kvRoot + ", store: " + gp.getKVStoreName() + ", hostingAdmin: " + hostingAdmin);
        if (this.isRegistered()) {
            this.logger.info("Register: Storage Node Agent is already registered to " + this.getStoreName());
            return new RegisterReturnInfo(this).getMaps();
        }
        if (gp.isLoopbackSet()) {
            if (gp.isLoopback() != this.isLoopbackAddress()) {
                String msg = "Register: Cannot mix loopback and non-loopback addresses in the same store.  The store value " + (gp.isLoopback() ? "is" : "is not") + " configured to use loopback addresses but storage node " + snp.getHostname() + ":" + snp.getRegistryPort() + " " + (this.isLoopbackAddress() ? "is" : "is not") + " a loopback address.";
                this.logger.info(msg);
                throw new IllegalStateException(msg);
            }
        } else {
            gp.setIsLoopback(this.isLoopbackAddress());
        }
        this.setSystemInfo();
        RegisterReturnInfo rri = new RegisterReturnInfo(this);
        snp.setInstallationInfo(rri.getBootMap(), rri.getMountMap(), hostingAdmin);
        this.initSNParams(snp);
        try {
            if (this.adminService != null) {
                ServiceUtils.waitForAdmin(this.getHostname(), this.getRegistryPort(), this.getLoginManager(), 40L, ConfigurableService.ServiceStatus.RUNNING);
            }
            if (!hostingAdmin) {
                this.stopAdminService(true, true);
            }
            File configPath = new File(this.bootstrapDir, this.bootstrapFile);
            this.bp.setStoreName(gp.getKVStoreName());
            this.bp.setId(snp.getStorageNodeId().getStorageNodeId());
            this.bp.setHostingAdmin(hostingAdmin);
            ConfigUtils.createBootstrapConfig(this.bp, configPath);
            this.ensureStoreDirectory();
            if (this.kvConfigPath.exists()) {
                String msg = "Configuration file was not expected in store directory: " + this.kvConfigPath;
                throw new IllegalStateException(msg);
            }
            String newName = snp.getStorageNodeId().getFullName();
            this.logger = LoggerUtils.getLogger(StorageNodeAgentImpl.class, gp, snp);
            this.logger.fine("Storage Node named " + newName + " Registering to store " + this.getStoreName());
            this.snai.getFaultHandler().setLogger(this.logger);
            if (this.adminService != null) {
                this.adminService.resetLogger(this.logger);
            }
            LoadParameters lp = new LoadParameters();
            lp.addMap(snp.getMap());
            if (snp.getMountMap() != null) {
                lp.addMap(snp.getMountMap());
            }
            lp.addMap(gp.getMap());
            lp.saveParameters(this.kvConfigPath);
            this.start();
        }
        catch (Exception e) {
            String msg = "Register failed: " + e.getMessage() + "\n" + LoggerUtils.getStackTrace(e);
            this.revertToBootstrap();
            if (this.adminService == null) {
                this.startBootstrapAdmin();
            }
            this.logger.severe(msg);
            throw new IllegalStateException(msg, e);
        }
        return rri.getMaps();
    }

    public void shutdown(boolean stopServices, boolean force) {
        this.logger.info(this.snaName + ": Shutdown starting, " + (stopServices ? "stopping services" : "not stopping services") + (force ? " (forced)" : ""));
        this.statusTracker.update(ConfigurableService.ServiceStatus.STOPPING);
        this.stopRepNodeServices(stopServices, force);
        this.stopMasterBalanceManager();
        assert (TestHookExecute.doHookIfSet(mbmPostShutdownHook, this));
        this.stopAdminService(stopServices, force);
        this.cleanupRegistry();
        this.logger.info(this.snaName + ": Shutdown complete");
        this.statusTracker.update(ConfigurableService.ServiceStatus.STOPPED);
        this.mgmtAgent.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createAdmin(AdminParams adminParams) {
        this.checkRegistered("createAdmin");
        String adminName = adminParams.getAdminId().getFullName();
        this.logger.info(adminName + ": Creating AdminService");
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            if (lp.getMap(adminName) != null) {
                String msg = adminName + ": AdminService exists in config file";
                this.logger.info(msg);
            } else {
                lp.addMap(adminParams.getMap());
                lp.saveParameters(this.kvConfigPath);
            }
            assert (TestHookExecute.doHookIfSet(this.restartAdminHook, this));
            if (this.bp.isHostingAdmin() && this.adminService != null) {
                ManagedBootstrapAdmin mba = (ManagedBootstrapAdmin)this.adminService.getService();
                mba.resetAsManagedAdmin(adminParams, this.kvRoot, this.securityDir, this.snRoot, this.getStoreName(), this.logger);
                try {
                    mba.getAdmin(this).newParameters();
                }
                catch (RemoteException e) {
                    String msg = adminName + ": Failed to contact bootstrap AdminService";
                    this.logger.info(msg);
                    throw new IllegalStateException(msg, e);
                }
                this.logger.info(adminName + ": Created AdminService");
                return true;
            }
            return this.startAdminInternal(adminParams, false);
        }
    }

    boolean stopAdmin(AdminId adminId, boolean force) {
        if (this.adminService == null) {
            String msg = "Stopping AdminService: service is not running";
            if (ConfigUtils.getAdminParams(this.kvConfigPath, this.logger) == null) {
                msg = msg + "; service does not exist";
                throw new IllegalStateException(msg);
            }
            this.logger.warning(msg);
            return false;
        }
        String adminName = this.adminService.getService().getServiceName();
        boolean retval = this.stopAdminService(true, force);
        this.setServiceStoppedState(adminName, "disabled", true);
        return retval;
    }

    boolean destroyAdmin(AdminId adminId, boolean deleteData) {
        boolean retval = false;
        if (this.adminService == null) {
            this.logger.warning("Destroying AdminService: service is not running");
        } else {
            String serviceName = this.adminService.getService().getServiceName();
            this.logger.info(serviceName + ": Destroying AdminService");
            retval = this.stopAdminService(true, true);
        }
        if (this.bp.isHostingAdmin()) {
            this.bp.setHostingAdmin(false);
            File configPath = new File(this.bootstrapDir, this.bootstrapFile);
            ConfigUtils.createBootstrapConfig(this.bp, configPath);
        }
        this.removeConfigurable(adminId, "adminParams", deleteData);
        this.logger.info("Destroyed AdminService");
        return retval;
    }

    boolean removeConfigurable(ResourceId rid, String type, boolean deleteData) {
        ParameterMap map = ConfigUtils.removeComponent(this.kvConfigPath, rid, type, this.logger);
        if (deleteData && map != null) {
            RepNodeParams rnp;
            File mountPoint;
            if (map.getType().equals("repNodeParams") && (mountPoint = (rnp = new RepNodeParams(map)).getMountPoint()) != null) {
                File rnDir = new File(mountPoint, rid.getFullName());
                if (rnDir.exists()) {
                    this.logger.info("Removing data directory for RepNode " + rid + ": " + rnDir);
                    this.removeFiles(rnDir);
                }
                return true;
            }
            this.removeDataDir(rid);
        }
        return map != null;
    }

    StringBuilder getStartupBuffer(ResourceId rid) {
        if (rid instanceof RepNodeId) {
            ServiceManager mgr = this.repNodeServices.get(rid.getFullName());
            if (mgr != null) {
                return mgr.getService().getStartupBuffer();
            }
        } else {
            ManagedAdmin ma = (ManagedAdmin)this.adminService.getService();
            if (rid.equals(ma.getResourceId())) {
                return ma.getStartupBuffer();
            }
        }
        throw new IllegalStateException("Resource " + rid + " is not running on this storage node");
    }

    private void configureRepNode(Set<Metadata<? extends MetadataInfo>> metadataSet, RepNodeId rnid) {
        ConfigurableService.ServiceStatus[] targets = new ConfigurableService.ServiceStatus[]{ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY, ConfigurableService.ServiceStatus.RUNNING};
        RepNodeAdminAPI rnai = this.waitForRepNodeAdmin(rnid, targets, this.repnodeWaitSecs);
        if (rnai != null) {
            try {
                rnai.configure(metadataSet);
            }
            catch (RemoteException re) {
                this.logsevere(rnid + ": Failed to configure RepNodeService", re);
            }
        }
    }

    private void setServiceStoppedState(String serviceName, String paramName, boolean state) {
        LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
        ParameterMap map = lp.getMap(serviceName);
        if (map != null) {
            map.setParameter(paramName, Boolean.toString(state));
            lp.saveParameters(this.kvConfigPath);
        }
    }

    RepNodeParams lookupRepNode(RepNodeId rnid) {
        return ConfigUtils.getRepNodeParams(this.kvConfigPath, rnid, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createRepNode(RepNodeParams repNodeParams, Set<Metadata<? extends MetadataInfo>> metadataSet) {
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            RepNodeId rnid = repNodeParams.getRepNodeId();
            String serviceName = rnid.getFullName();
            this.logger.info(serviceName + ": Creating RepNode");
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            boolean startService = true;
            RepNodeParams rnp = null;
            ParameterMap map = lp.getMap(serviceName);
            if (map != null) {
                ServiceManager mgr = this.repNodeServices.get(serviceName);
                rnp = new RepNodeParams(map);
                if (mgr != null) {
                    String msg = serviceName + ": RepNode exists, not starting process";
                    this.logger.info(msg);
                    startService = false;
                } else {
                    String msg = serviceName + ": RepNode exists but is not running, will attempt " + "to start it";
                    this.logger.info(msg);
                }
            } else {
                lp.addMap(repNodeParams.getMap());
                lp.saveParameters(this.kvConfigPath);
                rnp = ConfigUtils.getRepNodeParams(this.kvConfigPath, rnid, this.logger);
            }
            assert (TestHookExecute.doHookIfSet(this.restartRNHook, this));
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 0));
            if (startService && !this.startRepNodeInternal(rnp)) {
                return false;
            }
            assert (TestHookExecute.doHookIfSet(this.stopRNHook, this));
            this.logger.info(serviceName + ": Configuring RepNode");
            this.configureRepNode(metadataSet, rnid);
            this.logger.info(serviceName + ": Created RepNode");
            return true;
        }
    }

    boolean startRepNode(RepNodeId repNodeId) {
        String serviceName = repNodeId.getFullName();
        RepNodeParams rnp = ConfigUtils.getRepNodeParams(this.kvConfigPath, repNodeId, this.logger);
        if (rnp == null) {
            String msg = serviceName + ": RepNode has not been created";
            this.logger.info(msg);
            throw new IllegalStateException(msg);
        }
        this.setServiceStoppedState(serviceName, "disabled", false);
        return this.startRepNodeInternal(rnp);
    }

    protected boolean waitForRepNodeExit(RepNodeId rnid, int timeoutSecs) {
        String serviceName = rnid.getFullName();
        ServiceManager mgr = this.repNodeServices.get(serviceName);
        if (mgr != null) {
            mgr.waitFor(timeoutSecs * 1000);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceRepNodeParams(RepNodeParams repNodeParams) {
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            String serviceName = repNodeParams.getRepNodeId().getFullName();
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            if (lp.removeMap(serviceName) == null) {
                throw new IllegalStateException("newProperties: RepNode service " + serviceName + " is not " + "managed by this Storage Node: " + this.snaName);
            }
            lp.addMap(repNodeParams.getMap());
            lp.saveParameters(this.kvConfigPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceAdminParams(AdminId adminId, ParameterMap params) {
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            String serviceName = adminId.getFullName();
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            if (lp.removeMap(serviceName) == null && lp.removeMapByType("adminParams") == null) {
                throw new IllegalStateException("newProperties: Admin service " + serviceName + " is not " + "managed by this Storage Node: " + this.snaName);
            }
            lp.addMap(params);
            lp.saveParameters(this.kvConfigPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceGlobalParams(GlobalParams globalParams) {
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            if (lp.removeMapByType("globalParams") == null) {
                this.logger.warning("Missing GlobalParams on Storage Node: " + this.snaName);
            }
            lp.addMap(globalParams.getMap());
            lp.saveParameters(this.kvConfigPath);
            this.globalParameterTracker.notifyListeners(null, globalParams.getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newParams(ParameterMap params) {
        StorageNodeAgent storageNodeAgent = this;
        synchronized (storageNodeAgent) {
            this.changeBootstrapParams(params);
            boolean isModified = false;
            LoadParameters lp = LoadParameters.getParameters(this.kvConfigPath, this.logger);
            ParameterMap curMap = lp.getMap("storageNodeParams");
            if (curMap == null) {
                throw new IllegalStateException("Could not get StorageNodeParams from file: " + this.kvConfigPath);
            }
            StorageNodeParams snp = new StorageNodeParams(curMap);
            ParameterMap oldMap = curMap.copy();
            if (!this.isMountMap(params)) {
                ParameterMap diff = curMap.diff(params, false);
                this.logger.info("newParams, changing: " + diff);
                if (curMap.merge(params, true) > 0) {
                    isModified = true;
                    if (lp.removeMap(curMap.getName()) == null) {
                        throw new IllegalStateException("Failed to remove StorageNodeParams from file");
                    }
                    lp.addMap(curMap);
                }
            } else {
                ParameterMap curMountMap = lp.getMap("mountPoints");
                if (curMountMap == null || !curMountMap.equals(params)) {
                    isModified = true;
                    if (curMountMap != null) {
                        lp.removeMap(curMountMap.getName());
                    }
                    this.logger.info("newParams, changing mount map:\n    from: " + curMountMap + "\n" + "    to: " + params);
                    lp.addMap(params);
                }
            }
            if (isModified) {
                lp.saveParameters(this.kvConfigPath);
                this.initSNParams(snp);
            }
            if (isModified && !this.isMountMap(params)) {
                this.snParameterTracker.notifyListeners(oldMap, params);
            }
        }
    }

    LoadParameters getParams() {
        return LoadParameters.getParameters(this.kvConfigPath, this.logger);
    }

    private void initSNParams(StorageNodeParams snp) {
        this.serviceWaitMillis = snp.getServiceWaitMillis();
        this.repnodeWaitSecs = snp.getRepNodeStartSecs();
        this.maxLink = snp.getMaxLinkCount();
        this.linkExecWaitSecs = snp.getLinkExecWaitSecs();
        this.capacity = snp.getCapacity();
        this.logFileLimit = snp.getLogFileLimit();
        this.logFileCount = snp.getLogFileCount();
        this.numCPUs = snp.getNumCPUs();
        this.memoryMB = snp.getMemoryMB();
        this.mountPointsString = StorageNodeAgent.joinStringList(snp.getMountPoints(), ",");
        this.customProcessStartupPrefix = snp.getProcessStartupPrefix();
        MgmtAgent newMgmtAgent = MgmtAgentFactory.getAgent(this, snp, this.statusTracker);
        if (newMgmtAgent != this.mgmtAgent) {
            this.mgmtAgent = newMgmtAgent;
            for (ServiceManager mgr : this.repNodeServices.values()) {
                ManagedRepNode mrn = (ManagedRepNode)mgr.getService();
                try {
                    this.mgmtAgent.addRepNode(mrn.getRepNodeParams(), mgr);
                }
                catch (Exception e) {
                    String msg = mrn.getResourceId().getFullName() + ": Exception adding RepNode to MgmtAgent: " + e.getMessage();
                    throw new IllegalStateException(msg, e);
                }
            }
            if (this.adminService != null) {
                ManagedAdmin ma = (ManagedAdmin)this.adminService.getService();
                try {
                    this.mgmtAgent.addAdmin(ma.getAdminParams(), this.adminService);
                }
                catch (Exception e) {
                    String msg = "Exception adding Admin to MgmtAgent: " + e.getMessage();
                    throw new IllegalStateException(msg, e);
                }
            }
        }
    }

    private static String joinStringList(List<String> a, String delimiter) {
        String r = "";
        if (a != null) {
            int n = 0;
            for (String s : a) {
                if (n++ > 0) {
                    r = r + delimiter;
                }
                r = r + s;
            }
        }
        return r;
    }

    private void changeBootstrapParams(ParameterMap params) {
        boolean isModified = false;
        File configPath = new File(this.bootstrapDir, this.bootstrapFile);
        this.bp = ConfigUtils.getBootstrapParams(configPath, this.logger);
        if (!this.isMountMap(params)) {
            ParameterMap curMap = this.bp.getMap();
            ParameterMap bmap = params.filter(EnumSet.of(ParameterState.Info.BOOT));
            if (bmap.size() > 0 && curMap.merge(bmap, true) > 0) {
                isModified = true;
            }
        } else {
            ParameterMap curMountMap = this.bp.getMountMap();
            if (curMountMap == null || !curMountMap.equals(params)) {
                isModified = true;
                this.bp.setMountMap(params);
            }
        }
        if (isModified) {
            ConfigUtils.createBootstrapConfig(this.bp, configPath);
        }
    }

    private boolean isMountMap(ParameterMap pmap) {
        String name = pmap.getName();
        return name != null && name.equals("mountPoints");
    }

    String[] listSnapshots() {
        ResourceId rid = null;
        File repNodeDir = null;
        AdminParams ap = ConfigUtils.getAdminParams(this.kvConfigPath, this.logger);
        if (ap != null) {
            rid = ap.getAdminId();
        } else {
            List<ParameterMap> repNodes = ConfigUtils.getRepNodes(this.kvConfigPath, this.logger);
            Iterator<ParameterMap> i$ = repNodes.iterator();
            if (i$.hasNext()) {
                ParameterMap map = i$.next();
                RepNodeParams rn = new RepNodeParams(map);
                rid = rn.getRepNodeId();
                repNodeDir = rn.getMountPoint();
            }
        }
        if (rid == null) {
            this.logger.warning("listSnapshots: Unable to find managed services");
            return new String[0];
        }
        File snapDir = FileNames.getSnapshotDir(this.kvRoot.toString(), this.getStoreName(), repNodeDir, this.snid, rid);
        if (snapDir.isDirectory()) {
            File[] snapFiles = snapDir.listFiles();
            String[] snaps = new String[snapFiles.length];
            for (int i = 0; i < snaps.length; ++i) {
                snaps[i] = snapFiles[i].getName();
            }
            return snaps;
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String snapshotAdmin(AdminId aid, String name) throws RemoteException {
        if (this.adminService == null) {
            String msg = "AdminService " + aid + " is not running";
            this.logger.warning(msg);
            throw new IllegalStateException(msg);
        }
        try {
            ManagedAdmin ma = (ManagedAdmin)this.adminService.getService();
            CommandServiceAPI cs = ma.getAdmin(this);
            String[] files = cs.startBackup();
            String path = null;
            try {
                path = this.snapshot(aid, null, name, files);
            }
            finally {
                cs.stopBackup();
            }
            return path;
        }
        catch (RemoteException re) {
            this.logwarning("Exception attempting to snapshot Admin " + aid, re);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String snapshotRepNode(RepNodeId rnid, String name) throws RemoteException {
        String serviceName = rnid.getFullName();
        ServiceManager mgr = this.repNodeServices.get(serviceName);
        if (mgr == null) {
            String msg = rnid + ": RepNode is not running";
            this.logger.warning(msg);
            throw new IllegalStateException(msg);
        }
        try {
            ManagedRepNode mrn = (ManagedRepNode)mgr.getService();
            RepNodeAdminAPI rna = mrn.getRepNodeAdmin(this);
            File repNodeDir = mrn.getRepNodeParams().getMountPoint();
            String[] files = rna.startBackup();
            String path = null;
            try {
                path = this.snapshot(rnid, repNodeDir, name, files);
            }
            finally {
                rna.stopBackup();
            }
            return path;
        }
        catch (RemoteException re) {
            this.logwarning("Exception attempting to snapshot RepNode " + rnid, re);
            throw re;
        }
    }

    void removeSnapshot(ResourceId rid, String name) {
        File serviceDir = null;
        if (rid instanceof RepNodeId) {
            RepNodeParams rnp = ConfigUtils.getRepNodeParams(this.kvConfigPath, (RepNodeId)rid, this.logger);
            if (rnp == null) {
                String msg = rid.getFullName() + ": RepNode has not been created";
                this.logger.info(msg);
                throw new IllegalStateException(msg);
            }
            serviceDir = rnp.getMountPoint();
        }
        File snapshotDir = FileNames.getSnapshotDir(this.kvRoot.toString(), this.getStoreName(), serviceDir, this.snid, rid);
        if (name != null) {
            this.removeFiles(new File(snapshotDir, name));
        } else if (snapshotDir.isDirectory()) {
            for (File file : snapshotDir.listFiles()) {
                this.logger.info(rid + ": Removing snapshot " + file.getName());
                this.removeFiles(file);
            }
        }
    }

    private void makeLinks(File srcBase, File destDir, String[] files) {
        if (this.isWindows) {
            for (String file : files) {
                File src = new File(srcBase, file);
                File dest = new File(destDir, file);
                this.windowsMakeLink(src, dest);
            }
            return;
        }
        int nfiles = 0;
        ArrayList<String> command = new ArrayList<String>();
        command.add(LINK_COMMAND);
        command.add("-f");
        for (String file : files) {
            command.add(new File(srcBase, file).toString());
            if (++nfiles < this.maxLink) continue;
            command.add(destDir.toString());
            this.execute(command);
            command = new ArrayList();
            command.add(LINK_COMMAND);
            command.add("-f");
            nfiles = 0;
        }
        if (command.size() > 2) {
            command.add(destDir.toString());
            this.execute(command);
        }
    }

    private void windowsMakeLink(File src, File dest) {
        if (!this.isWindows) {
            throw new IllegalStateException("Function should only be called on Windows");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("fsutil");
        command.add("hardlink");
        command.add("create");
        command.add(dest.toString());
        command.add(src.toString());
        this.execute(command);
    }

    private void execute(List<String> command) {
        ProcessMonitor pm = new ProcessMonitor(command, 0, "snapshot", null);
        try {
            pm.startProcess();
            if (!pm.waitProcess(this.linkExecWaitSecs * 1000)) {
                throw new IllegalStateException("Timeout waiting for ln process to complete");
            }
        }
        catch (Exception e) {
            this.logger.info("Snapshot failed to make links with command: " + command + ": " + e);
            throw new SNAFaultException(e);
        }
    }

    private String snapshot(ResourceId rid, File serviceDir, String name, String[] files) {
        File srcBase = FileNames.getEnvDir(this.kvRoot.toString(), this.getStoreName(), serviceDir, this.snid, rid);
        File destBase = FileNames.getSnapshotDir(this.kvRoot.toString(), this.getStoreName(), serviceDir, this.snid, rid);
        File destDir = new File(destBase, name);
        this.logger.info("Creating snapshot of " + rid + ": " + name + " (" + files.length + " files)");
        if (destDir.exists()) {
            String msg = "Snapshot directory exists, cannot overwrite: " + destDir;
            this.logger.warning(msg);
            throw new IllegalStateException(msg);
        }
        FileNames.makeDir(destDir);
        this.makeLinks(srcBase, destDir, files);
        this.logger.info("Completed snapshot of " + rid + ": " + name);
        return destDir.toString();
    }

    private void removeFiles(File target) {
        if (target.isDirectory()) {
            for (File f : target.listFiles()) {
                this.removeFiles(f);
            }
        }
        if (target.exists() && !target.delete()) {
            String msg = "Unable to remove file or directory " + target;
            this.logger.warning(msg);
            throw new IllegalStateException(msg);
        }
    }

    private void checkForRecovery(ResourceId rid, File dir) {
        File recoveryDir = FileNames.getRecoveryDir(this.kvRoot.toString(), this.getStoreName(), dir, this.snid, rid);
        if (recoveryDir.isDirectory()) {
            File[] files = recoveryDir.listFiles();
            if (files.length != 1) {
                this.logger.info(rid + ": only one file is allowed in recovery " + " directory " + recoveryDir + ", not recovering");
                return;
            }
            if (!files[0].isDirectory()) {
                this.logger.info("Recovery file " + files[0] + " is not a directory" + ", cannot use it for recovery");
                return;
            }
            File envDir = FileNames.getEnvDir(this.kvRoot.toString(), this.getStoreName(), dir, this.snid, rid);
            this.logger.info(rid + ": recovering from " + files[0] + " to environment directory " + envDir);
            if (envDir.isDirectory()) {
                File target = new File(envDir.toString() + ".old");
                if (target.exists()) {
                    this.removeFiles(target);
                }
                if (!envDir.renameTo(target)) {
                    this.logger.warning(rid + ": failed to rename old env dir");
                    return;
                }
            }
            if (!files[0].renameTo(envDir)) {
                this.logger.warning(rid + ": failed to rename recovery directory");
            }
        }
    }

    public MgmtAgent getMgmtAgent() {
        return this.mgmtAgent;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public int getLogFileLimit() {
        return this.logFileLimit;
    }

    public int getLogFileCount() {
        return this.logFileCount;
    }

    public int getNumCpus() {
        return this.numCPUs;
    }

    public int getMemoryMB() {
        return this.memoryMB;
    }

    public String getMountPointsString() {
        return this.mountPointsString;
    }

    public SNASecurity getSNASecurity() {
        return this.snaSecurity;
    }

    public LoginManager getLoginManager() {
        return this.snaSecurity.getLoginManager();
    }

    ProcessFaultHandler getFaultHandler() {
        return this.snai.getFaultHandler();
    }

    public static class RegisterReturnInfo {
        private final List<ParameterMap> maps;
        private ParameterMap bootMap;
        private ParameterMap mountMap;

        public RegisterReturnInfo(StorageNodeAgent sna) {
            BootstrapParams bp = sna.getBootstrapParams();
            this.maps = new ArrayList<ParameterMap>();
            this.bootMap = bp.getMap().copy();
            this.bootMap.setParameter("isLoopback", Boolean.toString(sna.isLoopbackAddress()));
            this.mountMap = bp.getMountMap().copy();
            this.maps.add(this.bootMap);
            this.maps.add(this.mountMap);
        }

        public RegisterReturnInfo(List<ParameterMap> maps) {
            this.maps = maps;
            this.bootMap = null;
            this.mountMap = null;
            for (ParameterMap pmap : maps) {
                if (pmap.getName().equals("params")) {
                    this.bootMap = pmap;
                }
                if (!pmap.getName().equals("mountPoints")) continue;
                this.mountMap = pmap;
            }
        }

        public List<ParameterMap> getMaps() {
            return this.maps;
        }

        public ParameterMap getBootMap() {
            return this.bootMap;
        }

        public ParameterMap getMountMap() {
            return this.mountMap;
        }

        public boolean getIsLoopback() {
            if (this.bootMap == null) {
                throw new IllegalStateException("BootMap cannot be null when asking for loopback info");
            }
            Parameter p = this.bootMap.get("isLoopback");
            if (p == null) {
                throw new IllegalStateException("GP_ISLOOPBACK parameter is not set in boot map");
            }
            return p.asBoolean();
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (StorageNodeAgent.this.statusTracker != null && StorageNodeAgent.this.statusTracker.getServiceStatus() == ConfigurableService.ServiceStatus.RUNNING || StorageNodeAgent.this.statusTracker.getServiceStatus() == ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY) {
                StorageNodeAgent.this.logger.info("Shutdown thread running, stopping services");
                try {
                    StorageNodeAgent.this.shutdown(true, false);
                }
                finally {
                    StorageNodeAgent.this.logger.info("Shutdown thread exiting");
                }
            }
        }
    }

    class SNAParser
    extends CommandParser {
        private boolean shutdown;

        public SNAParser(String[] args) {
            super(args);
            this.shutdown = false;
        }

        public boolean getShutdown() {
            return this.shutdown;
        }

        @Override
        protected void verifyArgs() {
            if (this.getRootDir() == null) {
                this.missingArg("-root");
            } else {
                File rtDir = new File(this.getRootDir());
                if (!rtDir.isDirectory()) {
                    System.err.println("Root directory " + this.rootDir + " does not exist or " + "is not a directory");
                    System.exit(2);
                }
            }
            if (StorageNodeAgent.this.bootstrapFile == null) {
                StorageNodeAgent.this.bootstrapFile = StorageNodeAgent.DEFAULT_CONFIG_FILE;
            }
            if (StorageNodeAgent.this.securityConfigFile == null) {
                StorageNodeAgent.this.securityConfigFile = StorageNodeAgent.DEFAULT_SECURITY_FILE;
            }
            StorageNodeAgent.this.isVerbose = this.getVerbose();
        }

        @Override
        protected boolean checkArg(String arg) {
            if (arg.equals(StorageNodeAgent.CONFIG_FLAG)) {
                StorageNodeAgent.this.bootstrapFile = this.nextArg(arg);
                return true;
            }
            if (arg.equals(StorageNodeAgent.SHUTDOWN_FLAG)) {
                this.shutdown = true;
                return true;
            }
            if (arg.equals(StorageNodeAgent.THREADS_FLAG)) {
                StorageNodeAgent.this.useThreads = true;
                return true;
            }
            return false;
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar  <start | stop | restart>\n\t" + COMMAND_ARGS);
            throw new IllegalArgumentException("Could not parse Storage Node Agent arguments");
        }
    }
}

