/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AccessCheckerImpl;
import oracle.kv.impl.security.login.InternalLoginManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.TokenResolverImpl;
import oracle.kv.impl.security.login.TokenVerifier;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;

public class SNASecurity
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater {
    private final StorageNodeAgent sna;
    private final AccessChecker accessChecker;
    private final TokenResolverImpl tokenResolver;
    private final InternalLoginManager loginMgr;
    private final TokenVerifier tokenVerifier;
    private final Logger logger;

    public SNASecurity(StorageNodeAgent sna, BootstrapParams bp, SecurityParams sp, GlobalParams gp, StorageNodeParams snp, Logger logger) {
        this.sna = sna;
        this.logger = logger;
        if (sp.isSecure()) {
            String hostname = bp.getHostname();
            int registryPort = bp.getRegistryPort();
            String storeName = bp.getStoreName();
            StorageNodeId snid = storeName == null ? null : new StorageNodeId(bp.getId());
            SNATopoResolver topoResolver = storeName == null ? null : new SNATopoResolver(new TopologyResolver.SNInfo(hostname, registryPort, snid));
            this.loginMgr = new InternalLoginManager(null);
            this.tokenResolver = new TokenResolverImpl(hostname, registryPort, storeName, topoResolver, this.loginMgr, logger);
            StorageNodeParams newSNp = snp == null ? new StorageNodeParams(sna.getHostname(), sna.getRegistryPort(), null) : snp;
            int tokenCacheCapacity = newSNp.getLoginCacheSize();
            GlobalParams newGp = gp == null ? new GlobalParams(sna.getStoreName()) : gp;
            long tokenCacheEntryLifetime = newGp.getLoginCacheTimeoutUnit().toMillis(newGp.getLoginCacheTimeout());
            TokenVerifier.CacheConfig tokenCacheConfig = new TokenVerifier.CacheConfig(tokenCacheCapacity, tokenCacheEntryLifetime);
            this.tokenVerifier = new TokenVerifier(tokenCacheConfig, this.tokenResolver);
            this.accessChecker = new AccessCheckerImpl(this.tokenVerifier, logger);
        } else {
            this.tokenResolver = null;
            this.accessChecker = null;
            this.loginMgr = null;
            this.tokenVerifier = null;
        }
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public LoginManager getLoginManager() {
        return this.loginMgr;
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        StorageNodeParams snp = new StorageNodeParams(map);
        int newCapacity = snp.getLoginCacheSize();
        if (this.tokenVerifier.updateLoginCacheSize(newCapacity)) {
            this.logger.info(String.format("SNASecurity: loginCacheSize has been updated to %d", newCapacity));
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        long newLifeTime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
        if (this.tokenVerifier.updateLoginCacheTimeout(newLifeTime)) {
            this.logger.info(String.format("SNASecurity: loginCacheTimeout has been updated to %d ms", newLifeTime));
        }
    }

    private final class SNATopoResolver
    implements TopologyResolver {
        final TopologyResolver.SNInfo localSNInfo;

        private SNATopoResolver(TopologyResolver.SNInfo snInfo) {
            this.localSNInfo = snInfo;
        }

        private SNATopoResolver() {
            this.localSNInfo = null;
        }

        @Override
        public TopologyResolver.SNInfo getStorageNode(ResourceId rid) {
            if (this.localSNInfo != null && rid instanceof StorageNodeId && ((StorageNodeId)rid).getStorageNodeId() == this.localSNInfo.getStorageNodeId().getStorageNodeId()) {
                return this.localSNInfo;
            }
            return null;
        }

        @Override
        public List<RepNodeId> listRepNodeIds(int maxRNs) {
            return null;
        }
    }
}

