/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.util.CommonLoggerUtils;

public class ProcessMonitor {
    private final ReentrantLock lock = new ReentrantLock();
    private Logger logger;
    private List<String> command;
    private ArrayList<Long> restarts;
    private String serviceName;
    private MonitorThread monitorThread;
    private IOThread ioThread;
    private int restartCount;
    private ProcessState state;
    private Process process;
    private int totalRestarts;
    private int exitCode;
    protected StringBuilder startupBuffer;
    private static final int RESTART_RESET = 30;
    private static final int RESTART_MAX = 5;
    private static final long RESTART_MILLIS = 60000L;

    public ProcessMonitor(List<String> command, int restartCount, String serviceName, Logger logger) {
        this.restartCount = restartCount;
        this.logger = logger;
        this.command = command;
        this.serviceName = serviceName;
        this.process = null;
        this.monitorThread = null;
        this.ioThread = null;
        this.state = ProcessState.DOWN;
        this.totalRestarts = 0;
        this.restarts = new ArrayList();
        this.exitCode = 0;
    }

    public void reset(List<String> newCommand, String newServiceName) {
        this.command = newCommand;
        this.serviceName = newServiceName;
    }

    public void dontRestart() {
        this.lock.lock();
        this.restartCount = 0;
        this.lock.unlock();
    }

    public boolean canRestart() {
        return this.restartCount != 0;
    }

    public boolean isRunning() {
        return this.state != ProcessState.DOWN;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void resetLogger(Logger logger1) {
        this.logger = logger1;
    }

    private void logFine(String msg) {
        if (this.logger != null) {
            this.logger.fine(this.serviceName + ": ProcessMonitor: " + msg);
        }
    }

    private void logInfo(String msg) {
        if (this.logger != null) {
            this.logger.info(this.serviceName + ": ProcessMonitor: " + msg);
        }
    }

    private void logSevere(String msg) {
        if (this.logger != null) {
            this.logger.severe(this.serviceName + ": ProcessMonitor: " + msg);
        }
    }

    protected void afterStart() {
    }

    protected void onRestart() {
    }

    protected void onExit(int exitStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException {
        this.lock.lock();
        try {
            if (this.state == ProcessState.DOWN) {
                ProcessBuilder builder = new ProcessBuilder(this.command);
                builder.redirectErrorStream(true);
                this.process = builder.start();
                this.state = ProcessState.RUNNING;
                this.logInfo("startProcess");
                this.ioThread = new IOThread("SNA.io." + this.serviceName);
                this.ioThread.start();
                this.monitorThread = new MonitorThread("SNA.monitor." + this.serviceName, true);
                this.monitorThread.start();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.afterStart();
    }

    public void stopProcess(boolean isMonitor) throws InterruptedException {
        block8: {
            if (!isMonitor) {
                this.logInfo("stopProcess");
            }
            this.lock.lock();
            if (!isMonitor) {
                this.restartCount = 0;
            }
            if (this.state == ProcessState.DOWN || this.state != ProcessState.RUNNING && isMonitor) {
                this.lock.unlock();
                return;
            }
            this.state = ProcessState.STOPPING;
            if (this.process != null) {
                this.process.destroy();
            }
            this.lock.unlock();
            try {
                if (this.monitorThread != null && !isMonitor) {
                    this.monitorThread.join();
                    this.monitorThread = null;
                }
                if (this.ioThread != null) {
                    this.ioThread.join();
                    this.ioThread = null;
                }
            }
            catch (InterruptedException e) {
                this.logInfo("Exception in stopProcess");
                if (!Thread.interrupted() || !isMonitor) break block8;
                throw e;
            }
        }
        this.lock.lock();
        this.state = ProcessState.DOWN;
        this.process = null;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartProcess() throws IOException {
        this.logInfo("restartProcess called, totalRestarts is " + this.totalRestarts + ", restartCount is " + this.restartCount);
        this.lock.lock();
        try {
            if (this.restartCount != 0) {
                this.startProcess();
                this.restarts.add(System.currentTimeMillis());
                ++this.totalRestarts;
                if (this.restartCount > 0) {
                    --this.restartCount;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean waitProcess(long millis) throws InterruptedException {
        boolean retval = true;
        if (this.monitorThread != null) {
            this.logFine("waiting for MonitorThread");
            this.monitorThread.join(millis);
            if (this.monitorThread.isAlive()) {
                retval = false;
            }
            this.monitorThread = null;
        }
        if (this.ioThread != null && retval) {
            this.logFine("waiting for IOThread");
            this.ioThread.join(millis);
            if (this.ioThread.isAlive()) {
                retval = false;
            }
            this.ioThread = null;
        }
        return retval;
    }

    public void destroyProcess() {
        this.lock.lock();
        Process p = this.process;
        this.lock.unlock();
        if (p != null) {
            p.destroy();
        }
    }

    class IOThread
    extends Thread {
        public IOThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                boolean startupOK = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ProcessMonitor.this.startupBuffer = new StringBuilder(512);
                ProcessMonitor.this.logFine("IOThread initializing startup buffer");
                BufferedReader reader = null;
                ProcessMonitor.this.lock.lock();
                if (ProcessMonitor.this.process == null) {
                    ProcessMonitor.this.logInfo("IOthread: no process, exiting");
                    ProcessMonitor.this.lock.unlock();
                    return;
                }
                reader = new BufferedReader(new InputStreamReader(ProcessMonitor.this.process.getInputStream()));
                ProcessMonitor.this.lock.unlock();
                String line = reader.readLine();
                while (line != null) {
                    ProcessMonitor.this.logInfo(line);
                    if (line.contains("ManagedServiceStarted")) {
                        startupOK = true;
                        ProcessMonitor.this.startupBuffer = null;
                        ProcessMonitor.this.logFine("IOThread clearing startup buffer");
                    }
                    if (!startupOK) {
                        ProcessMonitor.this.startupBuffer.append("\n" + line);
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                ProcessMonitor.this.logInfo("IOThread exception: " + e.getMessage());
            }
            ProcessMonitor.this.logInfo("IOThread exiting");
        }

        void closeInput() throws IOException {
            ProcessMonitor.this.process.getInputStream().close();
        }
    }

    class MonitorThread
    extends Thread {
        private final boolean useExitCode;

        private MonitorThread(String name, boolean useExitCode) {
            super(name);
            this.useExitCode = useExitCode;
        }

        private boolean okToRestart(int exitStatus) {
            if (this.useExitCode && !ProcessExitCode.needsRestart(exitStatus)) {
                ProcessMonitor.this.logInfo("exit code:" + exitStatus);
                return false;
            }
            ProcessMonitor.this.logInfo("Process restart requested; exit code:" + exitStatus + (exitStatus == ProcessExitCode.RESTART_OOME.getValue() ? " Process experienced an OOME." : ""));
            if (ProcessMonitor.this.restartCount == 0) {
                ProcessMonitor.this.logInfo("restart count is 0");
                return false;
            }
            return this.checkExcessiveRestarts();
        }

        private boolean checkExcessiveRestarts() {
            long first;
            long last;
            boolean ret = true;
            if (ProcessMonitor.this.restarts.size() >= 5 && (last = ((Long)ProcessMonitor.this.restarts.get(ProcessMonitor.this.restarts.size() - 1)).longValue()) - (first = ((Long)ProcessMonitor.this.restarts.get(ProcessMonitor.this.restarts.size() - 5)).longValue()) < 60000L) {
                ProcessMonitor.this.logSevere("excessive restarts (" + ProcessMonitor.this.restarts + "), disabling service");
                ProcessMonitor.this.dontRestart();
                ret = false;
            }
            if (ProcessMonitor.this.restarts.size() >= 30) {
                ProcessMonitor.this.restarts = new ArrayList();
            }
            return ret;
        }

        @Override
        public void run() {
            try {
                assert (ProcessMonitor.this.process != null);
                ProcessMonitor.this.exitCode = ProcessMonitor.this.process.waitFor();
                ProcessMonitor.this.logInfo("exited, exit code: " + ProcessMonitor.this.exitCode);
                if (ProcessMonitor.this.ioThread != null) {
                    ProcessMonitor.this.ioThread.join();
                    ProcessMonitor.this.ioThread = null;
                }
                ProcessMonitor.this.stopProcess(true);
                if (this.okToRestart(ProcessMonitor.this.exitCode)) {
                    ProcessMonitor.this.onRestart();
                    ProcessMonitor.this.restartProcess();
                } else {
                    ProcessMonitor.this.onExit(ProcessMonitor.this.exitCode);
                    ProcessMonitor.this.logInfo("not restarting");
                }
            }
            catch (Exception e) {
                String msg = "Unexpected exception in MonitorThread: " + e + CommonLoggerUtils.getStackTrace(e);
                ProcessMonitor.this.logSevere(msg);
            }
        }
    }

    static enum ProcessState {
        DOWN,
        RUNNING,
        STOPPING;

    }
}

