/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.monitor.MonitorAgent;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

@SecureAPI
public class MonitorAgentImpl
extends VersionedRemoteImpl
implements MonitorAgent {
    private final StorageNodeAgent sna;
    private final Logger logger;
    private final AgentRepository measurementBuffer;
    private final GlobalParams globalParams;
    private final StorageNodeParams snp;
    private final SecurityParams securityParams;
    private final ServiceStatusTracker statusTracker;
    private MonitorAgent exportableMonitorAgent;

    public MonitorAgentImpl(StorageNodeAgent sna, GlobalParams globalParams, StorageNodeParams snp, SecurityParams securityParams, AgentRepository agentRepository, ServiceStatusTracker statusTracker) {
        this.sna = sna;
        this.globalParams = globalParams;
        this.snp = snp;
        this.securityParams = securityParams;
        this.logger = LoggerUtils.getLogger(this.getClass(), globalParams, snp);
        this.measurementBuffer = agentRepository;
        this.statusTracker = statusTracker;
    }

    @Override
    @SecureR2Method
    public List<Measurement> getMeasurements(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.AUTHENTICATED})
    public List<Measurement> getMeasurements(AuthContext authCtx, short serialVersion) {
        AgentRepository.Snapshot snapshot = this.measurementBuffer.getAndReset();
        List<Measurement> monitorData = snapshot.measurements;
        if (snapshot.serviceStatusChanges == 0) {
            monitorData.add(new ServiceStatusChange(this.statusTracker.getServiceStatus()));
        }
        this.logger.fine("MonitorAgent: Getting " + monitorData.size() + " measurements");
        return monitorData;
    }

    public void startup() throws RemoteException {
        String kvStoreName = this.globalParams.getKVStoreName();
        StorageNodeId snId = this.snp.getStorageNodeId();
        String csfName = ClientSocketFactory.factoryName(kvStoreName, StorageNodeId.getPrefix(), RegistryUtils.InterfaceType.MONITOR.interfaceName());
        RMISocketPolicy policy = this.securityParams.getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = this.snp.getMonitorSFP(policy, csfName);
        this.initExportableMonitorAgent();
        this.logger.info("Starting MonitorAgent.  Server socket factory:" + sfp.getServerFactory() + " Client socket factory:" + sfp.getClientFactory());
        RegistryUtils.rebind(this.snp.getHostname(), this.snp.getRegistryPort(), kvStoreName, snId.getFullName(), RegistryUtils.InterfaceType.MONITOR, this.exportableMonitorAgent, sfp.getClientFactory(), sfp.getServerFactory());
    }

    public void stop() throws RemoteException {
        RegistryUtils.unbind(this.snp.getHostname(), this.snp.getRegistryPort(), this.globalParams.getKVStoreName(), this.snp.getStorageNodeId().getFullName(), RegistryUtils.InterfaceType.MONITOR, this.exportableMonitorAgent);
        this.logger.info("Stopping MonitorAgent");
    }

    public AgentRepository getAgentRepository() {
        return this.measurementBuffer;
    }

    private void initExportableMonitorAgent() {
        try {
            this.exportableMonitorAgent = SecureProxy.create(this, this.sna.getSNASecurity().getAccessChecker(), this.sna.getFaultHandler());
        }
        catch (ConfigurationException ce) {
            throw new IllegalStateException("Unabled to create proxy", ce);
        }
    }
}

