/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.sna.ManagedAdmin;
import oracle.kv.impl.sna.ManagedBootstrapAdmin;
import oracle.kv.impl.sna.ManagedRepNode;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.server.LoggerUtils;

public abstract class ManagedService {
    protected File kvRootDir;
    protected File kvSecDir;
    protected File kvSNDir;
    protected String kvName;
    protected String serviceName;
    protected final String serviceClass;
    protected ParameterMap params;
    protected Logger logger;
    protected StringBuilder startupBuffer;
    protected static boolean usingThreads;
    public static final String REP_NODE_NAME = "RepNode";
    public static final String ADMIN_NAME = "Admin";
    public static final String BOOTSTRAP_ADMIN_NAME = "BootstrapAdmin";
    public static final String LOG_CONFIG_PREFIX = "config.";
    public static final String ROOT_FLAG = "-root";
    public static final String SECDIR_FLAG = "-secdir";
    public static final String STORE_FLAG = "-store";
    public static final String CLASS_FLAG = "-class";
    public static final String SERVICE_FLAG = "-service";
    public static final String THREADS_FLAG = "-threads";
    public static final String STARTUP_OK = "ManagedServiceStarted";
    private static final String JAVA_VERSION_KEY = "java.version";
    private static final String JDK5_VERSION = "1.5";
    private static final String JDK6_VERSION = "1.6";

    public ManagedService(File kvRootDir, File kvSecDir, File kvSNDir, String kvName, String serviceClass, String serviceName, ParameterMap params) {
        this.kvRootDir = kvRootDir;
        this.kvSecDir = kvSecDir;
        this.kvSNDir = kvSNDir;
        this.kvName = kvName;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.params = params;
        this.logger = null;
    }

    public abstract void start(boolean var1);

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKvName() {
        return this.kvName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getJVMArgs() {
        if (this.params != null) {
            return this.params.get("javaMiscParams").asString();
        }
        return null;
    }

    public String getLoggingConfig() {
        if (this.params != null) {
            return this.params.get("loggingConfigProps").asString();
        }
        return null;
    }

    String getGCLoggingArgs(Parameter gcLogFiles, Parameter gcLogFileSize, String resourceName) {
        String javaVersion = System.getProperty(JAVA_VERSION_KEY);
        if (javaVersion == null || javaVersion.startsWith(JDK5_VERSION) || javaVersion.startsWith(JDK6_VERSION)) {
            return "";
        }
        String gcFileName = new File(FileNames.getLoggingDir(this.kvRootDir, this.kvName), resourceName).toString() + ".gc";
        return " -XX:+PrintGCDetails -XX:+PrintGCDateStamps  -XX:+PrintGCApplicationStoppedTime -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=" + gcLogFiles + " -XX:GCLogFileSize=" + gcLogFileSize + " -Xloggc:" + gcFileName + " ";
    }

    public String getDefaultJavaArgs(String overrideJvmArgs) {
        return null;
    }

    public synchronized void setStartupBuffer(StringBuilder buf) {
        this.startupBuffer = buf;
    }

    public synchronized StringBuilder getStartupBuffer() {
        return this.startupBuffer;
    }

    public static void setUsingThreads(boolean value) {
        usingThreads = value;
    }

    public abstract ResourceId getResourceId();

    public abstract void resetHandles();

    public abstract void resetParameters(boolean var1);

    public boolean resetOnRestart() {
        return false;
    }

    protected void startLogger(Class<?> cl, ResourceId rid, LoadParameters lp) {
        GlobalParams globalParams = new GlobalParams(lp.getMapByType("globalParams"));
        StorageNodeParams storageNodeParams = new StorageNodeParams(lp.getMapByType("storageNodeParams"));
        this.logger = LoggerUtils.getLogger(cl, rid.toString(), rid, globalParams, storageNodeParams);
        if (!usingThreads) {
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            this.logger.info("Starting service process: " + rid.toString() + ", Java command line arguments: " + runtimeBean.getInputArguments());
        }
    }

    protected LoadParameters getParameters() {
        File kvConfigPath = new File(this.kvSNDir, "config.xml");
        LoadParameters lp = LoadParameters.getParameters(kvConfigPath, this.logger);
        return lp;
    }

    protected SecurityParams getSecurityParameters() {
        if (this.kvSecDir == null) {
            return SecurityParams.makeDefault();
        }
        File securityConfigPath = new File(this.kvSecDir, "security.xml");
        if (!securityConfigPath.exists()) {
            throw new IllegalStateException("The security configuraton file " + securityConfigPath + " does not exist.");
        }
        LoadParameters lp = LoadParameters.getParameters(securityConfigPath, this.logger);
        SecurityParams sp = new SecurityParams(lp, securityConfigPath);
        return sp;
    }

    public String createLoggingConfigFile(String properties) {
        String pathToFile;
        block2: {
            pathToFile = null;
            try {
                File logConfigFile = new File(FileNames.getLoggingDir(this.kvRootDir, this.kvName), LOG_CONFIG_PREFIX + this.serviceName);
                Properties props = new Properties();
                String header = "Logging properties for " + this.serviceName + ". DO NOT EDIT!";
                props.load(ConfigUtils.getPropertiesStream(properties));
                props.store(new FileOutputStream(logConfigFile), header);
                pathToFile = logConfigFile.toString();
            }
            catch (Exception e) {
                if (this.logger == null) break block2;
                this.logger.warning("Could not configure logging config file for " + this.serviceName + ": " + e.getMessage());
            }
        }
        return pathToFile;
    }

    public static void killProcess(Integer pid) {
        String[] command;
        String os = System.getProperty("os.name");
        boolean isWindows = os.indexOf("Windows") != -1;
        int i = 0;
        if (isWindows) {
            command = new String[4];
            command[i++] = "taskkill";
            command[i++] = "/f";
            command[i++] = "/pid";
        } else {
            command = new String[3];
            command[i++] = "kill";
            command[i++] = "-9";
        }
        command[i] = pid.toString();
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public static void killManagedProcesses(String storeName, String serviceName, Logger logger) {
        List<Integer> list = ManagedService.findManagedProcesses(storeName, serviceName, logger);
        for (Integer pid : list) {
            if (logger != null) {
                logger.info("Killing managed process " + pid + " for " + "store, serviceName: " + storeName + ", " + serviceName);
            }
            ManagedService.killProcess(pid);
        }
    }

    protected static void killManagedProcesses(String className, String storeName, String serviceName, Logger logger) {
        List<Integer> list = ManagedService.findManagedProcesses(className, storeName, serviceName, logger);
        for (Integer pid : list) {
            if (logger != null) {
                logger.info("Killing managed process " + pid + " matching " + "these fields: " + storeName + ", " + serviceName);
            }
            ManagedService.killProcess(pid);
        }
    }

    public static List<Integer> findManagedProcesses(String storeName, String serviceName, Logger logger) {
        return ManagedService.findManagedProcesses("ManagedService", storeName, serviceName, logger);
    }

    protected static List<Integer> findManagedProcesses(String className, String storeName, String serviceName, Logger logger) {
        ArrayList<Integer> list;
        block4: {
            list = new ArrayList<Integer>();
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add("jps");
                command.add("-m");
                ProcessBuilder builder = new ProcessBuilder(command);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    if (!(line.indexOf(className) < 0 || storeName != null && line.indexOf(storeName) < 0 || serviceName != null && line.indexOf(serviceName) < 0 || line.indexOf("-shutdown") >= 0)) {
                        String[] args = line.split(" ");
                        list.add(new Integer(args[0]));
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                if (logger == null) break block4;
                logger.info("findManagedProcesses exception: " + e.getMessage());
            }
        }
        return list;
    }

    public static void usage() throws IllegalArgumentException {
        System.err.println("Usage: ...ManagedService -root <rootdir> -store <storename> -class <serviceClass> -service <serviceName>");
        throw new IllegalArgumentException("Could not parse ManagedService args");
    }

    public String[] createArgs() {
        int kvNameCount = null == this.kvName ? 0 : 2;
        int secDirCount = null == this.kvSecDir ? 0 : 2;
        String[] args = new String[11 + kvNameCount + secDirCount];
        int i = 0;
        args[i++] = ROOT_FLAG;
        args[i++] = this.kvSNDir.toString();
        if (this.kvSecDir != null) {
            args[i++] = SECDIR_FLAG;
            args[i++] = this.kvSecDir.toString();
        }
        if (this.kvName != null) {
            args[i++] = STORE_FLAG;
            args[i++] = this.kvName;
        }
        args[i++] = CLASS_FLAG;
        args[i++] = this.serviceClass;
        args[i++] = SERVICE_FLAG;
        args[i++] = this.serviceName;
        args[i++] = THREADS_FLAG;
        this.additionalArgs(args, i);
        return args;
    }

    public List<String> addExecArgs(List<String> command) {
        command.add("oracle.kv.impl.sna.ManagedService");
        command.add(ROOT_FLAG);
        command.add(this.kvSNDir.toString());
        if (this.kvSecDir != null) {
            command.add(SECDIR_FLAG);
            command.add(this.kvSecDir.toString());
        }
        if (this.kvName != null) {
            command.add(STORE_FLAG);
            command.add(this.kvName);
        }
        command.add(CLASS_FLAG);
        command.add(this.serviceClass);
        command.add(SERVICE_FLAG);
        command.add(this.serviceName);
        this.additionalExecArgs(command);
        return command;
    }

    public void additionalExecArgs(List<String> command) {
    }

    public int additionalArgs(String[] args, int index) {
        return index;
    }

    public static void main(String[] args) {
        String kvSecDir = null;
        String kvSNDir = null;
        String kvName = null;
        String serviceClass = null;
        String serviceName = null;
        String bootstrapConfigFile = null;
        boolean usingThreads1 = false;
        int argc = 0;
        int nArgs = args.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++]) == null) continue;
            if (thisArg.equals(ROOT_FLAG)) {
                if (argc < nArgs) {
                    kvSNDir = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals(SECDIR_FLAG)) {
                if (argc < nArgs) {
                    kvSecDir = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals("-config")) {
                if (argc < nArgs) {
                    bootstrapConfigFile = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals(STORE_FLAG)) {
                if (argc < nArgs) {
                    kvName = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals(CLASS_FLAG)) {
                if (argc < nArgs) {
                    serviceClass = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals(SERVICE_FLAG)) {
                if (argc < nArgs) {
                    serviceName = args[argc++];
                    continue;
                }
                ManagedService.usage();
                continue;
            }
            if (thisArg.equals(THREADS_FLAG)) {
                usingThreads1 = true;
                continue;
            }
            ManagedService.usage();
        }
        if (kvSNDir == null || serviceClass == null || serviceName == null) {
            ManagedService.usage();
        }
        ManagedService.setUsingThreads(usingThreads1);
        ManagedService ms = null;
        try {
            if (REP_NODE_NAME.equals(serviceClass)) {
                ms = new ManagedRepNode(kvSecDir, kvSNDir, kvName, serviceClass, serviceName);
            } else if (ADMIN_NAME.equals(serviceClass) && serviceName != null) {
                if (serviceName.indexOf(BOOTSTRAP_ADMIN_NAME) >= 0) {
                    if (bootstrapConfigFile == null) {
                        ManagedService.usage();
                    }
                    ms = new ManagedBootstrapAdmin(kvSNDir, kvSecDir, bootstrapConfigFile, serviceName);
                } else {
                    ms = new ManagedAdmin(kvSecDir, kvSNDir, kvName, serviceClass, serviceName);
                }
            } else {
                throw new IllegalArgumentException("Unknown service name " + serviceClass);
            }
            ms.start(usingThreads1);
            if (!usingThreads1) {
                System.err.println("ManagedServiceStarted: " + serviceName);
            }
        }
        catch (Exception e) {
            String msg = "Exception creating service " + serviceName + ": " + e.getMessage() + ": " + LoggerUtils.getStackTrace(e);
            if (ms != null && ms.getLogger() != null) {
                ms.getLogger().severe(msg);
            } else {
                System.err.println(msg);
            }
            System.err.println(msg);
            LoggerUtils.closeAllHandlers();
        }
        System.err.flush();
    }

    static File nullableFile(String fileName) {
        return fileName == null ? null : new File(fileName);
    }
}

