/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.security.ssl.KeyStorePasswordSource;
import oracle.kv.impl.security.util.FileSysUtils;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.FileUtils;

public final class SecurityUtils {
    public static final String KEY_CERT_FILE = "certFileName";
    private static final String CERT_FILE_DEFAULT = "store.cert";
    public static final String KEY_KEY_ALGORITHM = "keyAlgorithm";
    private static final String KEY_ALGORITHM_DEFAULT = "RSA";
    public static final String KEY_KEY_SIZE = "keySize";
    private static final String KEY_SIZE_DEFAULT = "1024";
    public static final String KEY_DISTINGUISHED_NAME = "distinguishedName";
    private static final String DISTINGUISHED_NAME_DEFAULT = "cn=NoSQL";
    public static final String KEY_KEY_ALIAS = "keyAlias";
    private static final String KEY_ALIAS_DEFAULT = "shared";
    public static final String KEY_VALIDITY = "validity";
    private static final String VALIDITY_DEFAULT = "365";
    private static final String KS_PRIVATE_KEY_ENTRY = "PrivateKeyEntry";
    private static final String KS_SECRET_KEY_ENTRY = "SecretKeyEntry";
    private static final String KS_TRUSTED_CERT_ENTRY = "trustedCertEntry";
    private static final String TEMP_CERT_FILE = "temp.cert";

    private SecurityUtils() {
    }

    public static boolean makeOwnerAccessOnly(File f) throws IOException {
        if (!f.exists()) {
            return false;
        }
        FileSysUtils.Operations osOps = FileSysUtils.selectOsOperations();
        return osOps.makeOwnerAccessOnly(f);
    }

    public static boolean makeOwnerOnlyWriteAccess(File f) throws IOException {
        if (!f.exists()) {
            return false;
        }
        FileSysUtils.Operations osOps = FileSysUtils.selectOsOperations();
        return osOps.makeOwnerAccessOnly(f);
    }

    public static boolean passwordsMatch(char[] pwd1, char[] pwd2) {
        if (pwd1 == pwd2) {
            return true;
        }
        if (pwd1 == null || pwd2 == null) {
            return false;
        }
        return Arrays.equals(pwd1, pwd2);
    }

    public static void clearPassword(char[] pwd) {
        if (pwd != null) {
            for (int i = 0; i < pwd.length; ++i) {
                pwd[i] = 32;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initKeyStore(File securityDir, SecurityParams sp, char[] keyStorePassword, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String certFileName = props.getProperty(KEY_CERT_FILE, CERT_FILE_DEFAULT);
        String keyStoreFile = new File(securityDir.getPath(), sp.getKeystoreFile()).getPath();
        String trustStoreFile = new File(securityDir.getPath(), sp.getTruststoreFile()).getPath();
        String certFile = new File(securityDir.getPath(), certFileName).getPath();
        try {
            String keyAlg = props.getProperty(KEY_KEY_ALGORITHM, KEY_ALGORITHM_DEFAULT);
            String keySize = props.getProperty(KEY_KEY_SIZE, KEY_SIZE_DEFAULT);
            String dname = props.getProperty(KEY_DISTINGUISHED_NAME, DISTINGUISHED_NAME_DEFAULT);
            String keyAlias = props.getProperty(KEY_KEY_ALIAS, KEY_ALIAS_DEFAULT);
            String keyStorePasswordStr = new String(keyStorePassword);
            String validityDays = props.getProperty(KEY_VALIDITY, VALIDITY_DEFAULT);
            String[] keyStoreCmds = new String[]{"keytool", "-genkeypair", "-keystore", keyStoreFile, "-storepass", keyStorePasswordStr, "-keypass", keyStorePasswordStr, "-alias", keyAlias, "-dname", dname, "-keyAlg", keyAlg, "-keysize", keySize, "-validity", validityDays};
            int result = SecurityUtils.runCmd(keyStoreCmds);
            if (result != 0) {
                System.err.println("Error creating keyStore: return code " + result);
                return false;
            }
            String[] exportCertCmds = new String[]{"keytool", "-export", "-file", certFile, "-keystore", keyStoreFile, "-storepass", keyStorePasswordStr, "-alias", keyAlias};
            result = SecurityUtils.runCmd(exportCertCmds);
            if (result != 0) {
                System.err.println("Error exporting certificate: return code " + result);
                return false;
            }
            try {
                String[] importCertCmds = new String[]{"keytool", "-import", "-file", certFile, "-keystore", trustStoreFile, "-storepass", keyStorePasswordStr, "-noprompt"};
                result = SecurityUtils.runCmd(importCertCmds);
                if (result != 0) {
                    System.err.println("Error importing certificate to trustStore: return code " + result);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                new File(certFile).delete();
            }
            SecurityUtils.makeOwnerOnlyWriteAccess(new File(keyStoreFile));
            SecurityUtils.makeOwnerOnlyWriteAccess(new File(trustStoreFile));
            return true;
        }
        catch (IOException ioe) {
            System.err.println("IO error encountered: " + ioe.getMessage());
            return false;
        }
    }

    public static boolean mergeTrust(File srcSecDir, File updateSecDir) {
        SecurityParams srcSp = SecurityUtils.loadSecurityParams(srcSecDir);
        String srcTrustFile = new File(srcSecDir, srcSp.getTruststoreFile()).getPath();
        String srcTruststorePwd = new String(SecurityUtils.retrieveKeystorePassword(srcSp));
        List<KeystoreEntry> stEntries = SecurityUtils.listKeystore(new File(srcTrustFile), srcTruststorePwd);
        SecurityParams updateSp = SecurityUtils.loadSecurityParams(updateSecDir);
        String updateTrustFile = new File(updateSecDir, updateSp.getTruststoreFile()).getPath();
        String updateTruststorePwd = new String(SecurityUtils.retrieveKeystorePassword(updateSp));
        List<KeystoreEntry> utEntries = SecurityUtils.listKeystore(new File(updateTrustFile), updateTruststorePwd);
        HashSet<String> utAliasSet = new HashSet<String>();
        for (KeystoreEntry entry : utEntries) {
            utAliasSet.add(entry.getAlias());
        }
        String certFileName = TEMP_CERT_FILE;
        String certFile = new File(srcSecDir.getPath(), TEMP_CERT_FILE).getPath();
        try {
            for (KeystoreEntry entry : stEntries) {
                String[] exportCertCmds = new String[]{"keytool", "-export", "-file", certFile, "-keystore", srcTrustFile, "-storepass", srcTruststorePwd, "-alias", entry.getAlias()};
                int result = SecurityUtils.runCmd(exportCertCmds);
                if (result != 0) {
                    System.err.println("Error exporting certificate: return code " + result);
                    return false;
                }
                String alias = entry.getAlias();
                if (utAliasSet.contains(alias)) {
                    int i = 2;
                    while (true) {
                        String tryAlias;
                        if (!utAliasSet.contains(tryAlias = alias + "_" + i)) {
                            alias = tryAlias;
                            break;
                        }
                        ++i;
                    }
                }
                utAliasSet.add(alias);
                String[] importCertCmds = new String[]{"keytool", "-import", "-file", certFile, "-alias", alias, "-keystore", updateTrustFile, "-storepass", updateTruststorePwd, "-noprompt"};
                result = SecurityUtils.runCmd(importCertCmds);
                if (result == 0) continue;
                System.err.println("Error importing certificate to trustStore: return code " + result);
                return false;
            }
        }
        catch (IOException ioe) {
            System.err.println("Exception " + ioe + " while merging truststore files");
            return false;
        }
        File srcFile = new File(updateTrustFile);
        File dstFile = new File(updateSecDir, "client.trust");
        try {
            SecurityUtils.copyOwnerWriteFile(srcFile, dstFile);
        }
        catch (IOException ioe) {
            System.err.println("Exception " + ioe + " while copying " + srcFile + " to " + dstFile);
            return false;
        }
        return true;
    }

    public static List<KeystoreEntry> listKeystore(File keystoreFile, String storePassword) {
        try {
            String[] keyStoreCmds = new String[]{"keytool", "-list", "-keystore", keystoreFile.getPath(), "-storepass", storePassword};
            ArrayList<String> output = new ArrayList<String>();
            int result = SecurityUtils.runCmd(keyStoreCmds, output);
            if (result != 0) {
                System.err.println("Error listing keyStore: return code " + result);
                return null;
            }
            Pattern keystoreContains = Pattern.compile("Your keystore contains ([0-9]+) entr.*");
            Pattern entryPattern = Pattern.compile("([^,]+),([^,]+, [0-9]+, )([a-zA-Z]+),.*");
            ArrayList<KeystoreEntry> entries = new ArrayList<KeystoreEntry>();
            boolean startFound = false;
            for (String s : output) {
                Matcher m;
                if (!startFound) {
                    m = keystoreContains.matcher(s);
                    if (!m.matches()) continue;
                    startFound = true;
                    continue;
                }
                m = entryPattern.matcher(s);
                if (!m.matches()) continue;
                String entryTypeStr = m.group(3);
                KeystoreEntry.EntryType entryType = entryTypeStr.equals(KS_PRIVATE_KEY_ENTRY) ? KeystoreEntry.EntryType.PRIVATE_KEY : (entryTypeStr.equals(KS_SECRET_KEY_ENTRY) ? KeystoreEntry.EntryType.SECRET_KEY : (entryTypeStr.equals(KS_TRUSTED_CERT_ENTRY) ? KeystoreEntry.EntryType.TRUSTED_CERT : KeystoreEntry.EntryType.OTHER));
                entries.add(new KeystoreEntry(m.group(1), entryType));
            }
            return entries;
        }
        catch (IOException ioe) {
            System.err.println("IO error encountered: " + ioe.getMessage());
            return null;
        }
    }

    public static void copyOwnerWriteFile(File srcFile, File destFile) throws IOException {
        FileUtils.copyFile(srcFile, destFile);
        SecurityUtils.makeOwnerOnlyWriteAccess(destFile);
    }

    static int runCmd(String[] args) throws IOException {
        Process proc = Runtime.getRuntime().exec(args);
        boolean done = false;
        int returnCode = 0;
        while (!done) {
            try {
                returnCode = proc.waitFor();
                done = true;
            }
            catch (InterruptedException e) {}
        }
        return returnCode;
    }

    private static int runCmd(String[] args, List<String> output) throws IOException {
        Process proc = Runtime.getRuntime().exec(args);
        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        boolean done = false;
        while (!done) {
            String s = br.readLine();
            if (s == null) {
                done = true;
                continue;
            }
            output.add(s);
        }
        done = false;
        int returnCode = 0;
        while (!done) {
            try {
                returnCode = proc.waitFor();
                done = true;
            }
            catch (InterruptedException e) {}
        }
        return returnCode;
    }

    public static boolean isLocalHost(String host) throws SocketException {
        try {
            boolean anyLocal = false;
            for (InetAddress hostAddr : InetAddress.getAllByName(host)) {
                if (!SecurityUtils.isLocalAddress(hostAddr)) {
                    return false;
                }
                anyLocal = true;
            }
            return anyLocal;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    private static boolean isLocalAddress(InetAddress address) throws SocketException {
        Enumeration<NetworkInterface> netIfs = NetworkInterface.getNetworkInterfaces();
        while (netIfs.hasMoreElements()) {
            NetworkInterface netIf = netIfs.nextElement();
            if (SecurityUtils.isLocalAddress(netIf, address)) {
                return true;
            }
            Enumeration<NetworkInterface> subIfs = netIf.getSubInterfaces();
            while (subIfs.hasMoreElements()) {
                if (!SecurityUtils.isLocalAddress(subIfs.nextElement(), address)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLocalAddress(NetworkInterface netIf, InetAddress address) {
        Enumeration<InetAddress> addrs = netIf.getInetAddresses();
        while (addrs.hasMoreElements()) {
            InetAddress addr = addrs.nextElement();
            if (!addr.equals(address)) continue;
            return true;
        }
        return false;
    }

    public static SecurityParams loadSecurityParams(File secDir) {
        File secFile = new File(secDir, "security.xml");
        return ConfigUtils.getSecurityParams(secFile);
    }

    private static char[] retrieveKeystorePassword(SecurityParams sp) {
        KeyStorePasswordSource pwdSrc = KeyStorePasswordSource.create(sp);
        return pwdSrc == null ? null : pwdSrc.getPassword();
    }

    public static class KeystoreEntry {
        private String alias;
        private EntryType entryType;

        public KeystoreEntry(String alias, EntryType entryType) {
            this.alias = alias;
            this.entryType = entryType;
        }

        String getAlias() {
            return this.alias;
        }

        EntryType getEntryType() {
            return this.entryType;
        }

        public static enum EntryType {
            PRIVATE_KEY,
            SECRET_KEY,
            TRUSTED_CERT,
            OTHER;

        }
    }
}

