/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.io.File;
import java.io.IOException;
import oracle.kv.impl.security.util.SecurityUtils;

public final class FileSysUtils {
    private FileSysUtils() {
    }

    public static Operations selectOsOperations() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0 || os.indexOf("sunos") >= 0) {
            return new JavaAPIOperations();
        }
        if (os.indexOf("win") >= 0) {
            return new WindowsCmdLineOperations();
        }
        return new JavaAPIOperations();
    }

    static class WindowsCmdLineOperations
    implements Operations {
        WindowsCmdLineOperations() {
        }

        @Override
        public boolean makeOwnerAccessOnly(File f) throws IOException {
            throw new UnsupportedOperationException("operation not supported on the windows platform");
        }

        @Override
        public boolean makeOwnerOnlyWriteAccess(File f) {
            throw new UnsupportedOperationException("operation not supported on the windows platform");
        }
    }

    static class XNixCmdLineOperations
    implements Operations {
        XNixCmdLineOperations() {
        }

        @Override
        public boolean makeOwnerAccessOnly(File f) throws IOException {
            int oChmodResult = SecurityUtils.runCmd(new String[]{"chmod", "o-rwx", f.getPath()});
            int gChmodResult = SecurityUtils.runCmd(new String[]{"chmod", "g-rwx", f.getPath()});
            return oChmodResult == 0 && gChmodResult == 0;
        }

        @Override
        public boolean makeOwnerOnlyWriteAccess(File f) throws IOException {
            int oChmodResult = SecurityUtils.runCmd(new String[]{"chmod", "o-w", f.getPath()});
            int gChmodResult = SecurityUtils.runCmd(new String[]{"chmod", "g-w", f.getPath()});
            return oChmodResult == 0 && gChmodResult == 0;
        }
    }

    static class JavaAPIOperations
    implements Operations {
        JavaAPIOperations() {
        }

        @Override
        public boolean makeOwnerAccessOnly(File f) throws IOException {
            boolean result = f.setReadable(false, false);
            result = result && f.setWritable(false, false);
            result = result && f.setReadable(true, true);
            result = result && f.setWritable(true, true);
            return result;
        }

        @Override
        public boolean makeOwnerOnlyWriteAccess(File f) {
            boolean result = f.setWritable(false, false);
            return f.setWritable(true, true) && result;
        }
    }

    public static interface Operations {
        public boolean makeOwnerAccessOnly(File var1) throws IOException;

        public boolean makeOwnerOnlyWriteAccess(File var1) throws IOException;
    }
}

