/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.io.Serializable;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public abstract class SecurityMDChange
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected int seqNum = 0;

    SecurityMDChange(int seqNum) {
        this.seqNum = seqNum;
    }

    private SecurityMDChange() {
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    abstract SecurityMetadata.SecurityElementType getElementType();

    abstract SecurityMDChangeType getChangeType();

    abstract SecurityMetadata.SecurityElement getElement();

    abstract String getElementId();

    public abstract SecurityMDChange clone();

    public static class Remove
    extends SecurityMDChange {
        private static final long serialVersionUID = 1L;
        private String elementId;
        private SecurityMetadata.SecurityElementType elementType;

        public Remove(String removedId, SecurityMetadata.SecurityElementType eType) {
            this.elementId = removedId;
            this.elementType = eType;
        }

        private Remove(int seqNum, String removedId, SecurityMetadata.SecurityElementType eType) {
            super(seqNum);
            this.elementId = removedId;
            this.elementType = eType;
        }

        @Override
        SecurityMDChangeType getChangeType() {
            return SecurityMDChangeType.REMOVE;
        }

        @Override
        SecurityMetadata.SecurityElement getElement() {
            return null;
        }

        @Override
        String getElementId() {
            return this.elementId;
        }

        @Override
        SecurityMetadata.SecurityElementType getElementType() {
            return this.elementType;
        }

        @Override
        public Remove clone() {
            return new Remove(this.seqNum, this.elementId, this.elementType);
        }
    }

    public static class Add
    extends Update {
        private static final long serialVersionUID = 1L;

        public Add(SecurityMetadata.SecurityElement element) {
            super(element);
        }

        private Add(int seqNum, SecurityMetadata.SecurityElement element) {
            super(seqNum, element);
        }

        @Override
        SecurityMDChangeType getChangeType() {
            return SecurityMDChangeType.ADD;
        }

        @Override
        public Add clone() {
            return new Add(this.seqNum, this.element.clone());
        }
    }

    public static class Update
    extends SecurityMDChange {
        private static final long serialVersionUID = 1L;
        SecurityMetadata.SecurityElement element;

        public Update(SecurityMetadata.SecurityElement element) {
            this.element = element;
        }

        private Update(int seqNum, SecurityMetadata.SecurityElement element) {
            super(seqNum);
            this.element = element;
        }

        @Override
        SecurityMDChangeType getChangeType() {
            return SecurityMDChangeType.UPDATE;
        }

        @Override
        SecurityMetadata.SecurityElement getElement() {
            return this.element;
        }

        @Override
        String getElementId() {
            return this.element.getElementId();
        }

        @Override
        SecurityMetadata.SecurityElementType getElementType() {
            return this.element.getElementType();
        }

        @Override
        public Update clone() {
            return new Update(this.seqNum, this.element.clone());
        }
    }

    public static enum SecurityMDChangeType {
        ADD,
        UPDATE,
        REMOVE;

    }
}

