/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.metadata.PasswordHashDigest;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class KVStoreUser
extends SecurityMetadata.SecurityElement {
    private static final long serialVersionUID = 1L;
    private final String userName;
    private UserType userType = UserType.LOCAL;
    private PasswordHashDigest primaryPassword;
    private PasswordHashDigest retainedPassword;
    private boolean enabled;
    private boolean isAdmin;

    public KVStoreUser(String name) {
        this.userName = name;
    }

    private KVStoreUser(KVStoreUser other) {
        super(other);
        this.userName = other.userName;
        this.userType = other.userType;
        this.enabled = other.enabled;
        this.isAdmin = other.isAdmin;
        this.primaryPassword = other.primaryPassword == null ? null : other.primaryPassword.clone();
        this.retainedPassword = other.retainedPassword == null ? null : other.retainedPassword.clone();
    }

    KVStoreUser setUserType(UserType type) {
        this.userType = type;
        return this;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getName() {
        return this.userName;
    }

    public KVStoreUser setPassword(PasswordHashDigest primaryPasswd) {
        this.primaryPassword = primaryPasswd;
        return this;
    }

    public KVStoreUser retainPassword() {
        if (this.retainedPasswordValid()) {
            throw new IllegalStateException("Could not override an existing retained password.");
        }
        this.retainedPassword = this.primaryPassword;
        this.retainedPassword.refreshCreateTime();
        return this;
    }

    public PasswordHashDigest getPassword() {
        return this.primaryPassword;
    }

    public PasswordHashDigest getRetainedPassword() {
        return this.retainedPassword;
    }

    public void clearRetainedPassword() {
        this.retainedPassword = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean retainedPasswordValid() {
        return this.retainedPassword != null && !this.retainedPassword.isExpired();
    }

    public KVStoreUser setAdmin(boolean flag) {
        this.isAdmin = flag;
        return this;
    }

    public KVStoreUser setEnabled(boolean flag) {
        this.enabled = flag;
        return this;
    }

    public UserDescription getDescription() {
        String retainInfo;
        boolean rPassActive = this.retainedPasswordValid();
        if (rPassActive) {
            String expireInfo = String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(this.retainedPassword.getLifeTime()));
            retainInfo = String.format("active [expiration: %s]", expireInfo);
        } else {
            retainInfo = "inactive";
        }
        String details = String.format("%s enabled=%b type=%s admin=%b retain-passwd=%s", new Object[]{this.toString(), this.enabled, this.userType, this.isAdmin, retainInfo});
        return new UserDescription(this.toString(), details);
    }

    public boolean verifyPassword(char[] password) {
        if (password == null || password.length == 0) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        return this.getPassword().verifyPassword(password) || this.retainedPasswordValid() && this.getRetainedPassword().verifyPassword(password);
    }

    public Subject makeKVSubject() {
        String userId = this.getElementId();
        HashSet<Principal> userPrincipals = new HashSet<Principal>();
        userPrincipals.add(KVStoreRolePrincipal.AUTHENTICATED);
        if (this.isAdmin) {
            userPrincipals.add(KVStoreRolePrincipal.ADMIN);
        }
        userPrincipals.add(new KVStoreUserPrincipal(this.userName, userId));
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, userPrincipals, publicCreds, privateCreds);
    }

    @Override
    public SecurityMetadata.SecurityElementType getElementType() {
        return SecurityMetadata.SecurityElementType.KVSTOREUSER;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 527 + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KVStoreUser)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        KVStoreUser other = (KVStoreUser)obj;
        if (this.userName == null) {
            return other.userName == null;
        }
        return this.userName.equals(other.userName);
    }

    public String toString() {
        return String.format("id=%s name=%s", super.getElementId(), this.userName);
    }

    @Override
    public KVStoreUser clone() {
        return new KVStoreUser(this);
    }

    public static class UserDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String brief;
        private final String details;

        public UserDescription(String brief, String details) {
            this.brief = brief;
            this.details = details;
        }

        public String brief() {
            return this.brief;
        }

        public String details() {
            return this.details;
        }
    }

    public static enum UserType {
        LOCAL;

    }
}

