/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.KVSecurityException;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.security.login.UserLoginHandler;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;

@SecureAPI
public class UserLoginImpl
extends VersionedRemoteImpl
implements UserLogin {
    private final UserLoginHandler loginHandler;
    private final ProcessFaultHandler faultHandler;
    private final Logger logger;

    public UserLoginImpl(ProcessFaultHandler faultHandler, UserLoginHandler loginHandler, Logger logger) {
        this.loginHandler = loginHandler;
        this.faultHandler = faultHandler;
        this.logger = logger;
    }

    @Override
    @PublicMethod
    public LoginResult login(final LoginCredentials creds, short serialVersion) throws AuthenticationFailureException, RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoginResult>(){

            @Override
            public LoginResult execute() {
                try {
                    return UserLoginImpl.this.loginHandler.login(creds, UserLoginImpl.this.getClientHost());
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public LoginResult proxyLogin(final ProxyCredentials creds, final AuthContext authContext, short serialVersion) throws AuthenticationFailureException, SessionAccessException, RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoginResult>(){

            @Override
            public LoginResult execute() {
                try {
                    return UserLoginImpl.this.loginHandler.proxyLogin(creds, authContext.getClientHost());
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
            }
        });
    }

    @Override
    @PublicMethod
    public LoginToken requestSessionExtension(final LoginToken loginToken, short serialVersion) throws SessionAccessException, RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoginToken>(){

            @Override
            public LoginToken execute() {
                try {
                    return UserLoginImpl.this.loginHandler.requestSessionExtension(loginToken);
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
                catch (SessionAccessException sae) {
                    throw sae;
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public Subject validateLoginToken(final LoginToken loginToken, AuthContext authCtx, short serialVersion) throws SessionAccessException, RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Subject>(){

            @Override
            public Subject execute() {
                try {
                    return UserLoginImpl.this.loginHandler.validateLoginToken(loginToken);
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
            }
        });
    }

    @Override
    @PublicMethod
    public void logout(final LoginToken loginToken, short serialVersion) throws AuthenticationRequiredException, SessionAccessException, RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                try {
                    UserLoginImpl.this.loginHandler.logout(loginToken);
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
                catch (SessionAccessException sae) {
                    throw sae;
                }
            }
        });
    }

    private String getClientHost() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException snae) {
            this.logger.log(Level.SEVERE, "RemoteServer.getClientHost failed: ({0})", snae.getMessage());
            return null;
        }
    }
}

